/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor;

import coldfusion.monitor.Configuration;
import coldfusion.monitor.aliasing.AliasDetail;
import java.util.List;

public class MonitorSettings {
    private volatile boolean monitoringEnabled;
    private volatile boolean cfMemoryMonitoringEnabled;
    private volatile boolean cfadminMonitoringEnabled;
    private long nonRequestTaskInterval = 1L;
    private long timeStamp;
    private List<String> includeList;
    private List<String> excludeList;
    private List<AliasDetail> aliasList;
    private AdvancedMonitoring advancedMonitoring;
    private BasicMonitoring basicMonitoring;
    private boolean enableAutoTune;
    private double autoTuneThreshold;
    private double poolIncreaseRatio;
    private double poolUpperLimit = 2000.0;
    private Long timezoneOffset;
    private long responseTimeThreshold = 0L;

    public long getResponseTimeThreshold() {
        return this.responseTimeThreshold;
    }

    public void setResponseTimeThreshold(long responseTimeThreshold) {
        this.responseTimeThreshold = responseTimeThreshold;
    }

    public double getPoolUpperLimit() {
        return this.poolUpperLimit;
    }

    public void setPoolUpperLimit(double poolUpperLimit) {
        this.poolUpperLimit = poolUpperLimit;
    }

    public double getPoolIncreaseRatio() {
        return this.poolIncreaseRatio;
    }

    public void setPoolIncreaseRatio(double poolIncreaseRatio) {
        this.poolIncreaseRatio = poolIncreaseRatio;
    }

    public double getAutoTuneThreshold() {
        return this.autoTuneThreshold;
    }

    public void setAutoTuneThreshold(double autoTuneThreshold) {
        this.autoTuneThreshold = autoTuneThreshold;
    }

    public boolean isEnableAutoTune() {
        return this.enableAutoTune;
    }

    public void setEnableAutoTune(boolean enableAutoTune) {
        this.enableAutoTune = enableAutoTune;
    }

    public long getNonRequestTaskInterval() {
        return this.nonRequestTaskInterval;
    }

    public void setNonRequestTaskInterval(long interval) {
        this.nonRequestTaskInterval = interval;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public List<String> getIncludeList() {
        return this.includeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIncludeList(List<String> includeList) {
        List<String> list = includeList;
        synchronized (list) {
            this.includeList = includeList;
        }
    }

    public List<String> getExcludeList() {
        return this.excludeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExcludeList(List<String> excludeList) {
        List<String> list = excludeList;
        synchronized (list) {
            this.excludeList = excludeList;
        }
    }

    public boolean isCfMemoryMonitoringEnabled() {
        return this.cfMemoryMonitoringEnabled;
    }

    public void setCfMemoryMonitoringEnabled(boolean cfMemoryMonitoringEnabled) {
        this.cfMemoryMonitoringEnabled = cfMemoryMonitoringEnabled;
    }

    public boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public void setMonitoringEnabled(boolean enabled) {
        this.monitoringEnabled = enabled;
    }

    public boolean isCfadminMonitoringEnabled() {
        return this.cfadminMonitoringEnabled;
    }

    public void setCfadminMonitoringEnabled(boolean cfadminMonitoringEnabled) {
        this.cfadminMonitoringEnabled = cfadminMonitoringEnabled;
    }

    public List<AliasDetail> getAliasList() {
        return this.aliasList;
    }

    public void setAliasList(List<AliasDetail> aliasList) {
        this.aliasList = aliasList;
    }

    public AdvancedMonitoring getAdvancedMonitoring() {
        if (this.advancedMonitoring == null) {
            this.advancedMonitoring = new AdvancedMonitoring();
        }
        return this.advancedMonitoring;
    }

    public BasicMonitoring getBasicMonitoring() {
        if (this.basicMonitoring == null) {
            this.basicMonitoring = new BasicMonitoring();
        }
        return this.basicMonitoring;
    }

    public Long getTimezoneOffset() {
        return this.timezoneOffset;
    }

    public void setTimezoneOffset(Long timezoneOffset) {
        this.timezoneOffset = timezoneOffset;
    }

    public static class AdvancedMonitoring {
        boolean enabled;
        boolean tagMetrics;
        boolean udfMetrics;
        boolean cachingMetrics;
        boolean externalServicesMetrics;
        boolean graphqlMetrics;
        boolean asynchMetrics;
        boolean jitMetrics;
        boolean aliasMetrics;
        boolean cloudServiceMetrics;
        boolean queryMetrics;
        long metricsCollectionInterval;
        boolean classloadingMetrics;
        boolean sessionMetrics;
        boolean threadpoolMetrics;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isJitMetrics() {
            return this.jitMetrics;
        }

        public void setJitMetrics(boolean jitMetrics) {
            this.jitMetrics = jitMetrics;
        }

        public boolean isGraphqlMetricsEnabled() {
            return this.graphqlMetrics;
        }

        public void setGraphqlMetrics(boolean graphqlMetrics) {
            this.graphqlMetrics = graphqlMetrics;
        }

        public long getMetricsCollectionInterval() {
            return this.metricsCollectionInterval;
        }

        public void setMetricsCollectionInterval(long interval) {
            this.metricsCollectionInterval = interval;
        }

        public boolean isTagMetrics() {
            return this.tagMetrics || Configuration.INSTANCE.isCodeProfilerOn();
        }

        public void setTagMetrics(boolean tagMetrics) {
            this.tagMetrics = tagMetrics;
        }

        public boolean isUdfMetrics() {
            return this.udfMetrics || Configuration.INSTANCE.isCodeProfilerOn();
        }

        public void setUdfMetrics(boolean udfMetrics) {
            this.udfMetrics = udfMetrics;
        }

        public boolean isCachingMetrics() {
            return this.cachingMetrics || Configuration.INSTANCE.isCodeProfilerOn();
        }

        public void setCachingMetrics(boolean cachingMetrics) {
            this.cachingMetrics = cachingMetrics;
        }

        public boolean isExternalServicesMetrics() {
            return this.externalServicesMetrics || Configuration.INSTANCE.isCodeProfilerOn();
        }

        public void setExternalServicesMetrics(boolean externalServicesMetrics) {
            this.externalServicesMetrics = externalServicesMetrics;
        }

        public boolean isCloudServiceMetrics() {
            return this.cloudServiceMetrics || Configuration.INSTANCE.isCodeProfilerOn();
        }

        public void setCloudServiceMetrics(boolean cloudServiceMetrics) {
            this.cloudServiceMetrics = cloudServiceMetrics;
        }

        public boolean isQueryMetrics() {
            return this.queryMetrics || Configuration.INSTANCE.isCodeProfilerOn();
        }

        public void setQueryMetrics(boolean queryMetrics) {
            this.queryMetrics = queryMetrics;
        }

        public boolean isAsynchMetrics() {
            return this.asynchMetrics || Configuration.INSTANCE.isCodeProfilerOn();
        }

        public void setAsynchMetrics(boolean asynchMetrics) {
            this.asynchMetrics = asynchMetrics;
        }

        public boolean isAliasMetrics() {
            return this.aliasMetrics || Configuration.INSTANCE.isCodeProfilerOn();
        }

        public void setAliasMetrics(boolean aliasMetrics) {
            this.aliasMetrics = aliasMetrics;
        }

        public boolean isClassLoadingMetrics() {
            return this.classloadingMetrics || Configuration.INSTANCE.isCodeProfilerOn();
        }

        public void setClassLoadingMetrics(boolean classLoadingMetrics) {
            this.classloadingMetrics = classLoadingMetrics;
        }

        public boolean isSessionMetrics() {
            return this.sessionMetrics || Configuration.INSTANCE.isCodeProfilerOn();
        }

        public void setSessionMetrics(boolean sessionMetrics) {
            this.sessionMetrics = sessionMetrics;
        }

        public boolean isThreadPoolsMetrics() {
            return this.threadpoolMetrics || Configuration.INSTANCE.isCodeProfilerOn();
        }

        public void setThreadPoolsMetrics(boolean threadPoolsMetrics) {
            this.threadpoolMetrics = threadPoolsMetrics;
        }
    }

    public static class BasicMonitoring {
        boolean memoryPoolMetrics;
        boolean cfMetrics;
        boolean gcMetrics;
        boolean dbMonitoring;

        public boolean isMemoryPoolMetrics() {
            return this.memoryPoolMetrics || Configuration.INSTANCE.isCodeProfilerOn();
        }

        public void setMemoryPoolMetrics(boolean memoryPoolMetrics) {
            this.memoryPoolMetrics = memoryPoolMetrics;
        }

        public boolean isCfmetrics() {
            return this.cfMetrics || Configuration.INSTANCE.isCodeProfilerOn();
        }

        public void setCfmetrics(boolean cfmetrics) {
            this.cfMetrics = cfmetrics;
        }

        public boolean isGcmetrics() {
            return this.gcMetrics || Configuration.INSTANCE.isCodeProfilerOn();
        }

        public void setGcmetrics(boolean gcmetrics) {
            this.gcMetrics = gcmetrics;
        }

        public boolean isDbmonitoring() {
            return this.dbMonitoring || Configuration.INSTANCE.isCodeProfilerOn();
        }

        public void setDbmonitoring(boolean dbmonitoring) {
            this.dbMonitoring = dbmonitoring;
        }
    }
}

