/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.active.ActiveRequestMonitor;
import coldfusion.monitor.beans.ESDetails;
import coldfusion.monitor.datastore.Client;
import coldfusion.monitor.datastore.JSONConverter;
import coldfusion.monitor.memory.MemoryMonitor;
import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.monitor.scheduler.HeapDump;
import coldfusion.monitor.scheduler.TaskScheduler;
import coldfusion.monitor.threaddump.ThreadDumpUtil;
import coldfusion.monitor.util.ThreadType;
import coldfusion.runtime.ProtectedScope;
import coldfusion.server.MonitoringService;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.io.cache.CacheTagHelper;
import coldfusion.util.RB;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PMSGenericServlet
extends HttpServlet {
    private static final long serialVersionUID = -7602315247902686403L;
    private Logger logger = CFLogs.MONITOR_LOG;
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]+$");

    public void init() {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block15: {
            if (!this.validateSecret(request)) {
                response.setStatus(403);
                this.logger.error("Invalid secret provided");
                return;
            }
            if (ServiceFactory.getMonitoringService() == null) {
                response.setStatus(501);
                response.getWriter().print(StringUtils.replacePattern((String)RB.getString(PMSGenericServlet.class, "moduleerror", (Object)request.getServerName(), (Object)request.getServerPort()), (String)"\"", (String)""));
                return;
            }
            if (!Configuration.INSTANCE.isMonitoringEnabled()) {
                response.setStatus(501);
                response.getWriter().print(RB.getString(PMSGenericServlet.class, "pmtnotconfigured"));
                return;
            }
            try {
                response.setContentType("application/json");
                String module = request.getParameter("module");
                this.logger.debug("invoked by PMS for module " + module);
                if ("code_profiler".equals(module)) {
                    this.stopCodeProfilerModule(request, response);
                    break block15;
                }
                if ("active_request_monitor".equals(module)) {
                    this.invokeActiveMonitoringModule(request, response);
                    break block15;
                }
                if ("ping".equals(module)) {
                    this.invokePingModule(request, response);
                    break block15;
                }
                if ("thread_dump".equals(module)) {
                    this.invokeThreadDumpModule(request, response);
                    break block15;
                }
                if ("heap_dump".equals(module)) {
                    this.invokeHeapDumpModule(request, response);
                    break block15;
                }
                if ("gc".equals(module)) {
                    this.invokeGC(request, response);
                    break block15;
                }
                if ("caching".equals(module)) {
                    this.invokeCachingModule(request, response);
                    break block15;
                }
                if ("memory_monitor".equals(module)) {
                    this.invokeMemoryMonitoringModule(request, response);
                    break block15;
                }
                if (!"disable_monitoring".equals(module)) break block15;
                try {
                    Configuration.INSTANCE.clearStaticList();
                    ServiceFactory.getMonitoringService().stopMonitoring();
                    ServiceFactory.getMonitoringService().setBlankEsSetting("", 0);
                    response.setStatus(200);
                    response.getWriter().print("Successfully stopped monitoring.");
                }
                catch (Exception e) {
                    response.setStatus(500);
                    response.getWriter().print("Error stopping monitoring service");
                    this.logger.error("Exception while stopping CF node ", e);
                    return;
                }
            }
            catch (Throwable e) {
                this.logger.error("Exception while performing action on CF node ", e);
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            if (!this.validateSecret(request)) {
                response.setStatus(403);
                this.logger.error("Invalid secret provided");
                return;
            }
            if (ServiceFactory.getMonitoringService() == null) {
                response.setStatus(501);
                response.getWriter().print(StringUtils.replacePattern((String)RB.getString(PMSGenericServlet.class, "moduleerror", (Object)request.getServerName(), (Object)request.getServerPort()), (String)"\"", (String)""));
                return;
            }
            String module = request.getParameter("module");
            if (!"setup_monitoring".equals(module) && !Configuration.INSTANCE.isMonitoringEnabled()) {
                response.setStatus(501);
                response.getWriter().print(RB.getString(PMSGenericServlet.class, "pmtnotconfigured"));
                return;
            }
            response.setContentType("application/json");
            this.logger.trace("invoked by PMS for module " + module);
            if ("setup_monitoring".equals(module)) {
                List<ESDetails> esList = this.getESList(request, response);
                if (esList != null && !esList.isEmpty()) {
                    ESDetails esDetails = esList.get(0);
                    if (!this.validateVersionCompatibility(esDetails.getCFSupportedVersions())) {
                        response.setStatus(500);
                        response.getWriter().print(StringUtils.replacePattern((String)RB.getString(PMSGenericServlet.class, "versionerror"), (String)"\"", (String)""));
                        return;
                    }
                    if (!Client.get().validateUrl(esDetails)) {
                        response.setStatus(500);
                        response.getWriter().print(StringUtils.replacePattern((String)RB.getString(PMSGenericServlet.class, "eserror", (Object)esDetails.getElasticSearchHost(), (Object)esDetails.getElsaticSearchPort()), (String)"\"", (String)""));
                    } else {
                        boolean intializeNodeWithEs;
                        boolean standaloneCF = ServiceFactory.getMonitoringService().isStandaloneCF();
                        if (!standaloneCF) {
                            String contextPath = request.getContextPath();
                            boolean httpsEnabled = false;
                            if ("https".equals(request.getParameter("protocol"))) {
                                httpsEnabled = true;
                            }
                            if (contextPath.length() > 1) {
                                contextPath = contextPath.substring(1);
                            } else if (contextPath.length() == 1 && "/".equals(contextPath)) {
                                contextPath = "";
                            }
                            String hostname = request.getServerName();
                            int serverPort = request.getServerPort();
                            this.logger.debug("hostname: " + hostname + " serverPort: " + serverPort + " contextPath: " + contextPath);
                            ServiceFactory.getMonitoringService().updateJ2eeHostPort(hostname, serverPort, contextPath, httpsEnabled);
                        }
                        if (!(intializeNodeWithEs = ServiceFactory.getMonitoringService().intializeNodeWithEs(esDetails, request.getServerPort())) && !Client.get().isInitialized()) {
                            response.setStatus(500);
                            response.getWriter().print(StringUtils.replacePattern((String)RB.getString(PMSGenericServlet.class, "errorintializing"), (String)"\"", (String)""));
                        } else {
                            Configuration.INSTANCE.setPMTDashboardUrl(esDetails.getPMTDashboardUrl());
                            response.getWriter().print("Monitoring service configured successfully.");
                            response.getWriter().flush();
                        }
                    }
                }
            } else if ("code_profiler".equals(module)) {
                this.startCodeProfilerModule(request, response);
            }
        }
        catch (Throwable e) {
            this.logger.error("Exception while performing action on CF node ", e);
        }
    }

    private boolean validateVersionCompatibility(List<String> cfSupportedVersions) {
        RuntimeService runtimeService = ServiceFactory.getRuntimeService();
        ProtectedScope scope = (ProtectedScope)runtimeService.getServerScope().get("coldfusion");
        String cfVersion = ((String)scope.get("productversion")).split(",")[0];
        return cfSupportedVersions == null || cfSupportedVersions.size() == 0 ? cfVersion.equalsIgnoreCase("2018") : cfSupportedVersions.contains(cfVersion);
    }

    private boolean validateSecret(HttpServletRequest request) {
        String uuid = request.getHeader("uuid");
        return uuid != null && uuid.equalsIgnoreCase(Configuration.INSTANCE.getUuid());
    }

    private List<ESDetails> getESList(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        StringBuffer jb = new StringBuffer();
        String line = null;
        try {
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
                jb.append(line);
            }
        }
        catch (Exception e) {
            throw new ServletException("Error reading the post message");
        }
        return JSONConverter.getAllNodes(JSONConverter.INSTANCE.toJsonNode(jb.toString()), null, ESDetails.class);
    }

    private void invokeCachingModule(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String type = request.getParameter("type");
        if (!this.validateParameter("type", type, response)) {
            return;
        }
        if ("server".equals(type)) {
            String regionCache = JSONConverter.toJson(CacheTagHelper.getAllServerCacheMetatdata());
            this.logger.debug("caching result for server regions " + regionCache);
            response.getWriter().print(regionCache);
        } else if ("app".equals(type)) {
            String app = request.getParameter("app_name");
            String appCache = JSONConverter.toJson(CacheTagHelper.getApplicationCacheMetadata(app));
            response.getWriter().print(appCache);
            this.logger.debug("application list returned is " + appCache);
        } else if ("applist".equals(type)) {
            String appList = JSONConverter.toJson(CacheTagHelper.getAllApplicationList());
            response.getWriter().print(appList);
            this.logger.debug("application list returned is " + appList);
        }
    }

    private void invokeHeapDumpModule(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String action = request.getParameter("action");
        if (!this.validateParameter("action", action, response)) {
            return;
        }
        if ("take".equals(action)) {
            String userName = request.getParameter("username");
            if (!this.validateParameter("username", userName, response)) {
                return;
            }
            String heapDumpId = userName + "-" + System.currentTimeMillis();
            HeapDump.dumpHeap(heapDumpId + ".hprof", true);
            HeapDump.pushHeapDumpInfoToDataSource(heapDumpId, userName);
            response.getWriter().print(ServiceFactory.getRuntimeService().getRootDir() + File.separator + "bin" + File.separator + heapDumpId + ".hprof");
        }
    }

    private void invokeGC(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String action = request.getParameter("action");
        if (!this.validateParameter("action", action, response)) {
            return;
        }
        if ("take".equals(action)) {
            boolean gcDone = false;
            try {
                MonitoringService ms = ServiceFactory.getMonitoringService();
                if (ms != null) {
                    ms.callGC();
                    gcDone = true;
                }
            }
            catch (Exception ex) {
                gcDone = false;
            }
            response.getWriter().print(String.valueOf(gcDone));
        }
    }

    private void invokeMemoryMonitoringModule(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String scope = request.getParameter("scope");
        if (!this.validateParameter("scope", scope, response)) {
            return;
        }
        if ("server".equals(scope)) {
            response.getWriter().print(JSONConverter.toJson(MemoryMonitor.INSTANCE.getServerScopeMemoryUsed(true)));
        } else if ("application".equals(scope)) {
            response.getWriter().print(JSONConverter.toJson(MemoryMonitor.INSTANCE.getAllApplicationScopeMemoryUsed()));
        } else if ("session".equals(scope)) {
            response.getWriter().print(JSONConverter.toJson(ActiveRequestMonitor.INSTANCE.getAllActiveSessions(null)));
        } else if ("all".equalsIgnoreCase(scope)) {
            response.getWriter().print(JSONConverter.toJson(MemoryMonitor.INSTANCE.getMemoryUtilizationSummary()));
        }
    }

    private void stopCodeProfilerModule(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String userName;
        String event = request.getParameter("event");
        if (!this.validateParameter("event", event, response)) {
            return;
        }
        boolean profileMemory = Boolean.parseBoolean(request.getParameter("profile_memory"));
        boolean isMemoryMonitoringOn = Configuration.INSTANCE.getMonitorSettings().isCfMemoryMonitoringEnabled();
        if (profileMemory) {
            Configuration.INSTANCE.getMonitorSettings().setCfMemoryMonitoringEnabled(profileMemory);
            Configuration.INSTANCE.setMemoryProfilerOn(profileMemory);
            MemoryTrackerProxy.setEnabled(profileMemory);
        }
        if (!this.validateParameter("username", userName = request.getParameter("username"), response)) {
            return;
        }
        this.logger.debug("event? " + event + " memory monitoring enabled? " + profileMemory);
        if (!Configuration.INSTANCE.isCodeProfilerOn()) {
            this.logger.debug("profiling is not running..unable to stop");
            response.getWriter().print(2);
        } else if (!Configuration.INSTANCE.getProfileId().startsWith(userName)) {
            this.logger.debug("Unauthorized : Profiling with id " + Configuration.INSTANCE.getProfileId() + " can't be stopped by user " + userName);
            response.getWriter().print(1);
        } else {
            Configuration.INSTANCE.stopProfiling();
            Configuration.INSTANCE.getMonitorSettings().setCfMemoryMonitoringEnabled(isMemoryMonitoringOn);
            Configuration.INSTANCE.setMemoryProfilerOn(false);
            MemoryTrackerProxy.setEnabled(isMemoryMonitoringOn);
            this.logger.debug("Profiling with id " + Configuration.INSTANCE.getProfileId() + " is off..");
            response.getWriter().print(0);
        }
    }

    private void startCodeProfilerModule(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String event = request.getParameter("event");
        String[] urlList = null;
        List<String> inputList = this.getURLAndApplicationList(request, response);
        if ("START".equals(event)) {
            String userName;
            String profileType = request.getParameter("profile_type");
            String threshold = request.getParameter("threshold") == null ? "0" : request.getParameter("threshold");
            long responseTimeThreshold = Long.parseLong(threshold);
            String[] appsList = null;
            if ("application".equals(profileType)) {
                appsList = inputList.toArray(new String[0]);
            } else if ("url".equals(profileType) && !inputList.isEmpty()) {
                urlList = inputList.toArray(new String[0]);
            }
            boolean profileMemory = Boolean.parseBoolean(request.getParameter("profile_memory"));
            boolean isMemoryMonitoringOn = Configuration.INSTANCE.getMonitorSettings().isCfMemoryMonitoringEnabled();
            if (profileMemory) {
                Configuration.INSTANCE.getMonitorSettings().setCfMemoryMonitoringEnabled(profileMemory);
                Configuration.INSTANCE.setMemoryProfilerOn(profileMemory);
                MemoryTrackerProxy.setEnabled(profileMemory);
            }
            if (!this.validateParameter("username", userName = request.getParameter("username"), response)) {
                return;
            }
            String profilingId = userName + ":" + UUID.randomUUID().toString();
            this.logger.debug("event? " + event + " memory monitoring enabled? " + profileMemory);
            if (Configuration.INSTANCE.isCodeProfilerOn()) {
                response.getWriter().print(Configuration.INSTANCE.getProfileId());
                this.logger.debug("Profiling with id " + profilingId + " is on.." + Configuration.INSTANCE.getProfileId());
                return;
            }
            if (urlList != null) {
                Configuration.INSTANCE.startProfiling("URL", profilingId, responseTimeThreshold);
                Configuration.INSTANCE.setListToProfile(urlList);
                this.logger.debug("Profiling with URL List " + urlList.toString());
            } else if (appsList != null) {
                Configuration.INSTANCE.startProfiling("APPLICATION", profilingId, responseTimeThreshold);
                Configuration.INSTANCE.setListToProfile(appsList);
                this.logger.debug("Profiling with application List ");
            } else {
                Configuration.INSTANCE.startProfiling("SERVER", profilingId, responseTimeThreshold);
                this.logger.warn("Server level code profiling is ON ");
            }
            response.getWriter().print(profilingId);
        } else if ("add_url".equals(event)) {
            if (!Configuration.INSTANCE.isCodeProfilerOn()) {
                this.logger.error("Profiling is not on.");
                return;
            }
            if (!inputList.isEmpty()) {
                urlList = inputList.toArray(new String[0]);
                Configuration.INSTANCE.setListToProfile(urlList);
                response.getWriter().print(Configuration.INSTANCE.getProfileId());
            }
        }
    }

    private List<String> getURLAndApplicationList(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        StringBuffer jb = new StringBuffer();
        String line = null;
        try {
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
                jb.append(line);
            }
        }
        catch (Exception e) {
            throw new ServletException("Error reading the post message");
        }
        return JSONConverter.getAllNodes(JSONConverter.INSTANCE.toJsonNode(jb.toString()), null, String.class);
    }

    private void invokePingModule(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String event = request.getParameter("event");
        if (!this.validateParameter("event", event, response)) {
            return;
        }
        if ("update_config".equals(event)) {
            String filterId = request.getParameter("global_filter");
            String action = request.getParameter("action");
            if (!this.validateParameter("action", action, response)) {
                return;
            }
            String settingType = request.getParameter("setting_type");
            this.logger.debug("pinged CF Server from PMT " + filterId + " " + action + " " + settingType);
            if ("global".equals(filterId) && !action.isEmpty() && action.equals("restore")) {
                filterId = Configuration.INSTANCE.getConfigId();
            }
            if ("monitor_settings".equals(settingType)) {
                Configuration.INSTANCE.updateMonitorSettings(filterId);
                ServiceFactory.getMonitoringService().updateHeartBeatStartedFlag(false);
            } else if (settingType.startsWith("alert:")) {
                Configuration.INSTANCE.updateAlertSettings(filterId, settingType);
            } else if ("generic_settings".equals(settingType)) {
                Configuration.INSTANCE.updateGenericSettings(filterId);
            }
            this.logger.trace(settingType + " settings for global filter " + filterId);
        } else if ("remove_from_group".equals(event)) {
            this.logger.debug("removed this node from group " + Configuration.INSTANCE.getGroupId());
            Configuration.INSTANCE.setGroupId(null);
            Configuration.INSTANCE.setGroupName(null);
            Configuration.INSTANCE.clearStaticList();
            TaskScheduler.INSTANCE.updateStaticMetrics();
        } else if ("add_to_group".equals(event)) {
            String groupDtl = request.getParameter("group_id");
            String groupId = groupDtl.split(":")[0];
            String groupName = groupDtl.split(":")[1];
            Configuration.INSTANCE.setGroupId(groupId);
            Configuration.INSTANCE.setGroupName(groupName);
            TaskScheduler.INSTANCE.updateStaticMetrics();
            this.logger.debug("Added this node to group " + groupId);
        } else if ("update_group_name".equals(event)) {
            String groupDtl = request.getParameter("group_id");
            String groupId = groupDtl.split(":")[0];
            String groupName = groupDtl.split(":")[1];
            Configuration.INSTANCE.setGroupId(groupId);
            Configuration.INSTANCE.setGroupName(groupName);
            TaskScheduler.INSTANCE.updateStaticMetrics();
            this.logger.debug("Group name changed for  " + groupId);
        } else if ("remove_application".equals(event)) {
            String appName = request.getParameter("application_name");
            Configuration.INSTANCE.removeApplication(appName);
        } else if ("remove_site".equals(event)) {
            String siteName = request.getParameter("site_name");
            Configuration.INSTANCE.removeSite(siteName);
        }
    }

    private void invokeThreadDumpModule(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String action = request.getParameter("action");
        if (!this.validateParameter("action", action, response)) {
            return;
        }
        String userName = request.getParameter("username");
        if (!this.validateParameter("username", userName, response)) {
            return;
        }
        if ("take".equals(action)) {
            try {
                Map<String, Map<String, Object>> threadDumpOverview = ThreadDumpUtil.getInstance().takeThreadDumpAndPushToES(userName, null);
                response.getWriter().print(JSONConverter.toJson(threadDumpOverview));
            }
            catch (Exception e) {
                response.setStatus(417);
                this.logger.error("Error while taking thread dump", e);
            }
        }
    }

    private void invokeActiveMonitoringModule(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String action = request.getParameter("action");
        if (!this.validateParameter("action", action, response)) {
            return;
        }
        if ("fetch_active_requests".equals(action)) {
            response.getWriter().print(JSONConverter.toJson(ActiveRequestMonitor.INSTANCE.getAllActiveRequests()));
        } else if ("kill_cf_thread".equals(action)) {
            String threadName = request.getParameter("cf_thread_name");
            if (!this.validateParameter("cf_thread_name", threadName, response)) {
                return;
            }
            String threadType = request.getParameter("thread_type");
            if (!this.validateParameter("thread_type", threadType, response)) {
                return;
            }
            response.getWriter().print(JSONConverter.toJson(ActiveRequestMonitor.INSTANCE.abortCFThread(threadName, threadType)));
        } else if ("stack_trace".equals(action)) {
            String threadName = request.getParameter("request_thread_name");
            if (!this.validateParameter("request_thread_name", threadName, response)) {
                return;
            }
            response.getWriter().print(JSONConverter.toJson(ActiveRequestMonitor.INSTANCE.getActiveRequestStackTrace(threadName)));
        } else if ("stack_trace_thread".equals(action)) {
            String threadName = request.getParameter("stack_trace_thread");
            if (!this.validateParameter("stack_trace_thread", threadName, response)) {
                return;
            }
            String threadType = request.getParameter("thread_type");
            if (!this.validateParameter("thread_type", threadType, response)) {
                return;
            }
            response.getWriter().print(JSONConverter.toJson(ActiveRequestMonitor.INSTANCE.getActiveThreadStackTrace(threadName, ThreadType.valueOf(threadType))));
        } else if ("kill_request".equals(action)) {
            boolean abortRequest = true;
            String threadName = request.getParameter("request_thread_name");
            if (!this.validateParameter("request_thread_name", threadName, response)) {
                return;
            }
            ActiveRequestMonitor.INSTANCE.abortRequest(threadName);
            response.getWriter().print(abortRequest);
        } else if ("fetch_active_cf_threads".equals(action)) {
            response.getWriter().print(JSONConverter.toJson(ActiveRequestMonitor.INSTANCE.getAllActiveCFThreads()));
        } else if ("fetch_active_callable_threads".equals(action)) {
            response.getWriter().print(JSONConverter.toJson(ActiveRequestMonitor.INSTANCE.getAllActiveCallableThreads()));
        } else if ("fetch_active_queries".equals(action)) {
            response.getWriter().print(JSONConverter.toJson(ActiveRequestMonitor.INSTANCE.getActiveQueries()));
        } else if ("fetch_active_session".equals(action)) {
            response.getWriter().print(JSONConverter.toJson(ActiveRequestMonitor.INSTANCE.getAllActiveSessions(null)));
        }
    }

    private boolean validateParameter(String paramName, String paramValue, HttpServletResponse response) throws IOException {
        Matcher matcher = PARAMETER_PATTERN.matcher(paramValue);
        boolean match = matcher.find();
        if (!match) {
            response.setStatus(500);
            response.getWriter().print(RB.getString(PMSGenericServlet.class, "uncrecognizedInput", (Object)paramName, (Object)paramValue));
        }
        return match;
    }

    public void destroy() {
    }

    static final class Fields {
        static final String EVENT_REMOVE_APPLICATION = "remove_application";
        static final String EVENT_REMOVE_SITE = "remove_site";
        static final String APPLICATION_NAME = "application_name";
        static final String SITE_NAME = "site_name";
        static final String HTTPS = "https";
        static final String PROTOCOL = "protocol";

        Fields() {
        }
    }
}

