/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.Struct;
import java.util.HashSet;
import java.util.Map;

public class Settings {
    public static final String ESHOST = "elasticsearchhost";
    public static final String ESPORT = "elasticsearchport";
    public static final String CONNECTIONREQUESTTIMEOUT = "esconnectionrequesttimeout";
    public static final String SOCKETTIMEOUT = "essockettimeout";
    public static final String CONNECTIONTIMEOUT = "esconnectiontimeout";
    public static final String RETRYTIMEOUT = "esretrytimeout";
    public static final String ESBULKACTION = "esbulkaction";
    public static final String ESBULKSIZE = "esbulksize";
    public static final String ESSNIFFINTERVAL = "essniffinterval";
    public static final String ESBULKTHREADS = "esbulkthreads";
    public static final String ESFLUSHINTERVAL = "esflushinterval";
    public static final String BULKWAITSTRATEGY = "bulkwaitstrategy";
    public static final String ESNUMBEROFRETRY = "esnumberofretry";
    public static final String RINGBUFFERSIZE = "ringbuffersize";
    public static final String PMTDASHBOARDURL = "pmtdashboardurl";
    public static final String DISPLAYNAME = "displayname";
    public static final String HOSTNAME = "hostname";
    public static final String J2EECONTEXT = "j2eecontext";
    public static final String J2EEPORT = "j2eeport";
    public static final String J2EEHTTPSENABLED = "j2eehttpsenabled";
    public static final String MULTICASTENABLED = "multicastenabled";
    public static final String MULTICASTPORT = "multicastport";
    public static final String MULTICASTGROUPIP = "multicastgroupip";
    public static final String CFPORTMONITORED = "cfport";
    public static final String UUID = "uuid";
    public static final String RESETUUID = "uuidreset";
    public static final String ESPROTOCOL = "elasticSearchProtocol";
    public static final String ESUSERNAME = "elasticSearchUsername";
    public static final String ESPASSWORD = "elasticSearchPassword";
    public static final String MONITORINGENABLED = "monitoringenabled";
    public static final String MEMORYMONITORINGENABLED = "memorymonitoringenabled";
    public static final String PROFILINGENABLED = "profilingenabled";
    public static final String ISMONITORINGSERVERENABLED = "ismonitoringserverenabled";
    public static final String WEBSERVERURL = "webserverurl";
    public static final String INCLUDE = "includemonitortemplatepaths";
    public static final String EXCLUDE = "excludemonitortemplatepaths";
    public static final String INCLUDECFADMIN = "includecfadmin";
    public static final String INCLUDEPROFILING = "includeprofilingtemplatepaths";
    public static final String EXCLUDEPROFILING = "excludeprofilingtemplatepaths";
    public static final String SLOWREQUESTTHRESHOLD = "slowrequestthreshold";
    public static final String AVGSLOWREQUESTTHRESHOLD = "avgslowrequestthreshold";
    public static final String SLOWTHREADTHRESHOLD = "slowthreadthreshold";
    public static final String REQUESTLOADAVGPERIOD = "requestloadavgperiod";
    public static final String TOPMEMORYUSEDREQUESTSTHRESHOLD = "topmemoryusedrequeststhreshold";
    public static final String TOPMEMORYUSEDREQUESTSCOUNT = "topmemoryusedrequestscount";
    public static final String TOPMEMORYUSEDSESSIONSTHRESHOLD = "topmemoryusedsessionsthreshold";
    public static final String TOPMEMORYUSEDSESSIONSCOUNT = "topmemoryusedsessionscount";
    public static final String TOPFREQUENTLYRUNQUERIESCOUNT = "topfrequentlyrunqueriescount";
    public static final String TOPMEMORYUSEDTHREADSTHRESHOLD = "topmemoryusedthreadsthreshold";
    public static final String TOPMEMORYUSEDTHREADSCOUNT = "topmemoryusedthreadscount";
    public static final String SLOWREQUESTCOUNT = "slowrequestcount";
    public static final String AVGSLOWREQUESTCOUNT = "avgslowrequestcount";
    public static final String SLOWTHREADCOUNT = "slowthreadcount";
    public static final String MAXSERVERTIMEREQUESTCOUNT = "maxservertimerequestcount";
    public static final String MAXSERVERTIMETHREADCOUNT = "maxservertimethreadcount";
    public static final String HITCOUNTCOUNT = "hitcountcount";
    public static final String HITTHREADCOUNT = "hitthreadcount";
    public static final String CONNECTOR_LOAD_RATIO_THRESHOLD = "connectorloadratiothreshold";
    public static final String TOPMEMORYUSEDQUERIESTHRESHOLD = "topmemoryusedqueriesthreshold";
    public static final String TOPMEMORYUSEDQUERIESCOUNT = "topmemoryusedqueriescount";
    public static final String TOPSLOWQUERIESTHRESHOLD = "topslowqueriesthreshold";
    public static final String TOPSLOWQUERIESCOUNT = "topslowqueriescount";
    public static final String TOPAVERAGESLOWQUERIESTHRESHOLD = "topaverageslowqueriesthreshold";
    public static final String TOPAVERAGESLOWQUERIESCOUNT = "topaverageslowqueriescount";
    public static final String MAILSERVERUSERID = "mailserveruserid";
    public static final String MAILSERVERPASSWORD = "mailserverpassword";
    public static final String NOTIFYALERTEMAILID = "notifyalertemailid";
    public static final String NOTIFYALERTFROMEMAILID = "notifyalertfromemailid";
    public static final String NOTIFYALERTSLACKWEBHOOKURL = "notifyalertslackwebhookurl";
    public static final String NOTIFYONALERT = "notifyonalert";
    public static final String KILLTHREADTHRESHOLD = "killthreadthreshold";
    public static final String KILLTHREADENABLED = "killthreadsenabled";
    public static final String REJECTREQUESTS_ENABLED = "rejectrequestsenabled";
    public static final String CFCFQN = "alert_processing_cfc";
    public static final String ENABLED = "enabled";
    public static final String DUMPSNAPSHOT = "dumpsnapshot";
    public static final String NOTIFYCLIENTONALERT = "notifyclientonalert";
    public static final String NOTIFYCLIENTSLACKONALERT = "notifyclientslackonalert";
    public static final String SLOWREQUESTALERT = "SLOWREQUESTALERT";
    public static final String SLOWQUERYALERT = "SLOWQUERYALERT";
    public static final String SLOWSERVERALERT = "slowserveralert";
    public static final String HUNGSERVERALERT = "unresponsiveserveralert";
    public static final String JVMMEMORYALERT = "jvmmemoryalert";
    public static final String TIMEOUTSALERT = "timeoutsalert";
    public static final String CONNECTORALERT = "connectoralert";
    public static final String HUNGSERVER_HUNGTHREADCOUNT = "hungthreadcount";
    public static final String HUNGSERVER_BUSYTIMETHRESHOLD = "busytimethreshold";
    public static final String SLOWSERVER_RESPONSETIMETHRESHOLD = "responsetimethreshold";
    public static final String GARBAGECOLLECTION_ENABLED = "garbagecollectionenabled";
    public static final String JVMMEMORY_THRESHOLD = "jvmmemorythreshold";
    public static final String TIMEOUTS_COUNT = "timeoutscount";
    public static final String TIMEOUTS_INTERVAL = "timeoutsinterval";
    public static final String CONNECTORLOAD_RATIO = "connectorloadratio";
    public static final String TYPE_BOOLEAN = "BOOLEAN";
    public static final String TYPE_NUMBER = "NUMBER";
    public static final String TYPE_STRING = "STRING";
    public static final String TYPE_LIST = "LIST";
    public static final String COMMA = ",";
    public static final String ALIASSETTING = "aliassetting";
    public static final String TEMPLATEPATH = "TEMPLATEPATH";
    public static final String ALIASNAME = "ALIASNAME";
    public static final String PARAMETERS = "PARAMETERS";
    private static Struct generalSettingsKeys = new Struct();
    private static Logger logger;
    private static final String YES = "YES";
    private static final String NO = "NO";
    private static final String TRUE = "TRUE";
    private static final String FALSE = "FALSE";

    public static Map getGeneralSettingsKeys() {
        return generalSettingsKeys;
    }

    public static int toIntValue(Map map, String name, int defaultValue) {
        int parsedVal = defaultValue;
        Object value = map.get(name);
        boolean error = true;
        if (value != null && value instanceof Number) {
            parsedVal = ((Number)value).intValue();
            error = false;
        }
        if (value instanceof String) {
            try {
                parsedVal = Integer.parseInt((String)value);
                error = false;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (parsedVal < 0) {
            error = true;
        }
        if (error) {
            logger.debug("Monitor service: Error parsing numeric property " + name + ", using default " + defaultValue);
            parsedVal = defaultValue;
            map.put(name, new Double(parsedVal));
        }
        return parsedVal;
    }

    public static long toLongValue(Map map, String name, long defaultValue) {
        long parsedVal = defaultValue;
        Object value = map.get(name);
        boolean error = true;
        if (value != null && value instanceof Number) {
            parsedVal = ((Number)value).longValue();
            error = false;
        }
        if (value instanceof String) {
            try {
                parsedVal = Long.parseLong((String)value);
                error = false;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (parsedVal < 0L) {
            error = true;
        }
        if (error) {
            logger.debug("Monitor service: Error parsing numeric property " + name + ", using default " + defaultValue);
            parsedVal = defaultValue;
            map.put(name, new Double(parsedVal));
        }
        return parsedVal;
    }

    public static double toDoubleValue(Map map, String name, double defaultValue) {
        double parsedVal = defaultValue;
        Object value = map.get(name);
        boolean error = true;
        if (value != null && value instanceof Number) {
            parsedVal = ((Number)value).doubleValue();
            error = false;
        }
        if (value instanceof String) {
            try {
                parsedVal = Double.parseDouble((String)value);
                error = false;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (parsedVal < 0.0) {
            error = true;
        }
        if (error) {
            logger.debug("Monitor service: Error parsing numeric property " + name + ", using default " + defaultValue);
            parsedVal = defaultValue;
            map.put(name, new Double(parsedVal));
        }
        return parsedVal;
    }

    public static boolean toBooleanValue(Map map, String name, boolean defaultValue) {
        boolean parsedVal = defaultValue;
        Object value = map.get(name);
        boolean error = true;
        if (value != null && value instanceof Boolean) {
            parsedVal = (Boolean)value;
            error = false;
        }
        if (error) {
            logger.debug("Monitor service: Error parsing boolean property " + name + ", using default " + defaultValue);
            parsedVal = defaultValue;
            map.put(name, parsedVal);
        }
        return parsedVal;
    }

    public static String toStringValue(Map map, String name, String defaultValue) {
        String parsedVal = defaultValue;
        Object value = map.get(name);
        boolean error = true;
        if (value != null && value instanceof String) {
            parsedVal = (String)value;
            error = false;
        }
        if (error) {
            logger.debug("Monitor service: Error parsing string property " + name + ", using default " + defaultValue);
            parsedVal = defaultValue;
            if (defaultValue == null) {
                map.put(name, "");
            } else {
                map.put(name, parsedVal);
            }
        }
        return parsedVal;
    }

    public static String[] toUniqueStrings(Map map, String name, String defaultValue) {
        String[] strList = Settings.toStringValue(map, name, defaultValue).split(COMMA);
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < strList.length; ++i) {
            String strTempItem = strList[i].trim();
            if ("".equals(strTempItem)) continue;
            set.add(strTempItem);
        }
        return set.toArray(new String[set.size()]);
    }

    public static String toStringList(String[] strs) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < strs.length; ++i) {
            buff.append(strs[i].trim());
            if (i == strs.length - 1) continue;
            buff.append(COMMA);
        }
        return buff.toString();
    }

    public static Boolean translateBoolean(Map map, String name) {
        Object value = map.get(name);
        if (value == null) {
            return null;
        }
        boolean error = true;
        Boolean ret = null;
        if (value instanceof Boolean) {
            ret = (Boolean)value;
            error = false;
        } else if (value instanceof String) {
            String str = (String)value;
            if (str.equalsIgnoreCase(YES) || str.equalsIgnoreCase(TRUE)) {
                ret = Boolean.TRUE;
                error = false;
            } else if (str.equalsIgnoreCase(NO) || str.equalsIgnoreCase(FALSE)) {
                ret = Boolean.FALSE;
                error = false;
            }
        }
        if (error) {
            String msg = "Unable to translate value [" + value + "] to Boolean for key [" + name + "]";
            logger.error(msg);
            throw new MonitorConfigurationException(msg);
        }
        map.put(name, ret);
        return ret;
    }

    public static Double translateDouble(Map map, String name) {
        Object value = map.get(name);
        if (value == null) {
            return null;
        }
        boolean error = true;
        Double ret = null;
        if (value instanceof Number) {
            ret = new Double(((Number)value).doubleValue());
            error = false;
        } else if (value instanceof String) {
            String str = (String)value;
            try {
                ret = new Double(str);
                error = false;
            }
            catch (NumberFormatException nfEx) {
                error = true;
            }
        }
        if (error) {
            String msg = "Unable to translate value [" + value + "] to Double for key [" + name + "]";
            logger.error(msg);
            throw new MonitorConfigurationException(msg);
        }
        map.put(name, ret);
        return ret;
    }

    static {
        generalSettingsKeys.put(MONITORINGENABLED, (Object)TYPE_BOOLEAN);
        generalSettingsKeys.put(MEMORYMONITORINGENABLED, (Object)TYPE_BOOLEAN);
        generalSettingsKeys.put(PROFILINGENABLED, (Object)TYPE_BOOLEAN);
        generalSettingsKeys.put(INCLUDE, (Object)TYPE_LIST);
        generalSettingsKeys.put(EXCLUDE, (Object)TYPE_LIST);
        generalSettingsKeys.put(INCLUDECFADMIN, (Object)TYPE_BOOLEAN);
        generalSettingsKeys.put(SLOWREQUESTTHRESHOLD, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(AVGSLOWREQUESTTHRESHOLD, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(REQUESTLOADAVGPERIOD, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(TOPMEMORYUSEDREQUESTSTHRESHOLD, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(TOPMEMORYUSEDREQUESTSCOUNT, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(TOPMEMORYUSEDSESSIONSTHRESHOLD, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(TOPMEMORYUSEDSESSIONSCOUNT, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(SLOWREQUESTCOUNT, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(AVGSLOWREQUESTCOUNT, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(MAXSERVERTIMEREQUESTCOUNT, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(HITCOUNTCOUNT, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(TOPMEMORYUSEDQUERIESTHRESHOLD, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(TOPMEMORYUSEDQUERIESCOUNT, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(TOPSLOWQUERIESTHRESHOLD, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(TOPSLOWQUERIESCOUNT, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(TOPAVERAGESLOWQUERIESTHRESHOLD, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(TOPAVERAGESLOWQUERIESCOUNT, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(TOPFREQUENTLYRUNQUERIESCOUNT, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(NOTIFYALERTEMAILID, (Object)TYPE_STRING);
        generalSettingsKeys.put(NOTIFYALERTSLACKWEBHOOKURL, (Object)TYPE_STRING);
        generalSettingsKeys.put(NOTIFYALERTFROMEMAILID, (Object)TYPE_STRING);
        generalSettingsKeys.put(NOTIFYONALERT, (Object)TYPE_BOOLEAN);
        generalSettingsKeys.put(MAILSERVERUSERID, (Object)TYPE_STRING);
        generalSettingsKeys.put(MAILSERVERPASSWORD, (Object)TYPE_STRING);
        generalSettingsKeys.put(TOPMEMORYUSEDTHREADSTHRESHOLD, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(TOPMEMORYUSEDTHREADSCOUNT, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(SLOWTHREADTHRESHOLD, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(SLOWTHREADCOUNT, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(HITTHREADCOUNT, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(MAXSERVERTIMETHREADCOUNT, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(KILLTHREADTHRESHOLD, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(KILLTHREADENABLED, (Object)TYPE_BOOLEAN);
        generalSettingsKeys.put(REJECTREQUESTS_ENABLED, (Object)TYPE_BOOLEAN);
        generalSettingsKeys.put(GARBAGECOLLECTION_ENABLED, (Object)TYPE_BOOLEAN);
        generalSettingsKeys.put(JVMMEMORY_THRESHOLD, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(DUMPSNAPSHOT, (Object)TYPE_BOOLEAN);
        generalSettingsKeys.put(TIMEOUTS_COUNT, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(TIMEOUTS_INTERVAL, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(INCLUDEPROFILING, (Object)TYPE_LIST);
        generalSettingsKeys.put(EXCLUDEPROFILING, (Object)TYPE_LIST);
        generalSettingsKeys.put(NOTIFYCLIENTONALERT, (Object)TYPE_BOOLEAN);
        generalSettingsKeys.put(NOTIFYCLIENTSLACKONALERT, (Object)TYPE_BOOLEAN);
        generalSettingsKeys.put(ISMONITORINGSERVERENABLED, (Object)TYPE_BOOLEAN);
        generalSettingsKeys.put(WEBSERVERURL, (Object)TYPE_STRING);
        generalSettingsKeys.put(CONNECTOR_LOAD_RATIO_THRESHOLD, (Object)TYPE_NUMBER);
        generalSettingsKeys.put(ESPROTOCOL, (Object)TYPE_STRING);
        generalSettingsKeys.put(ESUSERNAME, (Object)TYPE_STRING);
        generalSettingsKeys.put(ESPASSWORD, (Object)TYPE_STRING);
        generalSettingsKeys.put(CFPORTMONITORED, (Object)TYPE_NUMBER);
        logger = CFLogs.SERVER_LOG;
    }

    public static class MonitorConfigurationException
    extends NeoException {
        public String msg;

        public MonitorConfigurationException(String msg) {
            this.msg = msg;
        }
    }
}

