/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.active;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.memory.MemoryCalculator;
import coldfusion.monitor.util.ResponseConstants;
import coldfusion.runtime.Struct;
import coldfusion.runtime.TemplateClassLoader;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class TemplateCacheMonitor {
    private static Logger logger = CFLogs.MONITOR_LOG;
    private static WeakHashMap templateSizes = new WeakHashMap();
    private static WeakHashMap cfcSizes = new WeakHashMap();
    private static final int MAX_TRIES = 3;

    public static void record(Class c, byte[] classBytes, String filePath) {
        long memUsedInMB = MemoryCalculator.calculateMemory(classBytes);
        if (!filePath.isEmpty() && filePath.endsWith(".cfm")) {
            templateSizes.put(c, new Long(memUsedInMB));
        } else if (!filePath.isEmpty() && filePath.endsWith(".cfc")) {
            cfcSizes.put(c, new Long(memUsedInMB));
        }
    }

    public static void clear() {
        try {
            templateSizes.clear();
        }
        catch (Throwable ex) {
            logger.debug("exception while clearing cache ", ex);
        }
    }

    public static Map getTemplateCacheStats() {
        return TemplateCacheMonitor.getTemplateCacheStats(0);
    }

    private static Map getTemplateCacheStats(int tries) {
        Map stats;
        block6: {
            if (tries > 3) {
                Struct stats2 = new Struct();
                stats2.put("size", (Object)ResponseConstants.LONG_ZERO);
                stats2.put("count", (Object)ResponseConstants.INTEGER_ZERO);
                stats2.put("hit_ratio", (Object)ResponseConstants.DOUBLE_ZERO);
                return stats2;
            }
            stats = null;
            try {
                stats = new Struct();
                long cfmCacheSize = TemplateCacheMonitor.getCacheSize(templateSizes, stats);
                long cfcCacheSize = TemplateCacheMonitor.getCacheSize(cfcSizes, stats);
                stats.put("size", new Long(cfmCacheSize + cfcCacheSize));
                double hitRatio = TemplateClassLoader.getClassCacheHitRatio();
                if (hitRatio > 1.0) {
                    hitRatio = 1.0;
                }
                stats.put("hit_ratio", new Double(hitRatio));
            }
            catch (ConcurrentModificationException e) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                stats = TemplateCacheMonitor.getTemplateCacheStats(++tries);
                if (stats != null) break block6;
                throw e;
            }
        }
        return stats;
    }

    private static long getCacheSize(WeakHashMap inpMap, Map stats) {
        Collection valuesCollection = inpMap.values();
        int count = valuesCollection.size();
        int cacheCount = 0;
        if (stats.containsKey("count")) {
            cacheCount = (Integer)stats.get("count");
        }
        stats.put("count", cacheCount + count);
        Iterator values = valuesCollection.iterator();
        long size = 0L;
        while (values.hasNext()) {
            size += ((Long)values.next()).longValue();
        }
        return size;
    }

    public static void clearComponentCache() {
        cfcSizes.clear();
    }
}

