/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.alert;

public class AlertConfig {
    private String name;
    private String type;
    private String criterion;
    private String metric;
    private long duration;
    private double threshold;
    private boolean active;
    private String message;
    private int hungThreadCount;
    private int busyThreadTime;
    private double poolIncreaseRatio;
    private Actions actions;
    private String displayName;

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public double getPoolIncreaseRatio() {
        return this.poolIncreaseRatio;
    }

    public void setPoolIncreaseRatio(double poolIncreaseRatio) {
        this.poolIncreaseRatio = poolIncreaseRatio;
    }

    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public Actions getActions() {
        return this.actions;
    }

    public int getHungThreadCount() {
        return this.hungThreadCount;
    }

    public void setHungThreadCount(int hungThreadCount) {
        this.hungThreadCount = hungThreadCount;
    }

    public int getBusyThreadTime() {
        return this.busyThreadTime;
    }

    public void setBusyThreadTime(int busyThreadTime) {
        this.busyThreadTime = busyThreadTime;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCriterion() {
        return this.criterion;
    }

    public void setCriterion(String criterion) {
        this.criterion = criterion;
    }

    public double getThreshold() {
        if ("JVM-CPU-USAGE-ALERT".equals(this.getName()) || "SYSTEM-CPU-USAGE-ALERT".equals(this.getName())) {
            return 1000.0 * this.threshold;
        }
        return this.threshold;
    }

    public double getDisplayThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public static class Actions {
        private boolean invokeCFC;
        private boolean killThreads;
        private int threadKillThreshhold;
        private boolean triggerThreadDump;
        private boolean triggerHeapDump;
        private boolean rejectNewRequests;
        private boolean sendMail;
        private boolean invokeGarbageCollection;
        private boolean slack;
        public boolean enableAutoTune;
        private String cfcFqn;

        public boolean isEnableAutoTune() {
            return this.enableAutoTune;
        }

        public void setEnableAutoTune(boolean enableAutoTune) {
            this.enableAutoTune = enableAutoTune;
        }

        public boolean isSlack() {
            return this.slack;
        }

        public void setSlack(boolean slack) {
            this.slack = slack;
        }

        public boolean isSendMail() {
            return this.sendMail;
        }

        public void setSendMail(boolean sendMail) {
            this.sendMail = sendMail;
        }

        public boolean isRejectNewRequests() {
            return this.rejectNewRequests;
        }

        public void setRejectNewRequests(boolean rejectNewRequests) {
            this.rejectNewRequests = rejectNewRequests;
        }

        public boolean isInvokeCFC() {
            return this.invokeCFC;
        }

        public void setInvokeCFC(boolean invokeCFC) {
            this.invokeCFC = invokeCFC;
        }

        public boolean isKillThreads() {
            return this.killThreads;
        }

        public void setKillThreads(boolean killThreads) {
            this.killThreads = killThreads;
        }

        public boolean isTriggerThreadDump() {
            return this.triggerThreadDump;
        }

        public void setTriggerThreadDump(boolean triggerThreadDump) {
            this.triggerThreadDump = triggerThreadDump;
        }

        public boolean isTriggerHeapDump() {
            return this.triggerHeapDump;
        }

        public void setTriggerHeapDump(boolean triggerHeapDump) {
            this.triggerHeapDump = triggerHeapDump;
        }

        public int getThreadKillThreshhold() {
            return this.threadKillThreshhold;
        }

        public void setThreadKillThreshhold(int threadKillThreshhold) {
            this.threadKillThreshhold = threadKillThreshhold;
        }

        public boolean isInvokeGarbageCollection() {
            return this.invokeGarbageCollection;
        }

        public void setInvokeGarbageCollection(boolean invokeGarbageCollection) {
            this.invokeGarbageCollection = invokeGarbageCollection;
        }

        public String getCfcFqn() {
            return this.cfcFqn;
        }

        public void setCfcFqn(String cfcFqn) {
            this.cfcFqn = cfcFqn;
        }
    }
}

