/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.alert;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.Settings;
import coldfusion.monitor.alert.SlackClient;
import coldfusion.monitor.connector.AlertResponse;
import coldfusion.monitor.connector.CFLoadBalanceInstance;
import coldfusion.monitor.connector.ConnectorAlertBean;
import coldfusion.monitor.connector.ConnectorData;
import coldfusion.server.ConfigMap;
import coldfusion.server.MonitoringService;
import coldfusion.util.RB;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;

public class ConnectorAlert {
    private double connectorLoadRatio;
    private static final Set allowedConfigKeys = new TreeSet();
    public static final double CONNECTOR_LOAD_RATIO = 0.8;
    private static Map<String, Long> connectorActive = null;
    private static ObjectMapper objectMapper = new ObjectMapper();
    private Logger logger = CFLogs.SERVER_LOG;
    private boolean notifyClientOnSlack = true;
    private String notifyalertslackwebhookurl = "https://hooks.slack.com/services/dummy/00000000";

    public ConnectorAlert() {
        connectorActive = new ConcurrentHashMap<String, Long>();
    }

    public String getAlertName() {
        return "connectoralert";
    }

    public Set allowedConfigurationKeys() {
        return allowedConfigKeys;
    }

    protected void translateAlertSettings(Map settings) {
        Settings.translateDouble(settings, "connectorloadratio");
    }

    public boolean loadAlert(Map settings, MonitoringService ms) {
        boolean taskConfigChanged = false;
        this.connectorLoadRatio = Settings.toDoubleValue(settings, "connectorloadratio", 0.8);
        if (this.isEnabled() && this.connectorLoadRatio == 0.0) {
            this.logger.info("Disabling connector alert: CONNECTOR_LOAD_RATIO must be a positive non-zero number between 0 and 1.");
            this.setEnabled(false);
            taskConfigChanged = true;
        }
        return taskConfigChanged;
    }

    private boolean isEnabled() {
        return true;
    }

    private void setEnabled(boolean state) {
    }

    protected ConfigMap defaultValues() {
        ConfigMap map = new ConfigMap();
        map.put("enabled", (Object)Boolean.FALSE);
        map.put("connectorloadratio", (Object)new Double(0.8));
        map.put("alert_processing_cfc", (Object)"");
        map.put("notifyonalert", (Object)Boolean.FALSE);
        map.put("killthreadsenabled", (Object)Boolean.FALSE);
        map.put("rejectrequestsenabled", (Object)Boolean.FALSE);
        map.put("dumpsnapshot", (Object)Boolean.FALSE);
        return map;
    }

    public void sendAlert(ConnectorData connectorData) {
        if (this.isEnabled()) {
            if (connectorData.isLoadBalanced()) {
                List<CFLoadBalanceInstance> siteInstances = connectorData.getSiteInstances();
                for (CFLoadBalanceInstance siteBalanceInstance : siteInstances) {
                    double loadRatio = this.getLoadRatio(siteBalanceInstance);
                    if (!(loadRatio > this.connectorLoadRatio)) continue;
                    ConnectorAlertBean connectorAlertBean = this.createAlertData(connectorData, siteBalanceInstance);
                    this.sendAlert(connectorAlertBean);
                }
            } else if (connectorData.getConnectorLoad() >= this.connectorLoadRatio) {
                ConnectorAlertBean connectorAlertBean = this.createAlertData(connectorData, null);
                this.sendAlert(connectorAlertBean);
            }
        }
    }

    private void sendAlert(ConnectorAlertBean connectorAlertBean) {
        String instanceName = connectorAlertBean.getInstanceName() != null ? connectorAlertBean.getInstanceName() : "";
        String connectorInstancename = connectorAlertBean.getSiteName() + instanceName;
        if (this.isActive(connectorInstancename, true) == 0) {
            if (connectorAlertBean.getInstanceName() != null && !connectorAlertBean.getInstanceName().isEmpty()) {
                this.logger.info("Alert: Connector load has gone over threshold for site: " + connectorAlertBean.getSiteName() + " instance name: " + connectorAlertBean.getInstanceName() + " current load: " + connectorAlertBean.getSiteBusy());
            } else {
                this.logger.info("Alert: Connector load has gone over threshold for site: " + connectorAlertBean.getSiteName() + " current load: " + connectorAlertBean.getSiteBusy());
            }
            this.setActive(connectorAlertBean);
            this.sendAlertMessageOnSlack(connectorAlertBean);
        }
    }

    private double getLoadRatio(CFLoadBalanceInstance balanceInstance) {
        int instanceBusy = balanceInstance.getInstanceBusy();
        int instancePoolsize = balanceInstance.getInstancePoolSize();
        if (instancePoolsize > 0) {
            return (double)instanceBusy / (double)instancePoolsize;
        }
        return -1.0;
    }

    public int isActive(String connectorData, boolean ignoreInmemory) {
        int state = -1;
        if (!this.isInmemoryActive(connectorData, ignoreInmemory)) {
            String alertActiveQuery = null;
            try {
                alertActiveQuery = this.getAlertActiveQuery(connectorData, "Active", "m", 5);
                connectorActive.put(connectorData, System.currentTimeMillis());
            }
            catch (JsonProcessingException e) {
                this.logger.warn("Connector Alert unable to make ES query ", e);
                state = -1;
            }
            if (alertActiveQuery != null) {
                return this.makeActiveAlertQuery(alertActiveQuery);
            }
        }
        return state;
    }

    private boolean isInmemoryActive(String connectorData, boolean ignoreInmemory) {
        Long time = connectorActive.get(connectorData);
        if (time == null) {
            connectorActive.put(connectorData, 0L);
            return true;
        }
        if (ignoreInmemory && time == 0L) {
            return false;
        }
        if (time > 0L) {
            long elasedTime = System.currentTimeMillis() - time;
            long minutes = TimeUnit.MILLISECONDS.toMinutes(elasedTime);
            return minutes <= 1L;
        }
        return true;
    }

    private void sendAlertMessageOnSlack(ConnectorAlertBean connectorAlertBean) {
        String instanceName = connectorAlertBean.getInstanceName();
        String message = "";
        if (instanceName != null && !instanceName.isEmpty()) {
            message = RB.getString((Object)this, "connectoractivealertinstance", (Object)connectorAlertBean.getSiteName(), (Object)connectorAlertBean.getInstanceName(), (Object)connectorAlertBean.getSiteBusy());
        }
        message = RB.getString((Object)this, "connectoractivealert", (Object)connectorAlertBean.getSiteName(), (Object)connectorAlertBean.getSiteBusy());
        String messageFormat = "{\"text\":\" " + message + " :fire:\" }";
        this.sendAlertOnSlack(messageFormat);
    }

    public void testSlack() {
        String data = "{\"text\":\"Connector is on :fire:\" }";
        this.sendAlertOnSlack(data);
    }

    protected void sendAlertOnSlack(String message) {
        if (this.notifyClientOnSlack && this.notifyalertslackwebhookurl != null) {
            SlackClient slackClient = SlackClient.getSlackClient();
            try {
                slackClient.sendMessageToSlackChannel(this.notifyalertslackwebhookurl, message);
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error("Alert: " + this.getAlertName() + ": Failed to send slack notification.", e);
            }
        }
    }

    private void setActive(ConnectorAlertBean connectorAlertBean) {
        this.persist(connectorAlertBean);
    }

    private ConnectorAlertBean createAlertData(ConnectorData connectorData, CFLoadBalanceInstance cfLoadBalanceInstance) {
        ConnectorAlertBean connectorAlertBean = new ConnectorAlertBean();
        connectorAlertBean.setAlertState("Active");
        connectorAlertBean.setSiteName(connectorData.getSiteName());
        connectorAlertBean.setAlertTimeStamp(connectorData.getTimeStamp());
        connectorAlertBean.setSiteBusy(connectorData.getSiteBusy());
        if (cfLoadBalanceInstance != null) {
            connectorAlertBean.setInstanceName(cfLoadBalanceInstance.getInstanceName());
            connectorAlertBean.setSiteBusy(cfLoadBalanceInstance.getInstanceBusy());
            connectorAlertBean.setClusterId(connectorData.getClusterId());
            connectorAlertBean.setInstanceId(cfLoadBalanceInstance.getInstanceId());
        }
        return connectorAlertBean;
    }

    private void persist(ConnectorAlertBean connectorAlertBean) {
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        String writeValueAsString = "";
        try {
            writeValueAsString = objectMapper.writeValueAsString((Object)connectorAlertBean);
        }
        catch (JsonProcessingException e) {
            this.logger.warn("Connnector alert unbale to create json from input object", e);
        }
    }

    private int makeActiveAlertQuery(String query) {
        NStringEntity entity = new NStringEntity(query, ContentType.APPLICATION_JSON);
        AlertResponse response = null;
        try {
            response = (AlertResponse)objectMapper.readValue(entity.getContent(), AlertResponse.class);
            return response.getHits().getTotal();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    private String getAlertActiveQuery(String siteName, String alertState, String unit, int time) throws JsonProcessingException {
        Object from = "now-5m";
        if (unit != null && !unit.isEmpty() && time > 0) {
            from = "now-" + time + unit;
        }
        ObjectNode rootNode = objectMapper.createObjectNode();
        rootNode.put("size", 0);
        ArrayNode arrayNode = rootNode.putObject("query").putObject("bool").putArray("must");
        arrayNode.addObject().putObject("match").put("siteName", siteName);
        arrayNode.addObject().putObject("match").put("alertState", alertState);
        arrayNode.addObject().putObject("range").putObject("alertTimeStatmp").put("from", (String)from);
        String writeValueAsString = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootNode);
        return writeValueAsString;
    }

    static {
        allowedConfigKeys.add("connectorloadratio");
    }
}

