/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.alert;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.GenericSettings;
import coldfusion.monitor.active.ActiveRequestMonitor;
import coldfusion.monitor.alert.AlertAction;
import coldfusion.monitor.alert.AlertConfig;
import coldfusion.monitor.alert.Notification;
import coldfusion.monitor.datastore.Client;
import coldfusion.monitor.datastore.JSONConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum CustomAlertManager {
    INSTANCE;

    private Map<String, List<AlertConfig>> alerts = null;
    private Map<String, Notification> liveNotifications = null;
    private static Logger logger;
    private static GenericSettings.MailConfig mailSetup;
    private static String slackWebHookUrl;

    public Map<String, Notification> getLiveAlerts() {
        return this.liveNotifications;
    }

    public static String getSlackWebHookUrl() {
        return slackWebHookUrl;
    }

    public static GenericSettings.MailConfig getMailSetup() {
        return mailSetup;
    }

    public List<AlertConfig> getAlertInstance(String alertType) {
        if (this.alerts != null) {
            return this.alerts.get(alertType.toLowerCase());
        }
        return null;
    }

    public Map<String, List<AlertConfig>> getAlerts() {
        return this.alerts;
    }

    public void load() {
        this.loadAlertConfigs();
        this.loadGeneralSettings();
        logger.debug("Loaded Alert Configuration");
    }

    public void loadGeneralSettings() {
        mailSetup = Configuration.INSTANCE.getGenericSettings().getMailConfig();
        slackWebHookUrl = Configuration.INSTANCE.getGenericSettings().getSlackWebHookUrl();
    }

    public void loadAlertConfigs() {
        this.alerts = new ConcurrentHashMap<String, List<AlertConfig>>();
        this.liveNotifications = new ConcurrentHashMap<String, Notification>();
        this.updateAlertsFromConfiguration();
        ActiveRequestMonitor.INSTANCE.acceptNewRequests();
    }

    public void loadAlertConfigs(String id) {
        String name = id.split(":")[1];
        this.alerts = new ConcurrentHashMap<String, List<AlertConfig>>();
        if (this.liveNotifications != null && this.liveNotifications.containsKey(name)) {
            logger.debug("removed alert from in-memory " + name + this.liveNotifications.get(name).getAlertId());
            this.liveNotifications.remove(name);
        }
        this.updateAlertsFromConfiguration();
        ActiveRequestMonitor.INSTANCE.acceptNewRequests();
    }

    private void updateAlertsFromConfiguration() {
        List<AlertConfig> configList = null;
        for (AlertConfig alertConfig : Configuration.INSTANCE.getAlertConfig()) {
            configList = this.alerts.containsKey(alertConfig.getType()) ? this.alerts.get(alertConfig.getType()) : new ArrayList<AlertConfig>();
            configList.add(alertConfig);
            this.alerts.put(alertConfig.getType(), configList);
        }
    }

    public static void sendNotification(AlertConfig config, Notification notification) {
        System.out.println("notification alertid " + notification.getAlertId());
        Client.get().submit(JSONConverter.toJson(notification), "alerts", notification.getAlertId().toString());
        AlertAction action = new AlertAction(config, notification);
        action.execute();
    }

    public void reset() {
        this.alerts = null;
        mailSetup = null;
        slackWebHookUrl = null;
        this.liveNotifications = null;
    }

    static {
        logger = CFLogs.SERVER_LOG;
        mailSetup = null;
    }
}

