/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.alert;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;

public enum SlackClient {
    INSTANCE;

    private CloseableHttpAsyncClient client;
    private Logger logger = CFLogs.MONITOR_LOG;

    private SlackClient() {
        try {
            this.createSlackClient();
        }
        catch (IOReactorException e) {
            this.logger.warn("Monitoring Service: Unable to start slack service", e);
        }
    }

    public void createSlackClient() throws IOReactorException {
        if (this.client == null) {
            DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor();
            PoolingNHttpClientConnectionManager cm = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
            this.client = HttpAsyncClients.custom().setConnectionManager((NHttpClientConnectionManager)cm).build();
            this.client.start();
        }
    }

    public static SlackClient getSlackClient() {
        return INSTANCE;
    }

    public void closeClient() throws IOException {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public void sendMessageToSlackChannel(String webHookURL, String message) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(webHookURL);
        httpPost.setEntity((HttpEntity)new StringEntity(message));
        httpPost.setHeader("Content-type", "application/json");
        this.client.execute((HttpUriRequest)httpPost, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void failed(Exception arg0) {
                SlackClient.this.logger.error("Alert notification to slack failed:" + arg0);
            }

            public void completed(HttpResponse response) {
                try {
                    response.getEntity().getContent().close();
                }
                catch (IOException | UnsupportedOperationException e) {
                    SlackClient.this.logger.error("Error occured while sending alert on slack: ", e);
                }
                SlackClient.this.logger.debug("Alert notification to slack succeeded");
            }

            public void cancelled() {
            }
        });
    }
}

