/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.aliasing;

import coldfusion.monitor.Settings;
import coldfusion.monitor.aliasing.AliasDetail;
import coldfusion.runtime.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum AliasManager {
    INSTANCE;

    Map<String, AliasDetail> aliasMap = new HashMap<String, AliasDetail>();

    public static AliasManager getinstance() {
        return INSTANCE;
    }

    public synchronized void setAliasMap(List<AliasDetail> settings) {
        if (this.aliasMap.size() == 0) {
            for (int i = 0; i < settings.size(); ++i) {
                AliasDetail newDetail = settings.get(i);
                this.aliasMap.put(newDetail.getTemplatePath().toUpperCase(), newDetail);
            }
        }
    }

    public List getAliasList() {
        ArrayList<Struct> result = new ArrayList<Struct>();
        for (Map.Entry<String, AliasDetail> entry : this.aliasMap.entrySet()) {
            AliasDetail detail = entry.getValue();
            Struct tempStruct = new Struct();
            tempStruct.put("TEMPLATEPATH", (Object)detail.getTemplatePath());
            tempStruct.put("ALIASNAME", (Object)detail.getAliasName());
            tempStruct.put("PARAMETERS", (Object)Settings.toStringList(detail.getParameters()));
            result.add(tempStruct);
        }
        return result;
    }

    private AliasDetail populateDetail(Map map) {
        AliasDetail newDetail = new AliasDetail();
        newDetail.setTemplatePath((String)map.get("TEMPLATEPATH"));
        newDetail.setAliasName((String)map.get("ALIASNAME"));
        newDetail.setParameters(Settings.toUniqueStrings(map, "PARAMETERS", ""));
        return newDetail;
    }

    public synchronized void deleteAlias(String templatePath) {
        AliasDetail detail = this.aliasMap.get(templatePath.toUpperCase());
        if (detail != null) {
            this.aliasMap.remove(templatePath.toUpperCase());
        }
    }

    public synchronized void editAlias(Map map) {
        AliasDetail newDetail = this.populateDetail(map);
        boolean toAdd = true;
        AliasDetail detail = this.aliasMap.get(newDetail.getTemplatePath().toUpperCase());
        if (detail != null) {
            detail.setParameters(newDetail.getParameters());
            detail.setAliasName(newDetail.getAliasName());
            toAdd = false;
        }
        if (toAdd) {
            this.aliasMap.put(newDetail.getTemplatePath().toUpperCase(), newDetail);
        }
    }

    public synchronized void updateAlias(List<AliasDetail> lst) {
        this.aliasMap = new HashMap<String, AliasDetail>();
        this.setAliasMap(lst);
    }

    public boolean isAliased(String templatePath) {
        return this.aliasMap.get(templatePath.toUpperCase()) != null;
    }

    public AliasDetail getAliasDetail(String templatePath) {
        if (this.aliasMap.get(templatePath.toUpperCase()) != null) {
            return this.aliasMap.get(templatePath.toUpperCase());
        }
        return null;
    }
}

