/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.connector;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.alert.AlertConfig;
import coldfusion.monitor.alert.CustomAlertManager;
import coldfusion.monitor.alert.Notification;
import coldfusion.monitor.connector.AlertResponse;
import coldfusion.monitor.connector.CFLoadBalanceInstance;
import coldfusion.monitor.connector.ConnectorAlertBean;
import coldfusion.monitor.connector.ConnectorData;
import coldfusion.monitor.datastore.Client;
import coldfusion.monitor.util.MonitoringServiceUtils;
import coldfusion.util.RB;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;

public enum ConnectorMonitor {
    INSTANCE;

    private Logger logger = CFLogs.SERVER_LOG;
    private ObjectMapper mapper = new ObjectMapper();
    private Map<String, Long> connectorActive = new ConcurrentHashMap<String, Long>();
    private ExecutorService executorServie = Executors.newFixedThreadPool(10);
    private static String APACHE;

    public static ConnectorMonitor getInstance() {
        return INSTANCE;
    }

    public List<ConnectorAlertBean> record(ConnectorData data) {
        this.setLoadRationAndHealth(data);
        List<ConnectorAlertBean> shouldRaiseConnectorAlert = null;
        if (Configuration.INSTANCE.getMonitorSettings().isMonitoringEnabled()) {
            if (data.getSiteName() != null && !data.getSiteName().isEmpty() && !Configuration.INSTANCE.checkIfSiteExists(data.getSiteName())) {
                Configuration.INSTANCE.updateSiteList(data.getSiteName(), data.getSiteType());
            }
            AlertConfig alertConfig = null;
            List<AlertConfig> alertInstance = CustomAlertManager.INSTANCE.getAlertInstance("Connector");
            if (alertInstance != null) {
                alertConfig = alertInstance.get(0);
            }
            if (alertConfig != null && (alertConfig.isActive() || Configuration.INSTANCE.getMonitorSettings().isEnableAutoTune())) {
                shouldRaiseConnectorAlert = this.shouldRaiseConnectorAlert(data, alertConfig);
            }
            this.persist(data);
        }
        return shouldRaiseConnectorAlert;
    }

    private double getInstanceHealthScore(double instanceLoad) {
        double instanceHealthScore = 0.0;
        if (instanceLoad <= 0.7) {
            instanceHealthScore = 0.0;
        } else if (instanceLoad > 0.7 && instanceLoad <= 0.75) {
            instanceHealthScore = 0.1;
        } else if (instanceLoad > 0.75 && instanceLoad <= 0.8) {
            instanceHealthScore = 0.2;
        } else if (instanceLoad > 0.8 && instanceLoad <= 0.85) {
            instanceHealthScore = 0.3;
        } else if (instanceLoad > 0.85 && instanceLoad <= 0.9) {
            instanceHealthScore = 0.4;
        } else if (instanceLoad > 0.9 && instanceLoad <= 0.95) {
            instanceHealthScore = 0.6;
        } else if (instanceLoad > 0.95 && instanceLoad <= 0.98) {
            instanceHealthScore = 0.75;
        } else if (instanceLoad > 0.98) {
            instanceHealthScore = 1.0;
        }
        return instanceHealthScore;
    }

    private void setLoadRationAndHealth(ConnectorData connectorData) {
        double loadsummation = 0.0;
        double loadFactorSum = 0.0;
        double healthsummation = 0.0;
        int poolSizeSum = 0;
        boolean isApache = false;
        String webserverType = connectorData.getSiteType();
        if (APACHE.equalsIgnoreCase(webserverType)) {
            isApache = true;
        }
        if (connectorData.isLoadBalanced()) {
            for (CFLoadBalanceInstance cfLoadBalanceInstance : connectorData.getSiteInstances()) {
                cfLoadBalanceInstance.setInstanceId(cfLoadBalanceInstance.getHostName() + ":" + cfLoadBalanceInstance.getInstanceName() + ":" + cfLoadBalanceInstance.getPort());
                poolSizeSum += cfLoadBalanceInstance.getInstancePoolSize();
                cfLoadBalanceInstance.setInstanceLoad(this.getConnectorLoad(cfLoadBalanceInstance.getInstancePoolSize(), cfLoadBalanceInstance.getInstanceBusy()));
                if (cfLoadBalanceInstance.getInstanceState() == 2 || cfLoadBalanceInstance.getInstanceState() == 3 || cfLoadBalanceInstance.getInstanceState() == 0) {
                    cfLoadBalanceInstance.setInstanceHealth(0.0);
                } else {
                    cfLoadBalanceInstance.setInstanceHealth((1.0 - this.getInstanceHealthScore(cfLoadBalanceInstance.getInstanceLoad())) * 100.0);
                }
                loadsummation += cfLoadBalanceInstance.getInstanceLoad() * (double)cfLoadBalanceInstance.getInstanceLoadFactor();
                healthsummation += cfLoadBalanceInstance.getInstanceHealth() * (double)cfLoadBalanceInstance.getInstanceLoadFactor();
                loadFactorSum += (double)cfLoadBalanceInstance.getInstanceLoadFactor();
            }
            connectorData.setPoolSize(poolSizeSum);
            if (loadFactorSum > 0.0) {
                connectorData.setConnectorLoad(loadsummation / loadFactorSum);
                connectorData.setSiteHealth(healthsummation / loadFactorSum);
            }
        } else {
            if (isApache) {
                connectorData.setPoolSize(0);
            }
            connectorData.setConnectorLoad(this.getConnectorLoad(connectorData.getPoolSize(), connectorData.getSiteBusy()));
            connectorData.setSiteHealth((1.0 - this.getInstanceHealthScore(connectorData.getConnectorLoad())) * 100.0);
        }
    }

    private double getConnectorLoad(int poolSize, int siteBusy) {
        if (poolSize == 0) {
            return 0.0;
        }
        return (double)siteBusy / (double)poolSize;
    }

    private List<ConnectorAlertBean> shouldRaiseConnectorAlert(ConnectorData connectorData, AlertConfig config) {
        ArrayList<Callable<Integer>> alertCallables = new ArrayList<Callable<Integer>>();
        ArrayList<ConnectorAlertBean> connectorAlerts = new ArrayList<ConnectorAlertBean>();
        double threshold = Configuration.INSTANCE.getMonitorSettings().getAutoTuneThreshold() / 100.0;
        double poolIncreaseRatio = 1.0 + Configuration.INSTANCE.getMonitorSettings().getPoolIncreaseRatio() / 100.0;
        boolean autoTuneEnabled = Configuration.INSTANCE.getMonitorSettings().isEnableAutoTune();
        if (connectorData.isLoadBalanced()) {
            List<CFLoadBalanceInstance> siteInstances = connectorData.getSiteInstances();
            double newpoolsizetop = 0.0;
            for (CFLoadBalanceInstance siteBalanceInstance : siteInstances) {
                double loadRatio = ConnectorMonitor.getLoadRatio(siteBalanceInstance);
                if (loadRatio >= threshold) {
                    ConnectorAlertBean connectorAlertBean = ConnectorMonitor.createAlertData(connectorData, siteBalanceInstance);
                    connectorAlertBean.setPoolIncreaseRatio(poolIncreaseRatio);
                    alertCallables.add(this.getAlertRunnable(config, connectorAlertBean));
                    double instancePoolSizeNew = (double)siteBalanceInstance.getInstancePoolSize() * poolIncreaseRatio;
                    if (autoTuneEnabled && (siteBalanceInstance.getInstanceState() == 1 || siteBalanceInstance.getInstanceState() == 3) && instancePoolSizeNew <= Configuration.INSTANCE.getMonitorSettings().getPoolUpperLimit()) {
                        siteBalanceInstance.setInstancePoolSizeNew(instancePoolSizeNew);
                        connectorAlerts.add(connectorAlertBean);
                        newpoolsizetop += instancePoolSizeNew;
                        continue;
                    }
                    newpoolsizetop += (double)siteBalanceInstance.getInstancePoolSize();
                    continue;
                }
                newpoolsizetop += (double)siteBalanceInstance.getInstancePoolSize();
            }
            if (newpoolsizetop > (double)connectorData.getPoolSize()) {
                connectorData.setPoolSizeNew(newpoolsizetop);
            }
        } else if (connectorData.getConnectorLoad() >= threshold) {
            ConnectorAlertBean connectorAlertBean = ConnectorMonitor.createAlertData(connectorData, null);
            connectorAlertBean.setPoolIncreaseRatio(poolIncreaseRatio);
            alertCallables.add(this.getAlertRunnable(config, connectorAlertBean));
            double pool_size_new = (double)connectorData.getPoolSize() * poolIncreaseRatio;
            if (autoTuneEnabled && pool_size_new <= Configuration.INSTANCE.getMonitorSettings().getPoolUpperLimit()) {
                connectorAlerts.add(connectorAlertBean);
                connectorData.setPoolSizeNew(pool_size_new);
            }
        }
        return connectorAlerts;
    }

    private Callable<Integer> getAlertRunnable(final AlertConfig config, final ConnectorAlertBean connectorAlertBean) {
        Callable<Integer> alertCallable = new Callable<Integer>(){

            @Override
            public Integer call() {
                ConnectorMonitor.this.sendAlert(connectorAlertBean, config);
                return 0;
            }
        };
        return alertCallable;
    }

    private void sendAlert(ConnectorAlertBean connectorAlertBean, AlertConfig config) {
        if (this.isActive(connectorAlertBean, true) == 0) {
            boolean isLoadbalanced;
            boolean bl = isLoadbalanced = connectorAlertBean.getInstanceName() != null && !connectorAlertBean.getInstanceName().isEmpty();
            if (isLoadbalanced) {
                this.logger.info("Alert: Connector load has gone over threshold for site: " + connectorAlertBean.getSiteName() + " instance name: " + connectorAlertBean.getInstanceName() + " current load: " + connectorAlertBean.getSiteBusy());
            } else {
                this.logger.info("Alert: Connector load has gone over threshold for site: " + connectorAlertBean.getSiteName() + " current load: " + connectorAlertBean.getSiteBusy());
            }
            Notification notification = new Notification();
            notification.setAlertId(UUID.randomUUID());
            notification.setAlertState("Active");
            notification.setTimeStamp(connectorAlertBean.getAlertTimeStamp());
            notification.setCriterion(config.getCriterion());
            if (isLoadbalanced) {
                notification.setInstanceName(connectorAlertBean.getInstanceName());
                notification.setInstanceId(connectorAlertBean.getInstanceId());
                notification.setClusterId(connectorAlertBean.getClusterId());
            }
            notification.setName(config.getName());
            notification.setMessage(this.getAlertMessage(connectorAlertBean));
            notification.setRead(false);
            notification.setSiteBusy(connectorAlertBean.getSiteBusy());
            notification.setSiteName(connectorAlertBean.getSiteName());
            notification.setType(config.getType());
            CustomAlertManager.sendNotification(config, notification);
        }
    }

    private String getAlertMessage(ConnectorAlertBean connectorAlertBean) {
        String instanceName = connectorAlertBean.getInstanceName();
        String message = "";
        if (instanceName != null && !instanceName.isEmpty()) {
            message = connectorAlertBean.getInstanceState() == 2 ? RB.getString((Object)this, "connectoractivealertinstancedown", (Object)connectorAlertBean.getSiteName(), (Object)connectorAlertBean.getInstanceName()) : (connectorAlertBean.getInstanceState() == 3 ? RB.getString((Object)this, "connectoractivealertinstancebusy", (Object)connectorAlertBean.getSiteName(), (Object)connectorAlertBean.getInstanceName()) : RB.getString((Object)this, "connectoractivealertinstance", (Object)connectorAlertBean.getSiteName(), (Object)connectorAlertBean.getInstanceName(), (Object)connectorAlertBean.getSiteBusy()));
            return message;
        }
        message = RB.getString((Object)this, "connectoractivealert", (Object)connectorAlertBean.getSiteName(), (Object)connectorAlertBean.getSiteBusy());
        return message;
    }

    private static ConnectorAlertBean createAlertData(ConnectorData connectorData, CFLoadBalanceInstance cfLoadBalanceInstance) {
        ConnectorAlertBean connectorAlertBean = new ConnectorAlertBean();
        connectorAlertBean.setAlertState("Active");
        connectorAlertBean.setSiteName(connectorData.getSiteName());
        connectorAlertBean.setAlertTimeStamp(connectorData.getTimeStamp());
        connectorAlertBean.setSiteBusy(connectorData.getSiteBusy());
        connectorAlertBean.setClusterId(connectorData.getClusterId());
        connectorAlertBean.setInstanceId(connectorData.getInstanceId());
        if (cfLoadBalanceInstance != null) {
            connectorAlertBean.setInstanceName(cfLoadBalanceInstance.getInstanceName());
            connectorAlertBean.setSiteBusy(cfLoadBalanceInstance.getInstanceBusy());
            connectorAlertBean.setInstanceState(cfLoadBalanceInstance.getInstanceState());
            connectorAlertBean.setInstanceId(cfLoadBalanceInstance.getInstanceId());
        }
        return connectorAlertBean;
    }

    private static double getLoadRatio(CFLoadBalanceInstance balanceInstance) {
        int instanceBusy = balanceInstance.getInstanceBusy();
        int instancePoolsize = balanceInstance.getInstancePoolSize();
        if (instancePoolsize > 0) {
            return (double)instanceBusy / (double)instancePoolsize;
        }
        return -1.0;
    }

    private void persist(ConnectorData data) {
        this.mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        String writeValueAsString = "";
        try {
            writeValueAsString = this.mapper.writeValueAsString((Object)data);
        }
        catch (JsonProcessingException e) {
            this.logger.warn("Connector Monitor, unable to parse the input json", e);
        }
        Client.get().submit(writeValueAsString, MonitoringServiceUtils.getLatestConnectorIndex());
    }

    public int isActive(ConnectorAlertBean connectorAlertBean, boolean ignoreInmemory) {
        int state = -1;
        if (!this.isInmemoryActive(connectorAlertBean, ignoreInmemory)) {
            String alertActiveQuery = null;
            try {
                alertActiveQuery = this.getAlertActiveQuery(connectorAlertBean, "Active", "m", 5);
                String instanceName = connectorAlertBean.getInstanceName() != null ? connectorAlertBean.getInstanceName() : "";
                String connectorInstancename = connectorAlertBean.getSiteName() + instanceName;
                this.connectorActive.put(connectorInstancename, System.currentTimeMillis());
            }
            catch (JsonProcessingException e) {
                this.logger.warn("Connector Alert unable to make ES query ", e);
                state = -1;
            }
            if (alertActiveQuery != null) {
                return this.makeActiveAlertQuery(alertActiveQuery);
            }
        }
        return state;
    }

    private boolean isInmemoryActive(ConnectorAlertBean connectorAlertBean, boolean ignoreInmemory) {
        String instanceName = connectorAlertBean.getInstanceName() != null ? connectorAlertBean.getInstanceName() : "";
        String connectorInstancename = connectorAlertBean.getSiteName() + instanceName;
        Long time = this.connectorActive.get(connectorInstancename);
        if (time == null) {
            this.connectorActive.put(connectorInstancename, 0L);
            return false;
        }
        if (ignoreInmemory && time == 0L) {
            return false;
        }
        if (time > 0L) {
            long elasedTime = System.currentTimeMillis() - time;
            long minutes = TimeUnit.MILLISECONDS.toMinutes(elasedTime);
            return minutes <= 1L;
        }
        return true;
    }

    private int makeActiveAlertQuery(String query) {
        NStringEntity entity = new NStringEntity(query, ContentType.APPLICATION_JSON);
        AlertResponse response = null;
        try {
            response = (AlertResponse)this.mapper.readValue(Client.get().call("GET", "/alerts/notification/_search", Collections.singletonMap("pretty", "true"), (HttpEntity)entity).getContent(), AlertResponse.class);
            return response.getHits().getTotal();
        }
        catch (IOException e) {
            this.logger.error("Unable to make elastic search query", e);
            return -1;
        }
    }

    private String getAlertActiveQuery(ConnectorAlertBean connectorAlertBean, String alertState, String unit, int time) throws JsonProcessingException {
        String siteName = connectorAlertBean.getSiteName();
        Object from = "now-5m";
        if (unit != null && !unit.isEmpty() && time > 0) {
            from = "now-" + time + unit;
        }
        ObjectNode rootNode = this.mapper.createObjectNode();
        rootNode.put("size", 0);
        ArrayNode arrayNode = rootNode.putObject("query").putObject("bool").putArray("must");
        arrayNode.addObject().putObject("match").put("site_name", siteName);
        if (connectorAlertBean.getInstanceName() != null && !connectorAlertBean.getInstanceName().isEmpty()) {
            arrayNode.addObject().putObject("match").put("instance_name", connectorAlertBean.getInstanceName());
        }
        arrayNode.addObject().putObject("match").put("alert_state", alertState);
        arrayNode.addObject().putObject("range").putObject("alert_time_stamp").put("from", (String)from);
        String writeValueAsString = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootNode);
        return writeValueAsString;
    }

    static {
        APACHE = "Apache";
    }
}

