/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.discovery;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.datastore.JSONConverter;
import coldfusion.monitor.discovery.CFMultiCastMessageReciever;
import coldfusion.server.MonitoringService;
import coldfusion.util.RB;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CFMonitoringMulticastService {
    private InetAddress multicastGroup;
    private MulticastSocket mcSocket;
    private String multiCastGroupIp;
    private int multiCastPort;
    ExecutorService newSingleThreadExecutor;
    public static byte CF_MAGIC_BYTE = 0;
    private String CFUPMESSAGE = "CF_UP";
    private Logger LOG = CFLogs.MONITOR_LOG;
    private MonitoringService monitoringService;
    private CFMultiCastMessageReciever cfMultiCastMessageReciever;

    public CFMonitoringMulticastService(String multiCastGroupIp, int multiCastPort, MonitoringService monitoringService) {
        this.multiCastGroupIp = multiCastGroupIp;
        this.multiCastPort = multiCastPort;
        this.monitoringService = monitoringService;
    }

    public boolean startMulticastService() {
        boolean multicastStarted = false;
        try {
            this.multicastGroup = InetAddress.getByName(this.multiCastGroupIp);
        }
        catch (IOException e) {
            this.LOG.error(RB.getString(CFMonitoringMulticastService.class, "MulticastGroupNametNotFree", (Object)this.multiCastGroupIp), e);
        }
        try {
            this.mcSocket = new MulticastSocket(this.multiCastPort);
            this.mcSocket.joinGroup(this.multicastGroup);
            multicastStarted = true;
            this.startListeningForMessages();
            this.broadcastNodeUpMessage();
        }
        catch (IOException e) {
            this.LOG.error(RB.getString(CFMonitoringMulticastService.class, "MulticastPortNotFree", this.multiCastPort), e);
        }
        return multicastStarted;
    }

    public void stopMulticastService() {
        try {
            if (this.cfMultiCastMessageReciever != null) {
                this.cfMultiCastMessageReciever.stopListening();
            }
            if (this.newSingleThreadExecutor != null) {
                this.newSingleThreadExecutor.shutdown();
            }
            if (this.multicastGroup != null && this.mcSocket != null && !this.mcSocket.isClosed()) {
                this.mcSocket.leaveGroup(this.multicastGroup);
                this.multicastGroup = null;
                this.mcSocket.close();
            }
        }
        catch (Exception e) {
            this.LOG.error(RB.getString(CFMonitoringMulticastService.class, "MulticastSocketStopError"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastNodeUpMessage() {
        String data = this.CFUPMESSAGE;
        data = JSONConverter.toJson(this.monitoringService.getHeartBeat());
        this.LOG.debug("CF message: " + data);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        bout.write(CF_MAGIC_BYTE);
        DatagramPacket dp = null;
        try {
            bout.write(data.getBytes());
            bout.flush();
            dp = new DatagramPacket(bout.toByteArray(), bout.size(), this.multicastGroup, this.multiCastPort);
            bout.close();
        }
        catch (IOException e) {
            this.LOG.error(RB.getString(CFMonitoringMulticastService.class, "MulticastNodeUpBroadcastError"), e);
        }
        try {
            this.mcSocket.send(dp);
        }
        catch (Exception e) {
            this.LOG.error(RB.getString(CFMonitoringMulticastService.class, "MulticastNodeUpBroadcastError"), e);
        }
        finally {
            dp = null;
        }
    }

    public MulticastSocket getMcSocket() {
        return this.mcSocket;
    }

    public void startListeningForMessages() {
        this.newSingleThreadExecutor = Executors.newSingleThreadExecutor();
        this.cfMultiCastMessageReciever = new CFMultiCastMessageReciever(this);
        this.newSingleThreadExecutor.submit(this.cfMultiCastMessageReciever);
    }
}

