/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.event;

import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.TemplateNotFoundException;
import coldfusion.util.Utils;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class MonitoringServletFilter
implements Filter {
    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean tempFound = true;
        RequestMonitorEventProcessor.onRequestStart();
        try {
            chain.doFilter(request, response);
        }
        catch (IOException ioEx) {
            if (ioEx instanceof TemplateNotFoundException) {
                tempFound = false;
                RequestMonitorData.teardown();
            } else {
                RequestMonitorEventProcessor.onError(ioEx);
            }
            throw ioEx;
        }
        catch (ServletException servEx) {
            RequestMonitorEventProcessor.onError(servEx);
            throw servEx;
        }
        catch (Throwable t) {
            RequestMonitorEventProcessor.onError(t);
            throw new ServletException(Utils.getMessage(t));
        }
        finally {
            if (tempFound) {
                if (response != null && RequestMonitorData.getCurrent() != null) {
                    RequestMonitorData.getCurrent().setResponseCode(((HttpServletResponse)response).getStatus());
                }
                RequestMonitorEventProcessor.onRequestEnd();
            }
        }
    }

    public void destroy() {
    }

    public final class StopThreadException
    extends ApplicationException {
    }
}

