/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.inmemory;

import coldfusion.monitor.event.RequestEvent;
import coldfusion.monitor.inmemory.CountStatCalculator;
import coldfusion.monitor.util.AvgStatCalculator;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.Struct;
import coldfusion.server.InMemoryMonitoringService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public enum TimingRequestMonitor {
    INSTANCE;

    private CountStatCalculator hitCountCalc = new CountStatCalculator();
    private AvgStatCalculator responseTimeCalc = new AvgStatCalculator();
    private long requestLoadAvgPeriod;
    private LoadMetricTask loadMetricTask;
    private Map hitStats = new HashMap();
    private double avgServerRequestLoad;
    private double avgServerResponseTime;
    private InMemoryMonitoringService monitoringService;
    private long interval = 60L;

    private TimingRequestMonitor() {
        this.hitStats.put("TEMPLATE REQUEST", new CountStatCalculator());
        this.hitStats.put("EVENT GATEWAY REQUEST", new CountStatCalculator());
        this.hitStats.put("FLASH REMOTING REQUEST", new CountStatCalculator());
        this.hitStats.put("CFC REQUEST", new CountStatCalculator());
        this.hitStats.put("WEB SERVICE REQUEST", new CountStatCalculator());
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void record(RequestEvent e) {
        RequestMonitorData rmd = e.getRequestMonitorData();
        if (!rmd.isError()) {
            this.updateServerData(rmd, rmd.getReqType());
        }
    }

    public long getTotalHitCount() {
        return this.hitCountCalc.getCount();
    }

    public Map getHitStats() {
        return this.hitStats;
    }

    public Map getHitCountStats() {
        Map hitStats = this.getHitStats();
        long totalHitCount = this.getTotalHitCount();
        Struct struct = new Struct();
        struct.put("TEMPLATEHITCOUNT", new Long(((CountStatCalculator)hitStats.get("TEMPLATE REQUEST")).getCount()));
        struct.put("GATEWAYHITCOUNT", new Long(((CountStatCalculator)hitStats.get("EVENT GATEWAY REQUEST")).getCount()));
        struct.put("FLASHHITCOUNT", new Long(((CountStatCalculator)hitStats.get("FLASH REMOTING REQUEST")).getCount()));
        struct.put("RCFCHITCOUNT", new Long(((CountStatCalculator)hitStats.get("CFC REQUEST")).getCount()));
        struct.put("WSHITCOUNT", new Long(((CountStatCalculator)hitStats.get("WEB SERVICE REQUEST")).getCount()));
        struct.put("TOTALHITCOUNT", new Long(totalHitCount));
        return struct;
    }

    private double getTotalServerTimeUsed() {
        return this.responseTimeCalc.getAvg() * (double)this.responseTimeCalc.getCount();
    }

    public double getRequestLoad() {
        return this.avgServerRequestLoad;
    }

    public double getAverageResponseTime() {
        return this.avgServerResponseTime;
    }

    public void load(InMemoryMonitoringService ms, boolean enable) {
        this.monitoringService = ms;
        this.initTimingStats(enable);
    }

    private void initTimingStats(boolean enable) {
        long newRequestLoadAvgPeriod;
        this.requestLoadAvgPeriod = newRequestLoadAvgPeriod = this.interval * 1000L;
        if (this.loadMetricTask != null) {
            this.monitoringService.cancelTask(this.loadMetricTask);
        }
        if (this.monitoringService.isMonitoringEnabled()) {
            this.loadMetricTask = new LoadMetricTask();
            this.monitoringService.scheduleTask(this.loadMetricTask, this.requestLoadAvgPeriod);
        } else {
            this.avgServerRequestLoad = 0.0;
            this.avgServerResponseTime = 0.0;
        }
    }

    public void resetCumulativeServerTimeSpentRequests() {
        this.responseTimeCalc.reset();
    }

    private void updateServerData(RequestMonitorData rmd, String requestType) {
        this.hitCountCalc.incrementCount();
        this.responseTimeCalc.updateData(rmd.getResponseTime());
        ((CountStatCalculator)this.hitStats.get(requestType)).incrementCount();
    }

    public void reset() {
        this.hitCountCalc.reset();
        this.responseTimeCalc.reset();
        Iterator counters = this.hitStats.values().iterator();
        while (counters.hasNext()) {
            ((CountStatCalculator)counters.next()).reset();
        }
        if (this.loadMetricTask != null) {
            this.loadMetricTask.reset();
        }
    }

    private class LoadMetricTask
    implements Runnable {
        private long lastRunTime = System.currentTimeMillis();
        private long lastHitCount = 0L;
        private double lastCumulativeServerTime = 0.0;

        private LoadMetricTask() {
        }

        @Override
        public void run() {
            long hitCount = TimingRequestMonitor.this.hitCountCalc.getCount();
            long currentRunTime = System.currentTimeMillis();
            double hitCountDiff = (double)hitCount - (double)this.lastHitCount;
            double runTimeDiff = currentRunTime - this.lastRunTime;
            double cumulativeServerTime = TimingRequestMonitor.this.getTotalServerTimeUsed();
            double cumulativeServerTimeDiff = cumulativeServerTime - this.lastCumulativeServerTime;
            TimingRequestMonitor.this.avgServerRequestLoad = hitCountDiff / (runTimeDiff / 1000.0);
            TimingRequestMonitor.this.avgServerResponseTime = hitCountDiff == 0.0 ? 0.0 : cumulativeServerTimeDiff / hitCountDiff;
            this.lastRunTime = currentRunTime;
            this.lastHitCount = hitCount;
            this.lastCumulativeServerTime = cumulativeServerTime;
        }

        public void reset() {
            this.lastHitCount = 0L;
            this.lastCumulativeServerTime = 0.0;
        }
    }
}

