/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.jetty.xml;

import coldfusion.runtime.ApplicationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JettyXmlHandler {
    private static JettyXmlHandler instance;
    private Document doc;
    private File jettyFile;

    private JettyXmlHandler(File file) {
        this.jettyFile = file;
        this.loadXMLinDOM();
    }

    public static JettyXmlHandler getInstance(File file) {
        if (instance == null) {
            instance = new JettyXmlHandler(file);
        }
        return instance;
    }

    public void saveConfigurations() {
        this.serializeXml();
    }

    public void updatePort(String port) {
        this.setNewPortValue(port);
        this.serializeXml();
    }

    private void loadXMLinDOM() throws JettyXMLException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (this.jettyFile == null || !this.jettyFile.exists()) {
                throw new JettyXMLException((Throwable)new FileNotFoundException());
            }
            this.doc = builder.parse(this.jettyFile);
        }
        catch (ParserConfigurationException e) {
            throw new JettyXMLException((Throwable)e);
        }
        catch (SAXException e) {
            throw new JettyXMLException((Throwable)e);
        }
        catch (IOException e) {
            throw new JettyXMLException((Throwable)e);
        }
    }

    private Node getPortValueNode() {
        NodeList list = this.doc.getElementsByTagName("*");
        for (int i = 0; i < list.getLength(); ++i) {
            NodeList childNodes;
            String classValue;
            Element element = (Element)list.item(i);
            if (element == null || !element.getNodeName().equalsIgnoreCase("New") || (classValue = element.getAttribute("class")) == null || !classValue.toLowerCase().endsWith("connector") || (childNodes = element.getElementsByTagName("Set")) == null) continue;
            int len = childNodes.getLength();
            for (int j = 0; j < len; ++j) {
                Element childElement = (Element)childNodes.item(j);
                if (childElement == null || !childElement.getAttribute("name").equalsIgnoreCase("port")) continue;
                Node portValueNode = childElement.getFirstChild();
                return portValueNode;
            }
        }
        return null;
    }

    private String getConnectorClassString() {
        NodeList list = this.doc.getElementsByTagName("*");
        for (int i = 0; i < list.getLength(); ++i) {
            String classValue;
            Element element = (Element)list.item(i);
            if (element == null || !element.getNodeName().equalsIgnoreCase("New") || (classValue = element.getAttribute("class")) == null || !classValue.toLowerCase().endsWith("connector")) continue;
            return classValue.toLowerCase();
        }
        return null;
    }

    public String getPortValue() {
        Node portValueNode = this.getPortValueNode();
        if (portValueNode != null) {
            return portValueNode.getTextContent();
        }
        throw new JettyXMLException((Throwable)new NullPointerException());
    }

    public String getProtocol() {
        String protocol = "http";
        String connectorClass = this.getConnectorClassString();
        if (connectorClass != null && connectorClass.contains("ssl")) {
            protocol = "https";
        }
        return protocol;
    }

    private void setNewPortValue(String newPortValue) {
        Node portValueNode = this.getPortValueNode();
        if (portValueNode == null) {
            throw new JettyXMLException((Throwable)new NullPointerException());
        }
        portValueNode.setTextContent(newPortValue);
    }

    private void serializeXml() {
        if (System.getSecurityManager() == null) {
            this._serializeXml();
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    JettyXmlHandler.this._serializeXml();
                    return null;
                }
            });
        }
    }

    private void _serializeXml() throws JettyXMLException {
        try {
            TransformerFactory tranFactory = TransformerFactory.newInstance();
            Transformer aTransformer = tranFactory.newTransformer();
            DOMSource src = new DOMSource(this.doc);
            if (this.jettyFile == null || !this.jettyFile.exists()) {
                throw new JettyXMLException((Throwable)new FileNotFoundException());
            }
            StreamResult dest = new StreamResult(new FileOutputStream(this.jettyFile));
            aTransformer.setOutputProperty("doctype-system", this.doc.getDoctype().getSystemId());
            aTransformer.transform(src, dest);
        }
        catch (TransformerConfigurationException e) {
            throw new JettyXMLException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new JettyXMLException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new JettyXMLException((Throwable)e);
        }
    }

    public class JettyXMLException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;

        public JettyXMLException() {
        }

        public JettyXMLException(Throwable e) {
            super(e);
        }
    }
}

