/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.memory;

import coldfusion.monitor.memory.MemoryTrackable;
import coldfusion.monitor.memory.MemoryTrackerProxy;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class MemoryCalculator {
    private static Map unitSizes = new HashMap();
    private static final ThreadLocal threadLocal = new ThreadLocal();

    public static final long calculateMemory(Object o) {
        return MemoryCalculator.calculateMemory(o, false);
    }

    public static final long calculateMemory(Object o, boolean remove) {
        long memory = 0L;
        if (o == null) {
            memory = 0L;
        } else {
            Class<?> clazz = o.getClass();
            if (clazz.isArray()) {
                memory = 8L;
                Class<?> componentClazz = clazz.getComponentType();
                long componentMemory = MemoryCalculator.getUnitMemory(componentClazz);
                if (componentClazz == String.class || componentMemory == 0L) {
                    for (int i = 0; i < Array.getLength(o); ++i) {
                        try {
                            memory += MemoryCalculator.calculateMemory(Array.get(o, i));
                            continue;
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                    }
                } else {
                    memory += (long)Array.getLength(o) * componentMemory;
                }
            } else if (clazz == String.class) {
                memory = MemoryCalculator.calculateStringMemory((String)o);
            } else {
                memory = MemoryCalculator.getUnitMemory(clazz);
                if (memory == 0L) {
                    MemoryTrackerProxy mtp;
                    if (clazz == BigInteger.class) {
                        memory = MemoryCalculator.calculateBigIntegerMemory((BigInteger)o);
                    } else if (clazz == BigDecimal.class) {
                        memory = MemoryCalculator.calculateBigIntegerMemory(((BigDecimal)o).unscaledValue());
                    } else if (o instanceof MemoryTrackable && (mtp = ((MemoryTrackable)o).getMemoryTrackerProxy()) != null && (memory = mtp.getBuiltInMemoryTracker().getEstimatedMemory()) == 0L && !remove) {
                        IdentityHashMap<Object, Object> map = (IdentityHashMap<Object, Object>)threadLocal.get();
                        if (map != null && map.containsKey(o)) {
                            return 0L;
                        }
                        boolean mapCreated = false;
                        if (map == null) {
                            map = new IdentityHashMap<Object, Object>();
                            threadLocal.set(map);
                            mapCreated = true;
                        }
                        map.put(o, o);
                        mtp.reload();
                        memory = mtp.getBuiltInMemoryTracker().getEstimatedMemory();
                        if (mapCreated) {
                            threadLocal.set(null);
                        }
                    }
                }
            }
        }
        return memory;
    }

    private static long calculateStringMemory(String string) {
        long memory = 40L;
        int length = string.length();
        if (length > 2) {
            memory += (long)Math.ceil((double)(length - 2) / 4.0) * 8L;
        }
        return memory;
    }

    private static long calculateBigIntegerMemory(BigInteger number) {
        long memory = 0L;
        int bitlen = number.bitLength();
        memory = bitlen < 31 ? 51L : (long)(64 + (bitlen - 32) / 62 * 8);
        return memory;
    }

    private static final long getUnitMemory(Class clazz) {
        long unitMemory = 0L;
        Long memoryObj = (Long)unitSizes.get(clazz);
        if (memoryObj != null) {
            unitMemory = memoryObj;
        }
        return unitMemory;
    }

    private static final void initialize() {
        MemoryCalculator.setSizeData(Double.class, 16L);
        MemoryCalculator.setSizeData(Long.class, 16L);
        MemoryCalculator.setSizeData(Integer.class, 16L);
        MemoryCalculator.setSizeData(Float.class, 16L);
        MemoryCalculator.setSizeData(Short.class, 16L);
        MemoryCalculator.setSizeData(Boolean.class, 16L);
        MemoryCalculator.setSizeData(Character.class, 16L);
        MemoryCalculator.setSizeData(Byte.class, 16L);
        MemoryCalculator.setSizeData(String.class, 0L);
        MemoryCalculator.setSizeData(Double.TYPE, 8L);
        MemoryCalculator.setSizeData(Long.TYPE, 8L);
        MemoryCalculator.setSizeData(Integer.TYPE, 4L);
        MemoryCalculator.setSizeData(Float.TYPE, 4L);
        MemoryCalculator.setSizeData(Short.TYPE, 2L);
        MemoryCalculator.setSizeData(Boolean.TYPE, 1L);
        MemoryCalculator.setSizeData(Character.TYPE, 2L);
        MemoryCalculator.setSizeData(Byte.TYPE, 1L);
        MemoryCalculator.setSizeData(java.util.Date.class, 24L);
        MemoryCalculator.setSizeData(Date.class, 24L);
        MemoryCalculator.setSizeData(Time.class, 24L);
        MemoryCalculator.setSizeData(Timestamp.class, 24L);
    }

    private static void setSizeData(Class clazz, long unitSize) {
        unitSizes.put(clazz, new Long(unitSize));
    }

    static {
        MemoryCalculator.initialize();
    }
}

