/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.memory;

import coldfusion.monitor.Configuration;
import coldfusion.monitor.beans.VariableBean;
import coldfusion.monitor.event.RequestEvent;
import coldfusion.monitor.event.ThreadEvent;
import coldfusion.monitor.memory.MemoryCalculator;
import coldfusion.monitor.memory.MemoryTracker;
import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.monitor.memory.RequestMemoryMonitor;
import coldfusion.monitor.memory.SessionMemoryMonitor;
import coldfusion.monitor.memory.ThreadMemoryMonitor;
import coldfusion.monitor.util.AttributeTypes;
import coldfusion.monitor.util.MonitorList;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.Scope;
import coldfusion.runtime.SessionKeyObject;
import coldfusion.runtime.SessionScope;
import coldfusion.runtime.SessionTracker;
import coldfusion.runtime.Struct;
import coldfusion.runtime.TimedScope;
import coldfusion.server.ServiceFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public enum MemoryMonitor {
    INSTANCE;

    public static final long DEFAULT_TOP_MEMORY_USED_REQUESTS_THRESHOLD = 40960L;
    public static final int DEFAULT_TOP_MEMORY_USED_REQUESTS_COUNT = 20;
    public static final long DEFAULT_TOP_MEMORY_USED_SESSIONS_THRESHOLD = 4096L;
    public static final int DEFAULT_TOP_MEMORY_USED_SESSIONS_COUNT = 20;
    public static final long DEFAULT_TOP_MEMORY_USED_THREADS_THRESHOLD = 40960L;
    public static final int DEFAULT_TOP_MEMORY_USED_THREADS_COUNT = 20;
    private RequestMemoryMonitor requestMemoryMonitor = new RequestMemoryMonitor();
    private ThreadMemoryMonitor threadMemoryMonitor = new ThreadMemoryMonitor();
    private SessionMemoryMonitor sessionMemoryMonitor = new SessionMemoryMonitor();
    private static boolean memoryMonitorEnabled;
    private static boolean profilingEnabled;
    private static final String[] scopeNames;

    public static MemoryMonitor getInstance() {
        return INSTANCE;
    }

    public static boolean isEnabled() {
        try {
            if (SessionTracker.isExternalSessionStorage) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return memoryMonitorEnabled;
    }

    public static void setEnabled(boolean enabled) {
        memoryMonitorEnabled = enabled;
        if (!enabled) {
            MemoryMonitor.setProfilingEnabled(false);
        }
        MemoryTrackerProxy.setEnabled(enabled);
    }

    public static void setProfilingEnabled(boolean enabled) {
        profilingEnabled = enabled;
        MemoryTrackerProxy.setProfilingEnabled(enabled);
    }

    public static boolean isProfilingEnabled() {
        return profilingEnabled;
    }

    public void load(boolean enabledChanged) {
        if (enabledChanged || memoryMonitorEnabled != Configuration.INSTANCE.getMonitorSettings().isCfMemoryMonitoringEnabled()) {
            MemoryMonitor.setEnabled(Configuration.INSTANCE.getMonitorSettings().isCfMemoryMonitoringEnabled() && Configuration.INSTANCE.getMonitorSettings().isMonitoringEnabled());
            if (MemoryMonitor.isEnabled()) {
                MemoryMonitor.setProfilingEnabled(Configuration.INSTANCE.isCodeProfilerOn());
                this.onMonitoringEnabled();
            } else {
                this.onMonitoringDisabled();
            }
        }
        if (MemoryMonitor.isEnabled()) {
            // empty if block
        }
    }

    private void onMonitoringEnabled() {
        Scope serverScope = ServiceFactory.getRuntimeService().getServerScope();
        serverScope.setupMemoryTracking();
        serverScope.getMemoryTrackerProxy().reload();
        Enumeration appNames = ApplicationScopeTracker.getApplicationKeys();
        while (appNames.hasMoreElements()) {
            String appName = (String)appNames.nextElement();
            ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName);
            appScope.setupMemoryTracking();
            appScope.getMemoryTrackerProxy().reload();
        }
        if (Configuration.INSTANCE.isMonitoringEnabled()) {
            Iterator<SessionKeyObject> sessionKeyObjects = SessionTracker.getSessionKeyObjects();
            while (sessionKeyObjects != null && sessionKeyObjects.hasNext()) {
                SessionKeyObject sessionKeyObj = sessionKeyObjects.next();
                SessionScope sessionScope = SessionTracker.getSession(sessionKeyObj.getAppName(), sessionKeyObj.getSessionId());
                if (sessionScope == null || sessionScope.expired()) continue;
                sessionScope.setupMemoryTracking();
                sessionScope.getMemoryTrackerProxy().reload();
                this.sessionMemoryMonitor.record(sessionScope);
            }
        }
    }

    private void onMonitoringDisabled() {
        Scope serverScope = ServiceFactory.getRuntimeService().getServerScope();
        MemoryTrackerProxy serverScopeMTP = serverScope.getMemoryTrackerProxy();
        if (serverScopeMTP != null) {
            serverScopeMTP.disable();
        }
        Enumeration appNames = ApplicationScopeTracker.getApplicationKeys();
        while (appNames.hasMoreElements()) {
            String appName = (String)appNames.nextElement();
            ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName);
            MemoryTrackerProxy appScopeMTP = appScope.getMemoryTrackerProxy();
            if (appScopeMTP == null) continue;
            appScopeMTP.disable();
        }
        if (Configuration.INSTANCE.isCodeProfilerOn()) {
            Iterator<SessionKeyObject> sessionKeyObjects = SessionTracker.getSessionKeyObjects();
            while (sessionKeyObjects != null && sessionKeyObjects.hasNext()) {
                MemoryTrackerProxy sessionScopeMTP;
                SessionKeyObject sessionKeyObj = sessionKeyObjects.next();
                SessionScope sessionScope = SessionTracker.getSession(sessionKeyObj.getAppName(), sessionKeyObj.getSessionId());
                if (sessionScope == null || sessionScope.expired() || (sessionScopeMTP = sessionScope.getMemoryTrackerProxy()) == null) continue;
                sessionScopeMTP.disable();
            }
        }
    }

    public void record(RequestEvent e) {
        this.requestMemoryMonitor.record(e);
        this.sessionMemoryMonitor.record(e);
    }

    public void record(ThreadEvent e) {
        this.threadMemoryMonitor.record(e);
    }

    public RequestMemoryMonitor getRequestMemoryMonitor() {
        return this.requestMemoryMonitor;
    }

    public ThreadMemoryMonitor getThreadMemoryMonitor() {
        return this.threadMemoryMonitor;
    }

    public SessionMemoryMonitor getSessionMemoryMonitor() {
        return this.sessionMemoryMonitor;
    }

    public static long getScopeMaxMemory(Scope scope) {
        MemoryTrackerProxy mtp;
        if (scope != null && (mtp = scope.getMemoryTrackerProxy()) != null) {
            MemoryTracker memoryTracker = mtp.getBuiltInMemoryTracker();
            return memoryTracker.getEstimatedMaxMemory();
        }
        return 0L;
    }

    public Map getAllApplicationScopesMemoryUsed() {
        Struct appScopeMemory = new Struct();
        Enumeration appNames = ApplicationScopeTracker.getApplicationKeys();
        while (appNames.hasMoreElements()) {
            String appName = (String)appNames.nextElement();
            ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName);
            long size = 0L;
            MemoryTracker mt = appScope.getMemoryTracker();
            if (mt != null) {
                size = mt.getEstimatedMemory();
            }
            appScopeMemory.put(appName, (Object)new Long(size));
        }
        return appScopeMemory;
    }

    public List getAllApplicationScopeMemoryUsed() {
        ArrayList<Struct> returnList = new ArrayList<Struct>();
        Enumeration appNames = ApplicationScopeTracker.getApplicationKeys();
        while (appNames.hasMoreElements()) {
            String appName = (String)appNames.nextElement();
            ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName);
            Struct appData = new Struct();
            appData.put("APPNAME", (Object)appName);
            long size = 0L;
            MemoryTracker mt = appScope.getMemoryTracker();
            if (mt != null) {
                size = mt.getEstimatedMemory();
            }
            appData.put("size", (Object)size);
            List<VariableBean> variables = MemoryMonitor.getVariablesMemory(appScope);
            if (variables != null) {
                appData.put("APPLICATIONSCOPESVARIABLES", (Object)variables);
            }
            returnList.add(appData);
        }
        return returnList;
    }

    public static List<VariableBean> getVariablesMemory(Scope s) {
        ArrayList<VariableBean> variables = null;
        boolean isTimedScope = s instanceof TimedScope;
        if (s != null && s.entrySet() != null) {
            variables = new ArrayList<VariableBean>();
            for (Object tempVarInfo : s.entrySet()) {
                Object tempKey = ((Map.Entry)tempVarInfo).getKey();
                VariableBean variableBean = new VariableBean();
                variableBean.setName((String)tempKey);
                if (isTimedScope) {
                    Object valueWIthoutChange = ((TimedScope)((Object)s)).getValueWIthoutChange((String)tempKey);
                    MemoryMonitor.updateVariableBean(variableBean, valueWIthoutChange);
                } else {
                    Object value = ((Map.Entry)tempVarInfo).getValue();
                    MemoryMonitor.updateVariableBean(variableBean, value);
                }
                variables.add(variableBean);
            }
        }
        return variables;
    }

    public static void updateVariableBean(VariableBean variableBean, Object value) {
        String varType = AttributeTypes.getAttributeType(value);
        variableBean.setType(varType);
        if (Configuration.INSTANCE.getMonitorSettings().isCfMemoryMonitoringEnabled()) {
            variableBean.setSize(new Long(MemoryCalculator.calculateMemory(value)));
        }
    }

    public List getApplicationScopeMemoryUsed(String applicationName) {
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(applicationName);
        return this.getTopLargeScopeAttributes(appScope);
    }

    public List getServerScopeMemoryUsed() {
        return this.getServerScopeMemoryUsed(false);
    }

    public List getServerScopeMemoryUsed(boolean allVariables) {
        Scope serverScope = ServiceFactory.getRuntimeService().getServerScope();
        if (!allVariables) {
            return this.getTopLargeScopeAttributes(serverScope);
        }
        return MemoryMonitor.getVariablesMemory(serverScope);
    }

    private List getTopLargeScopeAttributes(Scope s) {
        boolean isTimedScope = s instanceof TimedScope;
        ArrayList<Map> response = new ArrayList<Map>();
        TopLargeScopeAttributes topLargeScopeAttrs = new TopLargeScopeAttributes();
        if (s != null) {
            for (Object tempVarInfo : s.entrySet()) {
                Object tempKey = ((Map.Entry)tempVarInfo).getKey();
                VariableInfo vInfo = isTimedScope ? new VariableInfo(tempKey, ((TimedScope)((Object)s)).getValueWIthoutChange((String)tempKey)) : new VariableInfo(tempKey, ((Map.Entry)tempVarInfo).getValue());
                topLargeScopeAttrs.add(vInfo);
            }
            List topLargeScopeAttrList = topLargeScopeAttrs.getList();
            for (int i = 0; i < topLargeScopeAttrList.size(); ++i) {
                VariableInfo vInfo = (VariableInfo)topLargeScopeAttrList.get(i);
                response.add(vInfo.toVariableMap());
            }
        }
        return response;
    }

    public Map getMemoryUtilizationSummary() {
        Struct memUtilSummary = new Struct();
        long serverScopeSize = 0L;
        long appScopeSize = 0L;
        long sessionsScopeSize = 0L;
        if (MemoryMonitor.isEnabled()) {
            MemoryTrackerProxy serverScopeMTP = ServiceFactory.getRuntimeService().getServerScope().getMemoryTrackerProxy();
            serverScopeSize = serverScopeMTP.getBuiltInMemoryTracker().getEstimatedMemory();
            Enumeration appNames = ApplicationScopeTracker.getApplicationKeys();
            while (appNames.hasMoreElements()) {
                String appName = (String)appNames.nextElement();
                ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName);
                MemoryTracker mt = appScope.getMemoryTracker();
                if (mt == null) continue;
                appScopeSize += mt.getEstimatedMemory();
            }
            Iterator<String> sessionKeys = SessionTracker.getSessionKeys();
            Set appKeySet = null;
            if (sessionKeys != null) {
                while (sessionKeys.hasNext()) {
                    ConcurrentMap<String, Object> appSessions = SessionTracker.getAppSessionMap(sessionKeys.next());
                    if (appSessions == null || appSessions.isEmpty() || (appKeySet = appSessions.keySet()) == null) continue;
                    Iterator appKeys = appKeySet.iterator();
                    while (appKeys.hasNext()) {
                        SessionScope session = (SessionScope)appSessions.get(appKeys.next());
                        MemoryTracker mt = session.getMemoryTracker();
                        if (mt == null) continue;
                        sessionsScopeSize += mt.getEstimatedMemory();
                    }
                }
            }
        }
        memUtilSummary.put("SERVERSCOPESIZE", (Object)new Long(serverScopeSize));
        memUtilSummary.put("APPLICATIONSCOPESSIZE", (Object)new Long(appScopeSize));
        memUtilSummary.put("SESSIONSCOPESSIZE", (Object)new Long(sessionsScopeSize));
        return memUtilSummary;
    }

    public Map getJVMMemoryStats() {
        Struct map = new Struct();
        Runtime runtime = Runtime.getRuntime();
        long freeMemory = runtime.freeMemory();
        map.put("USEDMEMORY", new Long(runtime.totalMemory() - freeMemory));
        map.put("FREEMEMORY", new Long(freeMemory));
        return map;
    }

    static {
        memoryMonitorEnabled = false;
        profilingEnabled = false;
        scopeNames = new String[]{"VAR", "ARGUMENTS", "THREAD", "VARIABLES", "THIS", "REQUEST", "SESSION", "APPLICATION", "SERVER"};
    }

    private class TopLargeScopeAttributes
    extends MonitorList {
        private TopLargeScopeAttributes() {
        }

        @Override
        protected boolean compare(Object toInsert, Object fromList) {
            long fromListSize;
            long toInsertSize = ((VariableInfo)toInsert).getSize();
            return toInsertSize < (fromListSize = ((VariableInfo)fromList).getSize());
        }

        @Override
        protected Iterator getSourceData() {
            return null;
        }

        @Override
        protected boolean compareThreshold(Object toInsert) {
            return ((VariableInfo)toInsert).getSize() == 0L;
        }
    }

    private class VariableInfo {
        private Object name;
        private Object value;
        private long size;

        public VariableInfo(Object name, Object value) {
            this.name = name;
            this.value = value;
            this.size = MemoryCalculator.calculateMemory(this.value);
        }

        public long getSize() {
            return this.size;
        }

        public Map toVariableMap() {
            Struct attrDetails = new Struct();
            attrDetails.put("VARIABLENAME", this.name);
            String varType = AttributeTypes.getAttributeType(this.value);
            if ("SIMPLE".equals(varType)) {
                String varValue = "";
                if (this.value != null) {
                    varValue = this.value.toString();
                }
                if (varValue.length() > 100) {
                    varValue = varValue.substring(0, 99);
                }
                attrDetails.put("VARIABLETYPE", (Object)varValue);
            } else {
                attrDetails.put("VARIABLETYPE", (Object)varType);
            }
            attrDetails.put("size", (Object)new Long(this.size));
            return attrDetails;
        }
    }
}

