/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.memory;

import coldfusion.monitor.memory.MemoryCalculator;
import coldfusion.monitor.memory.MemoryTrackable;
import coldfusion.monitor.memory.MemoryTracker;
import coldfusion.monitor.util.AttributeTypes;
import coldfusion.monitor.util.RequestMonitorData;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

public class MemoryTrackerProxy {
    private MemoryTrackerList mtList = new MemoryTrackerList();
    private Map memoryTrackables = new IdentityHashMap();
    private boolean[] rootTrackerScopeTypes = new boolean[9];
    private int highestTrackerScopeType = -1;
    private MemoryTrackable trackedObject = null;
    private MemoryTracker builtInTracker;
    private boolean loading = false;
    private static boolean enabled = false;
    private static boolean profilingEnabled = false;

    public static boolean checkEnabled(MemoryTrackable mto) {
        if (!enabled || mto == null) {
            return false;
        }
        if (mto.getMemoryTrackerProxy() == null) {
            mto.setMemoryTrackerProxy(new MemoryTrackerProxy(mto));
        }
        return true;
    }

    public static void setEnabled(boolean isEnabled) {
        enabled = isEnabled;
    }

    public static void setProfilingEnabled(boolean isEnabled) {
        profilingEnabled = isEnabled;
    }

    public MemoryTrackerProxy(MemoryTrackable trackedObject) {
        this.trackedObject = trackedObject;
        this.builtInTracker = new MemoryTracker(trackedObject);
        this.registerMemoryTracker(this.builtInTracker);
    }

    public MemoryTracker getBuiltInMemoryTracker() {
        return this.builtInTracker;
    }

    public Object getTrackedObject() {
        return this.trackedObject;
    }

    public void setBuiltInTrackerScopeType(int scopeType) {
        if (scopeType == -1) {
            return;
        }
        this.builtInTracker.setScopeType(scopeType);
        this.rootTrackerScopeTypes[scopeType] = true;
        if (scopeType > this.highestTrackerScopeType) {
            this.highestTrackerScopeType = scopeType;
        }
    }

    public int getHighestTrackerScopeType() {
        return this.highestTrackerScopeType;
    }

    public boolean isHighestScopePersistent() {
        return this.highestTrackerScopeType >= 6;
    }

    public int getRefCount(MemoryTracker mt) {
        return this.mtList.getRefCount(mt);
    }

    public int registerMemoryTracker(MemoryTracker mt) {
        IdentityHashMap registeredTrackables = new IdentityHashMap();
        return this.registerMemoryTracker(mt, registeredTrackables);
    }

    private int registerMemoryTracker(MemoryTracker mt, Map registeredTrackables) {
        int refCount = this.mtList.register(mt);
        registeredTrackables.put(this.getTrackedObject(), this.getTrackedObject());
        if (refCount == 1) {
            for (MemoryTrackable memoryTrackable : this.memoryTrackables.keySet()) {
                if (registeredTrackables.containsKey(memoryTrackable)) continue;
                memoryTrackable.getMemoryTrackerProxy().registerMemoryTracker(mt, registeredTrackables);
            }
            if (mt.getScopeType() != -1) {
                this.rootTrackerScopeTypes[mt.getScopeType()] = true;
                if (mt.getScopeType() > this.highestTrackerScopeType) {
                    this.highestTrackerScopeType = mt.getScopeType();
                    this.builtInTracker.setScopeType(mt.getScopeType());
                }
            }
        }
        return refCount;
    }

    public int unregisterMemoryTracker(MemoryTracker mt) {
        IdentityHashMap unregisteredTrackables = new IdentityHashMap();
        return this.unregisterMemoryTracker(mt, unregisteredTrackables);
    }

    private int unregisterMemoryTracker(MemoryTracker mt, Map unregisteredTrackables) {
        int refCount = this.mtList.unregister(mt);
        unregisteredTrackables.put(this.getTrackedObject(), this.getTrackedObject());
        if (refCount == 0) {
            for (MemoryTrackable memoryTrackable : this.memoryTrackables.keySet()) {
                if (unregisteredTrackables.containsKey(memoryTrackable)) continue;
                memoryTrackable.getMemoryTrackerProxy().unregisterMemoryTracker(mt, unregisteredTrackables);
            }
            if (mt.getScopeType() != -1) {
                this.rootTrackerScopeTypes[mt.getScopeType()] = false;
                if (mt.getScopeType() == this.highestTrackerScopeType) {
                    for (int i = mt.getScopeType() - 1; i >= 0; --i) {
                        if (!this.rootTrackerScopeTypes[i]) continue;
                        this.highestTrackerScopeType = i;
                        break;
                    }
                    if (mt.getScopeType() == this.highestTrackerScopeType) {
                        this.highestTrackerScopeType = -1;
                    }
                }
            }
        }
        return refCount;
    }

    public void onAddObject(Object o) {
        if (this.registerMemoryTrackable(o) > -1) {
            long size = MemoryCalculator.calculateMemory(o);
            for (int i = 0; i < this.mtList.getSize(); ++i) {
                MemoryTracker mt = this.mtList.getTracker(i);
                if (mt == null) continue;
                mt.onAddObject(o, size);
            }
        }
    }

    public void onAddCollection(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            this.onAddObject(i.next());
        }
    }

    public void onRemoveObject(Object o) {
        long size = MemoryCalculator.calculateMemory(o, true);
        for (int i = 0; i < this.mtList.getSize(); ++i) {
            MemoryTracker mt = this.mtList.getTracker(i);
            if (mt == null) continue;
            mt.onRemoveObject(o, size);
        }
        this.unregisterMemoryTrackable(o);
    }

    public void onRemoveCollection(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            this.onRemoveObject(i.next());
        }
    }

    public void disable() {
        this.trackedObject.setMemoryTrackerProxy(null);
        this.trackedObject = null;
        this.builtInTracker = null;
        this.mtList.clear();
        Iterator iter = this.memoryTrackables.keySet().iterator();
        while (iter.hasNext()) {
            MemoryTrackerProxy mtp = ((MemoryTrackable)iter.next()).getMemoryTrackerProxy();
            if (mtp == null) continue;
            mtp.disable();
        }
        this.memoryTrackables.clear();
    }

    public void reload() {
        HashSet set = new HashSet();
        this.reload(set);
    }

    private void reload(HashSet set) {
        Iterator values;
        this.loading = true;
        set.add(this);
        if (!this.isRegistered(this.builtInTracker)) {
            this.registerMemoryTracker(this.builtInTracker);
        }
        if ((values = this.trackedObject.valuesIterator()) != null) {
            while (values.hasNext()) {
                Object value = values.next();
                if (value instanceof MemoryTrackable) {
                    MemoryTrackable mto = (MemoryTrackable)value;
                    MemoryTrackerProxy m = mto.getMemoryTrackerProxy();
                    if (m == null) {
                        m = new MemoryTrackerProxy(mto);
                        mto.setMemoryTrackerProxy(m);
                    }
                    if (mto.getMemoryTrackerProxy() == null) continue;
                    m.setLoading(true);
                    this.onAddObject(value);
                    boolean isRegistered = m.isRegistered(this.builtInTracker);
                    if (!isRegistered && !set.contains(m)) {
                        m.reload(set);
                    }
                    m.setLoading(false);
                    continue;
                }
                this.onAddObject(value);
            }
        }
        this.loading = false;
    }

    protected void setLoading(boolean loading) {
        this.loading = loading;
    }

    protected boolean isLoading() {
        return this.loading;
    }

    public boolean isRegistered(MemoryTracker mt) {
        return this.mtList.isRegistered(mt);
    }

    public void resetMemory() {
        long size = this.builtInTracker.getEstimatedMemory();
        for (int i = 0; i < this.mtList.getSize(); ++i) {
            MemoryTracker mt = this.mtList.getTracker(i);
            if (mt == null) continue;
            mt.decrementMemory(size);
        }
    }

    public void onPut(Object name, Object value, Object oldValue, boolean keyExists) {
        this.onReplaceValue(name.toString(), value, oldValue, true);
    }

    public void onRemove(Object name, Object value, boolean keyExists) {
        if (keyExists) {
            long size = MemoryCalculator.calculateMemory(value, true);
            for (int i = 0; i < this.mtList.getSize(); ++i) {
                MemoryTracker mt = this.mtList.getTracker(i);
                if (mt == null) continue;
                mt.onRemoveObject(value, size);
            }
        }
        this.unregisterMemoryTrackable(value);
    }

    public void onReplace(Object newVal, Object oldVal) {
        this.onReplaceValue(null, newVal, oldVal, false);
    }

    public void onReplace(String name, Object newVal, Object oldVal) {
        this.onReplaceValue(name, newVal, oldVal, true);
    }

    private void onReplaceValue(String name, Object newVal, Object oldVal, boolean trackVariable) {
        short oldValUnregistered = this.unregisterMemoryTrackable(oldVal);
        short newValRegistered = this.registerMemoryTrackable(newVal);
        if (oldValUnregistered == -1 && newValRegistered == -1) {
            return;
        }
        long sizeOld = 0L;
        long sizeNew = 0L;
        if (oldValUnregistered > -1) {
            sizeOld = MemoryCalculator.calculateMemory(oldVal, true);
        }
        if (newValRegistered > -1) {
            sizeNew = MemoryCalculator.calculateMemory(newVal);
        }
        for (int i = 0; i < this.mtList.getSize(); ++i) {
            MemoryTracker mt = this.mtList.getTracker(i);
            if (mt == null) continue;
            if (oldValUnregistered > -1) {
                mt.onRemoveObject(oldVal, sizeOld);
            }
            if (newValRegistered <= -1) continue;
            mt.onAddObject(newVal, sizeNew);
        }
        RequestMonitorData current = RequestMonitorData.getCurrent();
        if (current == null || !current.shouldProfile() || !current.isProfileMemory() || current.isTagFunctionLimitExceeded()) {
            return;
        }
        int scopeType = this.builtInTracker.getScopeType();
        if (trackVariable && scopeType > -1 && scopeType < 6) {
            MemoryTrackerProxy newValMTP;
            int newValHighestScope = -1;
            if (newValRegistered == 1 && (newValMTP = ((MemoryTrackable)newVal).getMemoryTrackerProxy()) != null) {
                newValHighestScope = newValMTP.getHighestTrackerScopeType();
            }
            if (newValHighestScope <= 5) {
                RequestMonitorData rmd;
                MemoryTracker varmt = null;
                String type = AttributeTypes.getAttributeType(newVal);
                boolean removeOld = false;
                if (type != "JAVA" && type != "SIMPLE") {
                    MemoryTrackerProxy mtp = ((MemoryTrackable)newVal).getMemoryTrackerProxy();
                    if (mtp != null) {
                        varmt = mtp.getBuiltInMemoryTracker();
                    } else {
                        removeOld = true;
                    }
                }
                if ((rmd = RequestMonitorData.getCurrent()) != null) {
                    rmd.updateVariableStat(name, scopeType, varmt, sizeNew, type, removeOld);
                }
            }
        }
    }

    private short registerMemoryTrackable(Object o) {
        short status = -1;
        if (o != null) {
            if (o instanceof MemoryTrackable) {
                MemoryTrackable mto = (MemoryTrackable)o;
                MemoryTrackerProxy.checkEnabled(mto);
                MemoryTrackerProxy mtp = mto.getMemoryTrackerProxy();
                if (mtp != null && mtp.getHighestTrackerScopeType() <= this.highestTrackerScopeType) {
                    this.memoryTrackables.put(o, o);
                    status = 1;
                }
            } else {
                status = 0;
            }
        }
        return status;
    }

    private short unregisterMemoryTrackable(Object o) {
        short status = -1;
        if (o != null) {
            if (o instanceof MemoryTrackable) {
                if (this.memoryTrackables.remove(o) != null) {
                    status = 1;
                }
            } else {
                status = 0;
            }
        }
        return status;
    }

    private class MemoryTrackerList {
        private static final int INITIAL_SIZE = 5;
        private static final int GROW_BY = 5;
        private int lastIndex = 0;
        private MemoryTracker[] trackers = new MemoryTracker[5];
        private int[] refCount = new int[5];

        private MemoryTrackerList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int register(MemoryTracker mt) {
            if (mt.getScopeType() < MemoryTrackerProxy.this.builtInTracker.getScopeType()) {
                return -1;
            }
            int firstEmptyIndex = -1;
            MemoryTrackerList memoryTrackerList = this;
            synchronized (memoryTrackerList) {
                for (int i = 0; i < this.lastIndex; ++i) {
                    if (this.trackers[i] == mt) {
                        int n = i;
                        int n2 = this.refCount[n] + 1;
                        this.refCount[n] = n2;
                        return n2;
                    }
                    if (firstEmptyIndex != -1 || this.trackers[i] != null) continue;
                    firstEmptyIndex = i;
                }
                int insertIndex = firstEmptyIndex;
                if (firstEmptyIndex == -1) {
                    this.resize();
                    insertIndex = this.lastIndex++;
                }
                this.trackers[insertIndex] = mt;
                this.refCount[insertIndex] = 1;
            }
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int unregister(MemoryTracker mt) {
            if (mt.getScopeType() < MemoryTrackerProxy.this.highestTrackerScopeType) {
                return -1;
            }
            int ref = 0;
            MemoryTrackerList memoryTrackerList = this;
            synchronized (memoryTrackerList) {
                for (int i = 0; i < this.lastIndex; ++i) {
                    if (this.trackers[i] != mt) continue;
                    int n = i;
                    int n2 = this.refCount[n] - 1;
                    this.refCount[n] = n2;
                    ref = n2;
                    if (this.refCount[i] != 0) continue;
                    this.trackers[i] = null;
                }
            }
            return ref;
        }

        MemoryTracker getTracker(int index) {
            return this.trackers[index];
        }

        int getSize() {
            return this.lastIndex;
        }

        synchronized int getRefCount(MemoryTracker mt) {
            for (int i = 0; i < this.lastIndex; ++i) {
                if (this.trackers[i] != mt) continue;
                return this.refCount[i];
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isRegistered(MemoryTracker mt) {
            boolean registered = false;
            MemoryTrackerList memoryTrackerList = this;
            synchronized (memoryTrackerList) {
                for (int i = 0; i < this.lastIndex; ++i) {
                    if (this.trackers[i] != mt) continue;
                    registered = true;
                }
            }
            return registered;
        }

        void clear() {
            this.trackers = new MemoryTracker[5];
            this.refCount = new int[5];
        }

        private void resize() {
            if (this.lastIndex == this.trackers.length) {
                MemoryTracker[] newTrackers = new MemoryTracker[this.trackers.length + 5];
                int[] newRefCount = new int[this.refCount.length + 5];
                System.arraycopy(this.trackers, 0, newTrackers, 0, this.trackers.length);
                System.arraycopy(this.refCount, 0, newRefCount, 0, this.refCount.length);
                this.trackers = newTrackers;
                this.refCount = newRefCount;
            }
        }
    }
}

