/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.memory;

import coldfusion.monitor.memory.MemoryTracker;

public class VariableStat {
    private String name;
    private String type;
    private String templatePath;
    private String functionName;
    private long maxSize;
    private int scopeType;
    private String key;
    private MemoryTracker mt;
    private static final String NO_FUNCTION = "";

    public VariableStat(String name, int scopeType, String templatePath, String functionName) {
        this.name = name;
        this.scopeType = scopeType;
        this.templatePath = templatePath;
        this.functionName = functionName == null ? NO_FUNCTION : functionName;
        this.key = VariableStat.makeKey(templatePath, functionName, name, scopeType);
    }

    public String getName() {
        return this.name;
    }

    public String getTemplateName() {
        return this.templatePath;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public long getMaxSize() {
        long max = 0L;
        max = this.mt == null ? this.maxSize : (this.mt.getEstimatedMaxMemory() > this.maxSize ? this.mt.getEstimatedMaxMemory() : this.maxSize);
        return max;
    }

    public void setSize(long size) {
        if (size > this.maxSize) {
            this.maxSize = size;
        }
    }

    public void setMemoryTracker(MemoryTracker newmt) {
        if (this.mt != null) {
            this.maxSize = this.mt.getEstimatedMaxMemory() > this.maxSize ? this.mt.getEstimatedMaxMemory() : this.maxSize;
        }
        this.mt = newmt;
    }

    public int getScopeType() {
        return this.scopeType;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void update(VariableStat stat) {
        stat.setMemoryTracker(null);
    }

    public String getKey() {
        return this.key;
    }

    public static String makeKey(String templatePath, String functionName, String name, int scopeType) {
        StringBuffer buf = new StringBuffer(templatePath);
        buf.append(functionName).append(name).append(scopeType);
        return buf.toString();
    }

    public MemoryTracker getMemoryTracker() {
        return this.mt;
    }
}

