/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.scheduler;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.beans.NonRequestData;
import coldfusion.monitor.datastore.Client;
import coldfusion.monitor.datastore.JSONConverter;
import coldfusion.monitor.scheduler.NonRequestTask;
import coldfusion.monitor.util.MonitoringServiceUtils;
import coldfusion.runtime.Struct;
import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

public class GCListener
implements NotificationListener {
    private static Logger logger = CFLogs.SERVER_LOG;
    private static long nonRequestMetricsSentTime = System.currentTimeMillis();
    private static long OFFSET = 5000L;

    @Override
    public void handleNotification(Notification notif, Object handback) {
        logger.debug("start GC notification " + notif.getType());
        if (!Configuration.INSTANCE.getMonitorSettings().isMonitoringEnabled() || !Configuration.INSTANCE.getMonitorSettings().getBasicMonitoring().isGcmetrics()) {
            return;
        }
        String type = notif.getType();
        logger.debug("GC notification type " + type);
        if (type.equals("com.sun.management.gc.notification")) {
            GarbageCollectionNotificationInfo gcNotif = GarbageCollectionNotificationInfo.from((CompositeData)notif.getUserData());
            try {
                GCListener.checkGarbageCollectionNotificationInfoContent(gcNotif);
            }
            catch (Exception e) {
                logger.error("GCListener:checkGarbageCollectionNotificationInfoContent", e);
            }
        }
    }

    private static void checkGarbageCollectionNotificationInfoContent(GarbageCollectionNotificationInfo notif) throws Exception {
        GcInfo info = notif.getGcInfo();
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        Map<String, MemoryUsage> usage = info.getMemoryUsageBeforeGc();
        Struct gc = new Struct();
        gc.put("notification", (Object)notif.getGcName());
        gc.put("action", (Object)notif.getGcAction());
        gc.put("cause", (Object)notif.getGcCause());
        gc.put("id", (Object)info.getId());
        gc.put("start", (Object)(info.getStartTime() + bean.getStartTime()));
        gc.put("end", (Object)(info.getEndTime() + bean.getStartTime()));
        gc.put("duration", (Object)info.getDuration());
        NonRequestData jsonDataCont = new NonRequestData();
        if (Configuration.INSTANCE.isMonitoringEnabled()) {
            jsonDataCont.setGcData(gc);
            jsonDataCont.setTimeStamp(System.currentTimeMillis());
            if (System.currentTimeMillis() >= nonRequestMetricsSentTime + OFFSET) {
                NonRequestTask task2 = new NonRequestTask();
                task2.collectNonRequestMetrics(jsonDataCont);
                nonRequestMetricsSentTime = System.currentTimeMillis();
                logger.debug("Sending non-request metrics after 5 sec ");
            }
        }
        if (Client.get().isInitialized()) {
            Client.get().submit(JSONConverter.toJson(jsonDataCont), MonitoringServiceUtils.getLatestNonRequestIndex());
        }
    }

    public static void registerGCListener() {
        logger.debug("GCListener: register GC listener start");
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName gcMXBeanPattern = new ObjectName("java.lang:type=GarbageCollector,*");
            Set<ObjectName> names = mbs.queryNames(gcMXBeanPattern, null);
            for (ObjectName n : names) {
                if (!mbs.isInstanceOf(n, "javax.management.NotificationEmitter")) continue;
                GCListener listener = new GCListener();
                mbs.addNotificationListener(n, listener, null, null);
            }
        }
        catch (MalformedObjectNameException e) {
            logger.error("GCListener:MalformedObjectNameException", e);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
        logger.info("GCListener: registered GC listener ");
    }
}

