/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.scheduler;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.MonitoringConstants;
import coldfusion.monitor.active.ActiveRequestMonitor;
import coldfusion.monitor.active.TemplateCacheMonitor;
import coldfusion.monitor.alert.AlertUtils;
import coldfusion.monitor.beans.NonRequestData;
import coldfusion.monitor.datastore.Client;
import coldfusion.monitor.datastore.JSONConverter;
import coldfusion.monitor.memory.MemoryMonitor;
import coldfusion.monitor.scheduler.TaskScheduler;
import coldfusion.monitor.sql.JDBCPoolMonitor;
import coldfusion.monitor.sql.QueryMonitor;
import coldfusion.monitor.throttle.RequestThrottleMonitor;
import coldfusion.monitor.util.CommonUtil;
import coldfusion.monitor.util.MonitoringServiceUtils;
import coldfusion.runtime.SessionTracker;
import coldfusion.runtime.Struct;
import coldfusion.server.MonitoringService;
import coldfusion.server.ServiceFactory;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class NonRequestTask
implements Runnable {
    private Logger logger = CFLogs.MONITOR_LOG;
    private static final long MEBI = 0x100000L;
    private static long prevBytesIn = 0L;
    private static long prevBytesOut = 0L;
    private static long prevSnapShottime = -1L;

    @Override
    public void run() {
        this.logger.debug("started NonRequestTask");
        if (!Configuration.INSTANCE.isMonitoringEnabled()) {
            return;
        }
        NonRequestData rqd = new NonRequestData();
        rqd.setTimeStamp(System.currentTimeMillis());
        this.collectNonRequestMetrics(rqd);
        AlertUtils.triggerSchedulerBasedAlert();
        String json = JSONConverter.toJson(rqd);
        Client.get().submit(json, MonitoringServiceUtils.getLatestNonRequestIndex());
        this.logger.debug("submitted NonRequest Data " + json);
    }

    public void collectNonRequestMetrics(NonRequestData rqd) {
        this.logger.debug("Started collecting non request metrics");
        try {
            this.updateMemoryStat(rqd);
            this.updateJITStat(rqd);
            this.updateThreadStat(rqd);
            this.updateSystemData(rqd);
            this.updateTomcatJMXData(rqd);
            this.updateClassLoadingData(rqd);
            this.updateCFCMetrics(rqd);
            this.updateSessionData(rqd);
            this.updateAppSessionData(rqd);
            this.updateApplicationMemoryData(rqd);
            this.updateServerScopeMemoryData(rqd);
        }
        catch (Exception ex) {
            this.logger.error("Exception occurred while collecting NonRequest data", ex);
        }
        this.logger.debug("Finished collecting non request metrics");
    }

    private void updateAppSessionData(NonRequestData rqd) {
        try {
            Set<String> uniqueApps = Configuration.INSTANCE.getApplications();
            if (uniqueApps == null) {
                return;
            }
            ArrayList<Struct> appSessions = null;
            for (String app : uniqueApps) {
                long count = SessionTracker.getActiveSessionCount(app);
                if (count == 0L) continue;
                if (appSessions == null) {
                    appSessions = new ArrayList<Struct>();
                }
                Struct appSession = new Struct();
                appSession.put("name", (Object)app);
                appSession.put("count", (Object)count);
                appSessions.add(appSession);
            }
            rqd.setAppSessions(appSessions);
        }
        catch (Exception ex) {
            this.logger.error("Exception occurred while collecting app seesion Metrics", ex);
        }
    }

    private void updateSessionData(NonRequestData rqd) {
        try {
            if (!Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isSessionMetrics()) {
                return;
            }
            this.logger.debug("Started collecting session metrics");
            rqd.setSessionCount(SessionTracker.getSessionCount());
            rqd.setExpiredSessionCount(SessionTracker.getExpiredSessionCount());
            SessionTracker.clearExpiredSessionCount();
            this.logger.debug("Finished collecting session metrics");
        }
        catch (Exception ex) {
            this.logger.error("Exception occurred while collecting session Metrics", ex);
        }
    }

    private void updateApplicationMemoryData(NonRequestData rqd) {
        try {
            if (!Configuration.INSTANCE.getMonitorSettings().isCfMemoryMonitoringEnabled()) {
                return;
            }
            this.logger.debug("Started collecting App Scope metrics");
            rqd.setAllAppScopeData(MemoryMonitor.INSTANCE.getAllApplicationScopeMemoryUsed());
            this.logger.debug("Finished collecting App Scope metrics");
        }
        catch (Exception ex) {
            this.logger.error("Exception occurred while collecting application memory Metrics", ex);
        }
    }

    private void updateServerScopeMemoryData(NonRequestData rqd) {
        try {
            if (!Configuration.INSTANCE.getMonitorSettings().isCfMemoryMonitoringEnabled()) {
                return;
            }
            this.logger.debug("Started collecting Server Scope metrics");
            rqd.setServerScopeData(MemoryMonitor.INSTANCE.getServerScopeMemoryUsed(true));
            this.logger.debug("Finished collecting Server Scope metrics");
        }
        catch (Exception ex) {
            this.logger.error("Exception occurred while collecting server scope Metrics", ex);
        }
    }

    private void updateCFCMetrics(NonRequestData jsonHolder) {
        try {
            if (!Configuration.INSTANCE.getMonitorSettings().getBasicMonitoring().isCfmetrics()) {
                return;
            }
            this.logger.debug("Started collecting cfmetrics metrics");
            jsonHolder.setThrottleData(RequestThrottleMonitor.getInstance().getCurrentThrottleStats());
            jsonHolder.setTemplateCache(TemplateCacheMonitor.getTemplateCacheStats());
            jsonHolder.setQueryCache(QueryMonitor.INSTANCE.getQueryCacheStats());
            jsonHolder.setCfThreadQueue(ActiveRequestMonitor.getInstance().getCFThreadQueueStats());
            jsonHolder.setCallableQueue(ActiveRequestMonitor.getInstance().getCallableQueueStats());
            List arrayList = JDBCPoolMonitor.getInstance().getDbPoolStats();
            if (arrayList.size() == 0) {
                arrayList.add(MonitoringConstants.getDbPoolStatsDummy());
            }
            jsonHolder.setDbPoolStats(arrayList);
            jsonHolder.setRequestQueueStats(ActiveRequestMonitor.getInstance().getRequestQueueStats());
            this.logger.debug("Finished collecting cfmetrics metrics");
        }
        catch (Exception ex) {
            this.logger.error("Exception occurred while collecting CF Metrics", ex);
        }
    }

    private void updateSystemData(NonRequestData rqd) {
        try {
            this.logger.debug("Started collecting System metrics");
            Object sinf = TaskScheduler.INSTANCE.getOSHIInstance();
            MonitoringService monitoringService = ServiceFactory.getMonitoringService(true);
            monitoringService.updateNetworkMetrics(rqd, sinf);
            monitoringService.updateOtherSystemMetrics(rqd, sinf);
            this.logger.debug("Finished collecting System metrics");
        }
        catch (Exception ex) {
            this.logger.error("Exception occurred while collecting System Metrics", ex);
        }
    }

    private void updateClassLoadingData(NonRequestData rqd) {
        try {
            if (!Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isClassLoadingMetrics()) {
                return;
            }
            this.logger.debug("Started collecting classloading metrics");
            ClassLoadingMXBean classLoadBean = ManagementFactory.getClassLoadingMXBean();
            Struct classLoadData = new Struct();
            classLoadData.put("loaded_count", (Object)classLoadBean.getLoadedClassCount());
            classLoadData.put("total_loaded_count", (Object)classLoadBean.getTotalLoadedClassCount());
            classLoadData.put("unloaded_count", (Object)classLoadBean.getUnloadedClassCount());
            rqd.setClassLoadData(classLoadData);
            this.logger.debug("Finished collecting classloading metrics");
        }
        catch (Exception ex) {
            this.logger.error("Exception occurred while collecting classloading Metrics", ex);
        }
    }

    private void updateThreadStat(NonRequestData rqd) {
        try {
            if (!Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isThreadPoolsMetrics()) {
                return;
            }
            this.logger.debug("Started collecting Thread metrics");
            ThreadMXBean txBean = ManagementFactory.getThreadMXBean();
            RuntimeMXBean mxbean = ManagementFactory.getPlatformMXBean(RuntimeMXBean.class);
            String vendor = mxbean.getVmVendor();
            Struct td = new Struct();
            td.put("current_count", (Object)txBean.getThreadCount());
            td.put("total_started_count", (Object)txBean.getTotalStartedThreadCount());
            td.put("peak_count", (Object)txBean.getPeakThreadCount());
            td.put("daemon_count", (Object)txBean.getDaemonThreadCount());
            if (txBean.findDeadlockedThreads() != null) {
                td.put("dead_lock", (Object)txBean.findDeadlockedThreads().length);
            }
            td.put("vendor", (Object)(vendor + "vendor version: " + mxbean.getVmVersion() + "spec vendor  " + mxbean.getSpecVendor() + "spec ver " + mxbean.getSpecVersion()));
            rqd.setThreadData(td);
            this.logger.debug("Finished collecting Thread metrics");
        }
        catch (Exception ex) {
            this.logger.error("Exception occurred while collecting Thread Metrics", ex);
        }
    }

    private void updateTomcatJMXData(NonRequestData rqd) {
        try {
            RuntimeMXBean mxbean = ManagementFactory.getPlatformMXBean(RuntimeMXBean.class);
            ArrayList<Struct> threadPool = new ArrayList<Struct>();
            try {
                long elapseTime;
                float dtime;
                MBeanServer mbServer = ManagementFactory.getPlatformMBeanServer();
                Set<ObjectInstance> mBeanSet = mbServer.queryMBeans(null, null);
                for (ObjectInstance objectInstance : mBeanSet) {
                    String subType;
                    ObjectName objectName = objectInstance.getObjectName();
                    String type = objectName.getKeyProperty("type");
                    if (type == null || !type.equals("ThreadPool") || (subType = objectName.getKeyProperty("subType")) != null) continue;
                    Struct tp = new Struct();
                    String name = objectName.getKeyProperty("name");
                    if (!name.isEmpty()) {
                        name = name.replace("\"", "");
                    }
                    tp.put("name", (Object)name);
                    tp.put("current_thread_busy", mbServer.getAttribute(objectName, "currentThreadsBusy"));
                    tp.put("max_threads", mbServer.getAttribute(objectName, "maxThreads"));
                    tp.put("current_thread_count", mbServer.getAttribute(objectName, "currentThreadCount"));
                    threadPool.add(tp);
                }
                rqd.setThreadPoolList(threadPool);
                ObjectName mbeanSession = new ObjectName("Catalina:type=Manager,context=/,host=localhost");
                if (mbeanSession != null) {
                    Set<ObjectName> names = mbServer.queryNames(mbeanSession, null);
                    Struct session = new Struct();
                    for (ObjectName objName : names) {
                        session.put("active_sessions", mbServer.getAttribute(objName, "activeSessions"));
                        session.put("expired_sessions", mbServer.getAttribute(objName, "expiredSessions"));
                        session.put("rejected_sessions", mbServer.getAttribute(objName, "rejectedSessions"));
                        session.put("session_max_alive_time", mbServer.getAttribute(objName, "sessionMaxAliveTime"));
                        session.put("max_active_sessions", mbServer.getAttribute(objName, "maxActiveSessions"));
                    }
                    rqd.setSessionData(session);
                }
                Struct mbeanMetrics = new Struct();
                Set<ObjectInstance> set = mbServer.queryMBeans(new ObjectName("*:type=GlobalRequestProcessor,*"), null);
                Iterator<ObjectInstance> iterator = set.iterator();
                long currBytesIn = 0L;
                long currBytesOut = 0L;
                while (iterator.hasNext()) {
                    ObjectInstance oi = iterator.next();
                    ObjectName objectName = oi.getObjectName();
                    String subType = objectName.getKeyProperty("subType");
                    if (subType != null) continue;
                    currBytesIn += ((Long)mbServer.getAttribute(objectName, "bytesReceived")).longValue();
                    currBytesOut += ((Long)mbServer.getAttribute(objectName, "bytesSent")).longValue();
                }
                long currentTime = System.currentTimeMillis();
                double bytesIn = 0.0;
                double bytesOut = 0.0;
                if (prevSnapShottime != -1L && (double)(dtime = (float)(elapseTime = currentTime - prevSnapShottime) / 1000.0f) > 0.0) {
                    bytesIn = CommonUtil.round((float)(currBytesIn - prevBytesIn) / dtime, 4);
                    bytesOut = CommonUtil.round((float)(currBytesOut - prevBytesOut) / dtime, 4);
                }
                mbeanMetrics.put("bytes_in", (Object)bytesIn);
                mbeanMetrics.put("bytes_out", (Object)bytesOut);
                prevBytesIn = currBytesIn;
                prevBytesOut = currBytesOut;
                prevSnapShottime = currentTime;
                rqd.setmbeanMetrics(mbeanMetrics);
            }
            catch (MalformedObjectNameException e) {
                e.printStackTrace();
            }
            catch (AttributeNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstanceNotFoundException e) {
                e.printStackTrace();
            }
            catch (MBeanException e) {
                e.printStackTrace();
            }
            catch (ReflectionException e) {
                e.printStackTrace();
            }
        }
        catch (Exception ex) {
            this.logger.error("Exception occurred while collecting Tomcat JMX Metrics", ex);
        }
    }

    private void updateJITStat(NonRequestData rqd) {
        try {
            if (!Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isJitMetrics()) {
                return;
            }
            this.logger.debug("Started collecting JIT metrics");
            CompilationMXBean compilationMxBean = ManagementFactory.getCompilationMXBean();
            if (compilationMxBean.isCompilationTimeMonitoringSupported()) {
                Struct compileBean = new Struct();
                compileBean.put("Name", (Object)compilationMxBean.getName());
                compileBean.put("TotalCompilationTime", (Object)compilationMxBean.getTotalCompilationTime());
                rqd.setJITDetails(compileBean);
            }
            this.logger.debug("Finished collecting JIT metrics");
        }
        catch (Exception ex) {
            this.logger.error("Exception occurred while collecting JIT Metrics", ex);
        }
    }

    private void updateMemoryStat(NonRequestData rqd) {
        Object sinf = TaskScheduler.INSTANCE.getOSHIInstance();
        MonitoringService monitoringService = ServiceFactory.getMonitoringService(true);
        monitoringService.updateMemoryStat(rqd, sinf);
    }
}

