/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.scheduler;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.datastore.Client;
import coldfusion.monitor.datastore.JSONConverter;
import coldfusion.monitor.scheduler.NonRequestTask;
import coldfusion.monitor.scheduler.OperatingSystemMXBean;
import coldfusion.monitor.scheduler.PmsThreadFactory;
import coldfusion.runtime.ProtectedScope;
import coldfusion.runtime.Struct;
import coldfusion.server.MonitoringService;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public enum TaskScheduler {
    INSTANCE;

    long startTime = System.currentTimeMillis();
    ScheduledFuture nonRequestFutureTask;
    ScheduledExecutorService schedulerService;
    Object sinf;
    String jvm = "oracle";
    private Logger logger = CFLogs.MONITOR_LOG;
    boolean isStaticMetricsUpdated = true;

    public void start() {
        this.sinf = ServiceFactory.getMonitoringService(true).getSystemInfo();
        OperatingSystemMXBean.INSTANCE.initializeBeans();
        this.updateStaticMetrics();
        this.schedulerService = Executors.newScheduledThreadPool(4, new PmsThreadFactory("NonRequestTask"));
        NonRequestTask nonRequestTask = new NonRequestTask();
        long taskInterval = Configuration.INSTANCE.getMonitorSettings().getNonRequestTaskInterval();
        this.nonRequestFutureTask = this.schedulerService.scheduleAtFixedRate(nonRequestTask, 60L, taskInterval, TimeUnit.SECONDS);
    }

    public void reinitialise(Object sinf) {
        this.sinf = sinf;
    }

    public void updateStaticMetrics() {
        try {
            String node = Configuration.INSTANCE.getInstanceId();
            String clusterId = Configuration.INSTANCE.getClusterId();
            String groupId = Configuration.INSTANCE.getGroupId();
            String groupName = Configuration.INSTANCE.getGroupName();
            Struct memStat = new Struct();
            Struct system = new Struct();
            MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
            MemoryUsage hpUsg = memBean.getHeapMemoryUsage();
            MemoryUsage nonHpUsg = memBean.getNonHeapMemoryUsage();
            memStat.put("heap_init", (Object)hpUsg.getInit());
            memStat.put("heap_max", (Object)hpUsg.getMax());
            memStat.put("heap_committed", (Object)hpUsg.getCommitted());
            memStat.put("nonheap_init", (Object)nonHpUsg.getInit());
            memStat.put("nonheap_max", (Object)nonHpUsg.getMax());
            memStat.put("nonheap_committed", (Object)nonHpUsg.getCommitted());
            List<MemoryPoolMXBean> memPoolBns = ManagementFactory.getMemoryPoolMXBeans();
            long codecacheInit = 0L;
            long codecacheMax = 0L;
            long codeCacheCommit = 0L;
            for (MemoryPoolMXBean memPoolBn : memPoolBns) {
                String name = memPoolBn.getName().trim().replaceAll("\\s", "").toLowerCase();
                memStat.put(name + "_init", (Object)memPoolBn.getUsage().getInit());
                memStat.put(name + "_max", (Object)memPoolBn.getUsage().getMax());
                memStat.put(name + "_committed", (Object)memPoolBn.getUsage().getCommitted());
                if (name.startsWith("codeheap")) {
                    codecacheInit += memPoolBn.getUsage().getInit();
                    codecacheMax += memPoolBn.getUsage().getMax();
                    codeCacheCommit += memPoolBn.getUsage().getCommitted();
                }
                memStat.put("codecache_init", (Object)codecacheInit);
                memStat.put("codecache_max", (Object)codecacheMax);
                memStat.put("codecache_committed", (Object)codeCacheCommit);
            }
            memStat.put("instance_id", (Object)node);
            memStat.put("cluster_id", (Object)clusterId);
            memStat.put("time_stamp", (Object)System.currentTimeMillis());
            memStat.put("group_id", (Object)groupId);
            memStat.put("group_name", (Object)groupName);
            this.updateSystemInfo(node, clusterId, system);
            Client.get().indexDocument(JSONConverter.toJson(memStat), "node_memory", node + "-memory-" + String.valueOf(this.startTime));
            Client.get().indexDocument(JSONConverter.toJson(system), "node_system", node + "-system");
            this.isStaticMetricsUpdated = true;
        }
        catch (Throwable ex) {
            this.logger.error("Exception occurred while updating static system/memory metrics", ex);
            this.isStaticMetricsUpdated = false;
        }
    }

    private void updateSystemInfo(String node, String clusterId, Struct system) {
        MonitoringService monitoringService = ServiceFactory.getMonitoringService(true);
        monitoringService.updateSystemInfo(system, this.sinf);
        system.put("instance_id", (Object)node);
        system.put("cluster_id", (Object)clusterId);
        system.put("time_stamp", (Object)System.currentTimeMillis());
        RuntimeService runtimeService = ServiceFactory.getRuntimeService();
        ProtectedScope scope = (ProtectedScope)runtimeService.getServerScope().get("coldfusion");
        system.put("appserver", scope.get("appserver"));
        system.put("productversion", scope.get("productversion"));
        system.put("updatelevel", scope.get("updatelevel"));
        system.put("productlevel", scope.get("productlevel"));
        system.put("java_home", (Object)System.getProperty("java.home"));
        system.put("java_vendor", (Object)System.getProperty("java.vendor"));
        system.put("java_version", (Object)System.getProperty("java.version"));
        system.put("cfstartedat", (Object)this.startTime);
        system.put("osfamily", (Object)System.getProperty("os.name"));
    }

    public void stop() {
        if (this.nonRequestFutureTask != null) {
            this.nonRequestFutureTask.cancel(false);
        }
    }

    public Object getOSHIInstance() {
        return this.sinf;
    }

    public void changeScheduleInterval(long time) {
        if (time > 0L && this.schedulerService != null) {
            this.stop();
            NonRequestTask nonRequestTask = new NonRequestTask();
            this.nonRequestFutureTask = this.schedulerService.scheduleAtFixedRate(nonRequestTask, 0L, time, TimeUnit.SECONDS);
        }
    }

    public String getJvm() {
        return this.jvm;
    }

    public void setJvm(String jvm) {
        this.jvm = jvm;
    }
}

