/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.sql;

import coldfusion.monitor.Configuration;
import coldfusion.monitor.memory.MemoryCalculator;
import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.monitor.sql.QueryStat;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.monitor.util.ThreadDictionary;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.CachedQuery;
import coldfusion.sql.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public enum QueryMonitor {
    INSTANCE;


    public static QueryMonitor getInstance() {
        return INSTANCE;
    }

    public QueryStat onQueryStart(String templatePath, String functionName, int lineNo, String name, boolean isCached, String DSN, String sql, RequestMonitorData rmd) {
        QueryStat stat = new QueryStat(name, templatePath, functionName, lineNo, isCached, DSN, 1L);
        stat.setStarted();
        stat.setSql(sql);
        rmd.setActiveQueryStat(stat);
        return stat;
    }

    public QueryStat onQueryStart(String templatePath, String functionName, int lineNo, String name, boolean isCached, String DSN, String sql, RequestMonitorData rmd, String uri, String Method2, boolean isStoredProc) {
        QueryStat stat = new QueryStat(name, templatePath, functionName, lineNo, isCached, DSN, 1L, uri, Method2);
        stat.setStarted();
        stat.setSql(sql);
        stat.setQueryType(sql);
        stat.setStoredProc(isStoredProc);
        rmd.setActiveQueryStat(stat);
        return stat;
    }

    public List getActiveQueries() {
        ArrayList<Map> queries = new ArrayList<Map>();
        ThreadDictionary.FusionContextExtraInfo[] threadInfo = ThreadDictionary.getInstance().getCurrentValues();
        for (int i = 0; i < threadInfo.length; ++i) {
            QueryStat activeQueryStat;
            RequestMonitorData rmd = threadInfo[i].getMonitorData();
            if (rmd == null || (activeQueryStat = rmd.getActiveQueryStat()) == null) continue;
            queries.add(activeQueryStat.toMap());
        }
        return queries;
    }

    public void onQueryEnd(String templatePath, boolean isError, RequestMonitorData rmd, Throwable ex) {
        QueryStat stat = rmd.getActiveQueryStat();
        if (stat == null) {
            return;
        }
        rmd.setActiveQueryStat(null);
        stat.setCompleted();
        if (isError) {
            stat.setException(ex);
            stat.setIsError(true);
        }
        rmd.getQueryStatList().add(stat);
    }

    public void onQuerySize(QueryStat stat) {
        if (stat.isCached()) {
            return;
        }
    }

    public void load(boolean enabledChanged) {
        if (enabledChanged) {
            if (Configuration.INSTANCE.getMonitorSettings().isMonitoringEnabled() && Configuration.INSTANCE.getMonitorSettings().isCfMemoryMonitoringEnabled()) {
                this.onMonitoringEnabled();
            } else {
                this.onMonitoringDisabled();
            }
        }
    }

    private void onMonitoringEnabled() {
        List cachedQueries = ServiceFactory.getDataSourceService().getCachedQueries();
        for (int i = 0; i < cachedQueries.size(); ++i) {
            CachedQuery cQuery = (CachedQuery)cachedQueries.get(i);
            Table table = cQuery.getResult();
            MemoryTrackerProxy.checkEnabled(table);
            QueryStat cStat = cQuery.getStats();
            if (cStat == null) {
                cStat = new QueryStat("", "", "", 0, true, "", 0L);
            }
            cStat.setSize(cQuery.getResult().getMemoryTrackerProxy().getBuiltInMemoryTracker().getEstimatedMemory());
        }
    }

    private void onMonitoringDisabled() {
        List cachedQueries = ServiceFactory.getDataSourceService().getCachedQueries();
        if (cachedQueries != null) {
            for (int i = 0; i < cachedQueries.size(); ++i) {
                CachedQuery cQuery = (CachedQuery)cachedQueries.get(i);
                MemoryTrackerProxy mtp = cQuery.getResult().getMemoryTrackerProxy();
                if (mtp == null) continue;
                mtp.disable();
            }
        }
    }

    public List getCachedQueries() {
        ArrayList<Struct> response = new ArrayList<Struct>();
        List cachedQueries = ServiceFactory.getDataSourceService().getCachedQueries();
        for (int i = 0; i < cachedQueries.size(); ++i) {
            CachedQuery cQuery = (CachedQuery)cachedQueries.get(i);
            QueryStat cStat = cQuery.getStats();
            if (cStat == null) continue;
            Struct responseMap = new Struct();
            responseMap.put("TIMEEXECUTED", (Object)cStat.getStartedAt());
            responseMap.put("size", (Object)new Long(cStat.getSize()));
            responseMap.put("TIMETAKEN", (Object)new Long(cStat.getExecutionTime()));
            responseMap.put("QUERYNAME", (Object)cStat.getName());
            responseMap.put("dsn", (Object)cStat.getDSN());
            responseMap.put("SQL", (Object)cStat.getSql());
            responseMap.put("TEMPLATEPATH", (Object)cStat.getTemplatePath());
            responseMap.put("LINENO", (Object)new Integer(cStat.getLineNo()));
            responseMap.put("hit_count", (Object)new Long(cStat.getHitCount()));
            responseMap.put("EXECUTIONCOUNT", (Object)new Long(cStat.getExecutionCount()));
            String functionName = cStat.getFunctionName();
            if (functionName == null) {
                functionName = "";
            }
            responseMap.put("FUNCTIONNAME", (Object)functionName);
            responseMap.put("URI", (Object)(cStat.getURI() == null ? "" : cStat.getURI()));
            responseMap.put("METHOD", (Object)(cStat.getMethod() == null ? "" : cStat.getMethod()));
            response.add(responseMap);
        }
        return response;
    }

    public Map getQueryCacheStats() {
        List cachedQueries = ServiceFactory.getDataSourceService().getCachedQueries();
        Struct responseMap = new Struct();
        double hitRatio = 0.0;
        int hits = 0;
        int misses = 0;
        if (cachedQueries != null) {
            int cacheCount = cachedQueries.size();
            long cacheSize = 0L;
            for (int i = 0; i < cacheCount; ++i) {
                QueryStat stat = ((CachedQuery)cachedQueries.get(i)).getStats();
                if (stat == null) continue;
                Table mto = ((CachedQuery)cachedQueries.get(i)).getResult();
                boolean isMemoryTrackingEnabled = MemoryTrackerProxy.checkEnabled(mto);
                if (!isMemoryTrackingEnabled) {
                    mto.setMemoryTrackerProxy(new MemoryTrackerProxy(mto));
                }
                long size = MemoryCalculator.calculateMemory(mto, false);
                cacheSize += size;
                hits += stat.getCacheHit();
                misses += stat.getCacheMiss();
            }
            int tries = hits + misses;
            if (tries != 0) {
                hitRatio = (double)hits / (double)tries;
            }
            responseMap.put("hit_ratio", (Object)hitRatio);
            responseMap.put("size", (Object)cacheSize);
            responseMap.put("count", (Object)cacheCount);
        }
        return responseMap;
    }
}

