/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.sql;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.sql.QueryMonitor;
import coldfusion.runtime.Struct;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class QueryStat
implements Serializable {
    private String URI;
    private String method;
    private String name;
    private String templatePath;
    private String functionName;
    private String threadId;
    private String applicationName;
    private String instanceId;
    private long endTime;
    private int lineNo;
    private String sql;
    private Throwable sqlEx;
    private boolean isError;
    private String DSN;
    private int qryHitCount;
    private boolean isCached;
    private volatile long lastExecutedAt;
    private volatile long executionCount;
    private String queryType;
    private int cacheHit = 0;
    private int cacheMiss = 0;
    long startTime;
    long executionTime = -1L;
    boolean isCompleted = false;
    long size;
    String threadName;
    private AtomicLong hitCount = new AtomicLong();
    private static QueryMonitor qm;
    boolean isStoredProc = false;
    private Logger logger = CFLogs.SERVER_LOG;

    public QueryStat(String name, String templatePath, String functionName, int lineNo, boolean isCached, String DSN, boolean stored) {
        this.name = name;
        this.templatePath = templatePath;
        this.functionName = functionName;
        this.lineNo = lineNo;
        this.isCached = isCached;
        this.DSN = DSN;
        this.startTime = System.currentTimeMillis();
        this.qryHitCount = 1;
    }

    public QueryStat(String name, String templatePath, String functionName, int lineNo, boolean isCached, String DSN, long execCount) {
        this(name, templatePath, functionName, lineNo, isCached, DSN, false);
        this.executionCount = execCount;
        this.qryHitCount = 1;
        this.startTime = System.currentTimeMillis();
    }

    public QueryStat(String name, String templatePath, String functionName, int lineNo, boolean isCached, String DSN, long execCount, String URI2, String method) {
        this(name, templatePath, functionName, lineNo, isCached, DSN, false);
        this.executionCount = execCount;
        this.URI = URI2;
        this.method = method;
    }

    public QueryStat(String name, String templatePath, String functionName, int lineNo, boolean isCached, String DSN, boolean stored, String URI2, String method) {
        this(name, templatePath, functionName, lineNo, isCached, DSN, stored);
        this.URI = URI2;
        this.method = method;
    }

    public String getURI() {
        return this.URI;
    }

    public String getMethod() {
        return this.method;
    }

    public long getHitCount() {
        return this.hitCount.get();
    }

    public void updateHitCount() {
        this.hitCount.incrementAndGet();
    }

    public void setStarted() {
        this.startTime = System.currentTimeMillis();
        this.threadName = Thread.currentThread().getName();
    }

    public Date getStartedAt() {
        return new Date(this.startTime);
    }

    public long getStartedAtMillis() {
        return this.startTime;
    }

    public void setCompleted() {
        this.endTime = System.currentTimeMillis();
        this.executionTime = this.endTime - this.startTime;
        this.isCompleted = true;
        this.threadName = null;
    }

    public void setExecutionTime(long execTime) {
        this.executionTime = execTime;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public long getExecutionTime() {
        long time = 0L;
        time = this.executionTime == -1L ? System.currentTimeMillis() - this.startTime : this.executionTime;
        return time;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
        qm.onQuerySize(this);
    }

    public int getCacheHit() {
        return this.cacheHit;
    }

    public void setCacheHit(int cacheHit) {
        this.cacheHit = cacheHit;
    }

    public int getCacheMiss() {
        return this.cacheMiss;
    }

    public void setCacheMiss(int cacheMiss) {
        this.cacheMiss = cacheMiss;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setQueryType(String sql) {
        sql = sql.trim();
        String action = "";
        if (!sql.isEmpty()) {
            action = sql.split("\\s+")[0].toUpperCase();
        }
        if (action.equals("SELECT")) {
            this.queryType = "SELECT";
        } else if (action.equals("UPDATE")) {
            this.queryType = "UPDATE";
        } else if (action.equals("INSERT")) {
            this.queryType = "INSERT";
        } else if (action.equals("DELETE")) {
            this.queryType = "DELETE";
        }
    }

    public String getDSN() {
        return this.DSN;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public boolean isCached() {
        return this.isCached;
    }

    public Date getLastTimeExecuted() {
        return new Date(this.lastExecutedAt);
    }

    public void setLastTimeExecuted(long millis) {
        this.lastExecutedAt = millis;
        ++this.executionCount;
    }

    public long getExecutionCount() {
        return this.executionCount;
    }

    public void resetExecutionCount() {
        this.executionCount = 0L;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public String getName() {
        return this.name;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public boolean getIsError() {
        return this.isError;
    }

    public void setIsError(boolean isError) {
        this.isError = isError;
    }

    public void setException(Throwable ex) {
        this.sqlEx = ex;
    }

    public int getQryHitCount() {
        return this.qryHitCount;
    }

    public void setQryHitCount(int qryHitCount) {
        this.qryHitCount = qryHitCount;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public Map toMap() {
        Struct responseMap = new Struct();
        responseMap.put("template_path", (Object)this.templatePath);
        responseMap.put("line_no", (Object)new Integer(this.lineNo));
        responseMap.put("is_cached", (Object)new Boolean(this.isCached));
        responseMap.put("is_storedproc", (Object)this.isStoredProc);
        responseMap.put("data_source_name", (Object)this.DSN);
        responseMap.put("time_taken", (Object)this.executionTime);
        responseMap.put("query_type", (Object)this.queryType);
        responseMap.put("start_time", (Object)this.startTime);
        responseMap.put("end_time", (Object)this.endTime);
        responseMap.put("thread_id", (Object)this.threadId);
        responseMap.put("application_name", (Object)this.applicationName);
        responseMap.put("instance_id", (Object)this.instanceId);
        responseMap.put("qry_hit_count", (Object)this.qryHitCount);
        if (this.sqlEx != null) {
            responseMap.put("is_error", (Object)this.isError);
            responseMap.put("exception", (Object)ExceptionUtils.getStackTrace((Throwable)this.sqlEx));
        } else {
            responseMap.put("is_error", (Object)false);
        }
        if (this.isCached) {
            responseMap.put("hitCount", (Object)this.getHitCount());
        }
        if (this.name != null) {
            responseMap.put("query_name", (Object)this.name);
        } else {
            responseMap.put("query_name", (Object)"");
        }
        if (this.URI != null) {
            responseMap.put("uri", (Object)this.URI);
        } else {
            responseMap.put("uri", (Object)"");
        }
        if (this.method != null) {
            responseMap.put("method", (Object)this.method);
        } else {
            responseMap.put("method", (Object)"");
        }
        if (this.sql != null) {
            if (this.sql.length() * 2 > 32000) {
                this.logger.info("sql exceeding allowed limit is  " + this.sql + " URL " + this.URI);
                this.sql = this.sql.substring(0, 200);
            }
            responseMap.put("sql", (Object)this.sql.trim());
        }
        if (this.functionName == null) {
            responseMap.put("function", (Object)"");
        } else {
            responseMap.put("function", (Object)this.functionName);
        }
        if (this.threadName != null) {
            responseMap.put("threadName", (Object)this.threadName);
        }
        return responseMap;
    }

    public boolean isStoredProc() {
        return this.isStoredProc;
    }

    public void setStoredProc(boolean isStoredProc) {
        this.isStoredProc = isStoredProc;
    }

    public static void setQueryMonitor(QueryMonitor qMonitor) {
        qm = qMonitor;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public void setThreadId(String threadId) {
        this.threadId = threadId;
    }
}

