/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.timing;

import coldfusion.monitor.Configuration;
import coldfusion.monitor.event.AbstractRequestMonitorEventHandler;
import coldfusion.monitor.event.FunctionEvent;
import coldfusion.monitor.event.RequestEvent;
import coldfusion.monitor.event.TagEvent;
import coldfusion.monitor.event.ThreadEvent;
import coldfusion.monitor.stack.CFStack;
import coldfusion.monitor.stack.CFStackFrame;
import coldfusion.monitor.util.MonitorConstants;
import coldfusion.monitor.util.RequestMonitorData;

public class TimingRequestEventHandler
extends AbstractRequestMonitorEventHandler {
    @Override
    public void onRequestStart(RequestEvent e) {
        this.setStartData(e);
    }

    @Override
    public void onRequestEnd(RequestEvent e) {
        this.setEndData(e);
    }

    public void onThreadStart(ThreadEvent e) {
        RequestMonitorData r = e.getRequestMonitorData();
        r.setRequestStartTime(System.currentTimeMillis());
    }

    public void onThreadEnd(ThreadEvent e) {
        this.setEndData(e);
    }

    @Override
    public void onFunctionEnd(FunctionEvent e) {
        RequestMonitorData r = e.getRequestMonitorData();
        CFStack cfStack = r.getCFStack();
        if (cfStack != null && !cfStack.isEmpty()) {
            int lineNo;
            CFStackFrame currentStackFrame = cfStack.peekStackFrame();
            if (!r.doProfile(currentStackFrame.getTemplatePath())) {
                return;
            }
            long startTime = currentStackFrame.getInsertedAt();
            long endTime = System.currentTimeMillis();
            currentStackFrame.setTimeTaken(endTime - startTime);
            CFStackFrame parentStackFrame = currentStackFrame.getNextFrame();
            int n = lineNo = parentStackFrame == null ? 0 : parentStackFrame.getLineNo();
            while (currentStackFrame.getNextFrame() != null) {
                currentStackFrame = currentStackFrame.getNextFrame();
                currentStackFrame.setTimeTaken(endTime - currentStackFrame.getInsertedAt());
            }
            CFStack stackTrace = cfStack.copy();
            r.addPageElement(e, startTime, endTime, lineNo, stackTrace);
        }
    }

    @Override
    public void onTagEnd(TagEvent e) {
        RequestMonitorData r;
        CFStack cfStack;
        if ((Configuration.INSTANCE.isCodeProfilerOn() || Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isTagMetrics() || this.isExternalService(e)) && e.getTagName() != null && (cfStack = (r = e.getRequestMonitorData()).getCFStack()) != null && !cfStack.isEmpty()) {
            CFStackFrame currentStackFrame = cfStack.peekStackFrame();
            if (!r.doProfile(currentStackFrame.getTemplatePath())) {
                return;
            }
            long startTime = currentStackFrame.getInsertedAt();
            long endTime = System.currentTimeMillis();
            currentStackFrame.setTimeTaken(endTime - startTime);
            if (currentStackFrame.getNextFrame() == null) {
                CFStack stackTrace = cfStack.copy();
                r.addPageElement(e, startTime, endTime, 0, stackTrace);
                return;
            }
            int lineNo = currentStackFrame.getNextFrame().getLineNo();
            while (currentStackFrame.getNextFrame() != null) {
                currentStackFrame = currentStackFrame.getNextFrame();
                currentStackFrame.setTimeTaken(endTime - currentStackFrame.getInsertedAt());
            }
            CFStack stackTrace = cfStack.copy();
            r.addPageElement(e, startTime, endTime, lineNo, stackTrace);
        }
    }

    private boolean isExternalService(TagEvent e) {
        return e.getTagName() != null && MonitorConstants.TAGS_WITH_ATTRIBUTES.contains(e.getTagName());
    }

    private void setStartData(RequestEvent e) {
        RequestMonitorData r = e.getRequestMonitorData();
        r.setRequestStartTime(System.currentTimeMillis());
    }

    private void setEndData(RequestEvent e) {
        RequestMonitorData r = e.getRequestMonitorData();
        r.setRequestEndTime(System.currentTimeMillis());
    }
}

