/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.util;

import coldfusion.monitor.util.AvgStat;

public class AvgStatCalculator {
    private volatile long count;
    private volatile double avg;
    private volatile double max;
    private volatile double min;
    private double lastData;

    public synchronized void updateData(double data) {
        double d = this.max = data > this.max ? data : this.max;
        this.min = this.count == 0L ? data : (data < this.min ? data : this.min);
        this.avg = (this.avg * (double)this.count + data) / (double)(++this.count);
        this.lastData = data;
    }

    public AvgStat getAvgStat() {
        return new AvgStat(this.avg, this.max, this.min);
    }

    public double getAvg() {
        return this.avg;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public double getLastData() {
        return this.trimDouble(this.lastData);
    }

    public double getCumulative() {
        return this.trimDouble(this.avg * (double)this.count);
    }

    public double getCumulativeRaw() {
        return this.avg * (double)this.count;
    }

    public long getCount() {
        return this.count;
    }

    public void reset() {
        this.avg = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        this.count = 0L;
        this.lastData = 0.0;
    }

    private double trimDouble(double d) {
        return (double)((int)(d * 1000.0)) / 1000.0;
    }
}

