/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.util;

import coldfusion.cloud.CloudServiceName;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.monitor.util.RequestMonitorData;

public final class CloudMonitoringUtil {
    private CloudMonitoringUtil() {
    }

    public static void onCloudFunctionEnd(String name, String action, Object statusCode, TagAttributeList baseTagAttributeList) {
        CloudMonitoringUtil.onCloudFunctionEnd(name, action, statusCode, null, false, baseTagAttributeList);
    }

    public static void onCloudFunctionEnd(String name, TagAttributeList baseTagAttributeList) {
        CloudMonitoringUtil.onCloudFunctionEnd(name, null, null, null, false, baseTagAttributeList);
    }

    public static void onCloudFunctionEnd(String name, String action, Object statusCode, String resourceName, TagAttributeList baseTagAttributeList) {
        CloudMonitoringUtil.onCloudFunctionEnd(name, action, statusCode, resourceName, false, baseTagAttributeList);
    }

    public static void onCloudFunctionEnd(String name, String action, Object statusCode, String view, String source, TagAttributeList baseTagAttributeList) {
        String service = (String)baseTagAttributeList.getTagAttributes().get(0).getAttributeValue();
        if (!"MONGO_DB".equalsIgnoreCase(service)) {
            CloudMonitoringUtil.onCloudFunctionEnd(name, action, statusCode, null, false, source, baseTagAttributeList);
            return;
        }
        RequestMonitorData rmd = RequestMonitorData.getCurrent();
        if (rmd != null && rmd.doMonitor()) {
            RequestMonitorEventProcessor.onFunctionEnd(name, null, CloudMonitoringUtil.getTagAttributes(baseTagAttributeList, action, statusCode, null, false, null).addTagAttribute("view", view).addTagAttribute("source", source).getTagAttributes(), true);
        }
    }

    public static void onCloudFunctionEnd(String name, String action, Object statusCode, String resourceName, boolean isTopic, TagAttributeList baseTagAttributeList) {
        RequestMonitorData rmd = RequestMonitorData.getCurrent();
        if (rmd != null && rmd.doMonitor()) {
            RequestMonitorEventProcessor.onFunctionEnd(name, null, CloudMonitoringUtil.getTagAttributes(baseTagAttributeList, action, statusCode, resourceName, isTopic, null).getTagAttributes(), true);
        }
    }

    public static void onCloudFunctionEnd(String name, String action, Object statusCode, String resourceName, boolean isTopic, String object, TagAttributeList baseTagAttributeList) {
        RequestMonitorData rmd = RequestMonitorData.getCurrent();
        if (rmd != null && rmd.doMonitor()) {
            RequestMonitorEventProcessor.onFunctionEnd(name, null, CloudMonitoringUtil.getTagAttributes(baseTagAttributeList, action, statusCode, resourceName, isTopic, object).getTagAttributes(), true);
        }
    }

    private static TagAttributeList getTagAttributes(TagAttributeList baseTagAttributeList, String action, Object statusCode, String resourceName, boolean isTopic, String subResource) {
        TagAttributeList tagAttributeList = TagAttributeList.getInstance(baseTagAttributeList);
        if (statusCode != null) {
            tagAttributeList.addTagAttribute("status_code", statusCode);
        }
        if (action != null) {
            tagAttributeList.addTagAttribute("action", action);
        }
        CloudServiceName svc = null;
        if (resourceName != null && !resourceName.isEmpty()) {
            String service = (String)baseTagAttributeList.getTagAttributes().get(0).getAttributeValue();
            if ("MONGO_DB".equalsIgnoreCase(service)) {
                return tagAttributeList.addTagAttribute("command", resourceName);
            }
            svc = CloudServiceName.fromName(service);
            switch (svc) {
                case SQS: {
                    tagAttributeList.addTagAttribute("queue", resourceName);
                    break;
                }
                case SNS: {
                    if (isTopic) {
                        tagAttributeList.addTagAttribute("topic", resourceName.substring(resourceName.lastIndexOf(":") + 1));
                        break;
                    }
                    tagAttributeList.addTagAttribute("subscription", resourceName.substring(resourceName.lastIndexOf(":") + 1));
                    break;
                }
                case S3: {
                    tagAttributeList.addTagAttribute("bucket", resourceName);
                    break;
                }
                case AZURE_BLOB: {
                    tagAttributeList.addTagAttribute("container", resourceName);
                    break;
                }
            }
        }
        if (subResource != null) {
            if (svc == CloudServiceName.SNS) {
                tagAttributeList.addTagAttribute("subscription", subResource.substring(subResource.lastIndexOf(":") + 1));
            } else {
                tagAttributeList.addTagAttribute("object", subResource);
            }
        }
        return tagAttributeList;
    }
}

