/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.util;

import coldfusion.monitor.beans.StackTraceNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class CodeMergeUtil {
    private static CodeMergeUtil instance;

    public static CodeMergeUtil getInstance() {
        if (instance == null) {
            instance = new CodeMergeUtil();
        }
        return instance;
    }

    public StackTraceNode mergeStackTrace(List<String> list) {
        String[] stes = list.toArray(new String[list.size()]);
        StackTraceNode root = new StackTraceNode("root");
        this.mergeStackTrace(stes, root);
        return root;
    }

    public void mergeStackTrace(String[] stes, StackTraceNode coldfusionCallStackInPage) {
        for (int i = 0; i < stes.length; ++i) {
            String line = stes[i];
            if (line.equals("\n")) continue;
            Stack<String> tempCallStack = new Stack<String>();
            do {
                tempCallStack.push(line);
            } while (!"\n".equals(line = stes[++i]) && i != stes.length);
            this.pushTempCallStackIntoCallTree(coldfusionCallStackInPage, tempCallStack, 0);
        }
        this.calculateTimeTaken(coldfusionCallStackInPage);
    }

    private void pushTempCallStackIntoCallTree(StackTraceNode rootNode, Stack<String> tempCallStack, int currentDepth) {
        if (currentDepth == 500) {
            return;
        }
        while (!tempCallStack.isEmpty()) {
            String element = tempCallStack.peek();
            String[] tokenizedCallString = element.split(": ");
            int lineNum = -1;
            long timeTaken = 0L;
            if (tokenizedCallString.length > 1) {
                timeTaken = Integer.parseInt(tokenizedCallString[2].trim());
                lineNum = Integer.parseInt(tokenizedCallString[1].trim());
            }
            if ((element = tokenizedCallString[0]).startsWith("at ")) {
                element = element.substring(3);
            }
            String stackElement = element.trim();
            boolean isElementPresent = false;
            StackTraceNode child = null;
            if (rootNode.getChildren() != null) {
                for (StackTraceNode s : rootNode.getChildren()) {
                    if (!stackElement.equals(s.getId().trim())) continue;
                    if (lineNum == s.getLineNumber()) {
                        isElementPresent = true;
                        child = s;
                        break;
                    }
                    if (tempCallStack.size() != 1 || lineNum != 0) continue;
                    tempCallStack.pop();
                    return;
                }
            }
            if (rootNode.getChildren() == null || !isElementPresent) {
                StackTraceNode newNode = new StackTraceNode(element, currentDepth);
                newNode.setLineNumber(lineNum);
                newNode.setTimeTaken(timeTaken);
                newNode.setChildren(new ArrayList<StackTraceNode>());
                List<StackTraceNode> rootNodeChildren = rootNode.getChildren();
                if (rootNodeChildren == null) {
                    rootNodeChildren = new ArrayList<StackTraceNode>();
                }
                rootNodeChildren.add(newNode);
                rootNode.setChildren(rootNodeChildren);
                tempCallStack.pop();
                if (tempCallStack.isEmpty()) continue;
                this.pushTempCallStackIntoCallTree(newNode, tempCallStack, currentDepth + 1);
                continue;
            }
            for (StackTraceNode s : rootNode.getChildren()) {
                if (!stackElement.equals(s.getId().trim()) || lineNum != s.getLineNumber()) continue;
                child = s;
                child.setTimeTaken(Math.max(child.getTimeTaken(), timeTaken));
                break;
            }
            if (child.getLineNumber() == -1 && lineNum != -1) {
                child.setLineNumber(lineNum);
            }
            tempCallStack.pop();
            this.pushTempCallStackIntoCallTree(child, tempCallStack, currentDepth + 1);
        }
    }

    private void calculateTimeTaken(StackTraceNode root) {
        if (root == null) {
            return;
        }
        long timeTaken = 0L;
        String tempId = null;
        if (root.getChildren() == null) {
            return;
        }
        if (root.getChildren().size() > 1) {
            tempId = root.getChildren().get(0).getId();
            for (StackTraceNode node : root.getChildren()) {
                if (tempId != null && !tempId.equals(node.getId())) {
                    tempId = node.getId();
                    timeTaken = 0L;
                }
                long ownTime = node.getTimeTaken() - timeTaken;
                timeTaken = node.getTimeTaken();
                node.setTimeTaken(ownTime);
            }
        }
        long slowestChildTime = 0L;
        for (StackTraceNode node : root.getChildren()) {
            this.calculateTimeTaken(node);
            slowestChildTime = Math.max(slowestChildTime, node.getTimeTaken());
        }
        if (root.getTimeTaken() < 0L) {
            root.setTimeTaken(slowestChildTime);
        }
        root.setId(root.getId() + ":" + root.getLineNumber() + ":" + root.getTimeTaken());
    }
}

