/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.util;

import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Base64;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PasswordUtils {
    private static String cfRootDirectory;
    private static String seedFilePath;
    private static final String AES_CBC_PKCS5_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final String BASEENCODING = "Base64";
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final char PADCHAR = '#';
    private static final Logger LOG;

    public static String getCFRootDir() {
        if (cfRootDirectory == null) {
            RuntimeService runtimeService = ServiceFactory.getRuntimeService();
            cfRootDirectory = runtimeService.getRootDir();
        }
        return cfRootDirectory;
    }

    public static String getSeedFilePath() {
        return PasswordUtils.getCFRootDir() + File.separator + "lib" + File.separator + "seed.properties";
    }

    public static String decryptPassword(String password) {
        if (password == null || password.length() == 0) {
            return password;
        }
        String seed = PasswordUtils.getValueFromPropertiesFile();
        String secKey = PasswordUtils.generateAesKey(seed);
        return PasswordUtils.decrypt(password, DEFAULT_CHARSET, secKey, AES_CBC_PKCS5_ALGORITHM, BASEENCODING, null, 0);
    }

    public static String decrypt(String string, String charset, String key, String algorithm, String encoding, byte[] prefix, int iter) {
        byte[] bytes = null;
        bytes = Base64.getDecoder().decode(string);
        byte[] enc = PasswordUtils.decrypt(bytes, key, algorithm, prefix, iter);
        return new String(enc, StandardCharsets.UTF_8);
    }

    static byte[] decrypt(byte[] bytes, String key, String algorithm, byte[] prefix, int iter) {
        byte[] enc = null;
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            byte[] keyBytes = key.getBytes();
            SecretKeySpec secretKey = new SecretKeySpec(keyBytes, "AES");
            cipher.init(2, (Key)secretKey, new IvParameterSpec(new byte[16]));
            enc = cipher.doFinal(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)e);
            PasswordUtils.registerSunCryptoProvider();
        }
        catch (NoSuchPaddingException e) {
            LOG.error((Object)e);
        }
        catch (InvalidKeyException e) {
            LOG.error((Object)e);
        }
        catch (IllegalBlockSizeException e) {
            LOG.error((Object)e);
        }
        catch (BadPaddingException e) {
            LOG.error((Object)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            LOG.error((Object)e);
        }
        return enc;
    }

    private static void registerSunCryptoProvider() {
        try {
            Provider sunjce = null;
            try {
                Class<?> clazz = Class.forName("com.sun.crypto.provider.SunJCE");
                if (clazz != null) {
                    sunjce = (Provider)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Security.addProvider(sunjce);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String generateAesKey(String seed) {
        if (seed == null || seed != null && seed.length() == 0) {
            return null;
        }
        byte[] seedBytes = null;
        try {
            seedBytes = seed.getBytes(DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            seedBytes = seed.getBytes();
        }
        int seedLen = seedBytes.length;
        seedBytes = Arrays.copyOf(seedBytes, 16);
        if (seedLen < 16) {
            for (int i = seedLen; i < 16; ++i) {
                seedBytes[i] = 35;
            }
        }
        SecretKeySpec secretKey = new SecretKeySpec(seedBytes, "AES");
        return new String(secretKey.getEncoded(), StandardCharsets.UTF_8);
    }

    private static String getValueFromPropertiesFile() {
        Properties prop = new Properties();
        FileInputStream input = null;
        String seed = null;
        try {
            input = new FileInputStream(PasswordUtils.getSeedFilePath());
            prop.load(input);
            seed = prop.getProperty("seed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return seed;
    }

    public static String encryptPassword(String password) {
        if (password == null || password.length() == 0) {
            return password;
        }
        String seed = PasswordUtils.getValueFromPropertiesFile();
        String secKey = PasswordUtils.generateAesKey(seed);
        return PasswordUtils.encrypt(password, DEFAULT_CHARSET, secKey, AES_CBC_PKCS5_ALGORITHM, BASEENCODING, null, 0);
    }

    public static String encrypt(String string, String charset, String key, String algorithm, String encoding, byte[] prefix, int iter) {
        byte[] bytes = null;
        try {
            bytes = string.getBytes(charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byte[] enc = PasswordUtils.encrypt(bytes, key, algorithm, prefix, iter);
        return new String(enc, StandardCharsets.UTF_8);
    }

    static byte[] encrypt(byte[] bytes, String key, String algorithm, byte[] prefix, int iter) {
        byte[] enc = null;
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            byte[] keyBytes = key.getBytes();
            SecretKeySpec secretKey = new SecretKeySpec(keyBytes, "AES");
            cipher.init(1, (Key)secretKey, new IvParameterSpec(new byte[16]));
            enc = cipher.doFinal(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            PasswordUtils.registerSunCryptoProvider();
        }
        catch (NoSuchPaddingException e) {
            LOG.error((Object)e);
        }
        catch (InvalidKeyException e) {
            LOG.error((Object)e);
        }
        catch (IllegalBlockSizeException e) {
            LOG.error((Object)e);
        }
        catch (BadPaddingException e) {
            LOG.error((Object)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            LOG.error((Object)e);
        }
        return Base64.getEncoder().encode(enc);
    }

    static {
        LOG = LogManager.getLogger(PasswordUtils.class);
    }
}

