/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.util;

import coldfusion.monitor.Configuration;
import coldfusion.monitor.event.FunctionEvent;
import coldfusion.monitor.event.TagEvent;
import coldfusion.monitor.memory.MemoryTracker;
import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.monitor.memory.VariableStat;
import coldfusion.monitor.sql.QueryStat;
import coldfusion.monitor.stack.CFStack;
import coldfusion.monitor.stack.CFStackFrame;
import coldfusion.monitor.util.CFThreadMonitorData;
import coldfusion.monitor.util.PageElementStat;
import coldfusion.monitor.util.PageElementUtil;
import coldfusion.monitor.util.ThreadDictionary;
import coldfusion.monitor.util.ThreadMonitorData;
import coldfusion.runtime.RequestScope;
import coldfusion.runtime.Scope;
import coldfusion.server.InMemoryMonitoringService;
import coldfusion.server.ServiceFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RequestMonitorData {
    protected static ThreadLocal<RequestMonitorData> current = new ThreadLocal();
    private static int TAGS_FUNCTIONS_COLLECTION_LIMIT = 400;
    private static int MAX_NUMBER_OF_TAGS_FUNCTIONS = 20;
    private static String MAX_TAGS_FUNCTIONS_LIMIT = "max_tags_functions_limit";
    private Map<String, Integer> heavyUsageTags = new HashMap<String, Integer>();
    private Map<String, Integer> heavyUsageFunctions = new HashMap<String, Integer>();
    private boolean tagFunctionLimitExceeded = false;
    private boolean profileMemory;
    private boolean profileUrl;
    private String responseContentType;
    private String profilingId;
    private String threadId;
    private String clientIp;
    private String clientHost;
    private String httpMethod;
    private String uri;
    private String url;
    private String queryParameters;
    private String templatePath;
    private String requestFunctionName;
    private long requestStartTime;
    private long requestEndTime;
    private List<PageElementStat> pageElementList;
    private Map<String, String> reqMap;
    private Map<String, String> respMap;
    private List<QueryStat> queryStatList;
    private List<Map> threadDataList;
    private boolean isError;
    private String errorMessage;
    private boolean isTimeOut;
    private Throwable throwable;
    private String reqType;
    private int responseCode;
    private QueryStat activeQueryStat;
    private boolean doMonitor = false;
    private Map variables;
    private RequestScope requestScope;
    private MemoryTrackerProxy requestScopeMTProxy;
    private CFStack cfStack;
    private Set threadMonitors;
    private String[][] aliasParameters;
    private String aliasName;
    private String applicationName;
    private boolean rest;
    private String restUri;
    private HashMap hiddenScope = new HashMap();
    private String qeReqId = null;
    private boolean hasExternalServices;
    private Map reqParamMap;
    private String requestId;
    private boolean isRmdReadyToPersist = false;

    public boolean isRmdReadyToPersist() {
        return this.isRmdReadyToPersist;
    }

    public void setRmdReadyToPersist(boolean rmdReadyToPersist) {
        this.isRmdReadyToPersist = rmdReadyToPersist;
    }

    public Map getReqParamMap() {
        return this.reqParamMap;
    }

    public void setReqParamMap(Map reqParamMap) {
        this.reqParamMap = reqParamMap;
    }

    public boolean isTagFunctionLimitExceeded() {
        return this.tagFunctionLimitExceeded;
    }

    public String getQeReqId() {
        return this.qeReqId;
    }

    public void setQeReqId(String qeReqId) {
        this.qeReqId = qeReqId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public void setResponseContentType(String responseContentType) {
        this.responseContentType = responseContentType;
    }

    public String getProfilingId() {
        return this.profilingId;
    }

    public void setProfilingId(String profilingId) {
        this.profilingId = profilingId;
    }

    public boolean isProfileMemory() {
        return this.profileMemory;
    }

    public void setProfileMemory(boolean profileMemory) {
        this.profileMemory = profileMemory;
        if (profileMemory) {
            this.variables = new HashMap();
        }
    }

    public void setRest(boolean rest) {
        this.rest = rest;
    }

    public void setRestUri(String restUri) {
        this.restUri = restUri;
    }

    public boolean getRest() {
        return this.rest;
    }

    public String getRestUri() {
        return this.restUri;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String appName) {
        if (appName == null || appName != null && appName.isEmpty()) {
            appName = "Unnamed-Application";
        }
        this.applicationName = appName;
    }

    public boolean shouldProfile() {
        return this.profileUrl;
    }

    public void setProfileUrl(boolean profile) {
        this.profileUrl = profile;
    }

    protected RequestMonitorData() {
        if (Configuration.INSTANCE.isCodeProfilerOn() || Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isTagMetrics()) {
            String maxLimit = System.getProperty(MAX_TAGS_FUNCTIONS_LIMIT);
            if (maxLimit != null) {
                MAX_NUMBER_OF_TAGS_FUNCTIONS = Integer.parseInt(maxLimit);
            }
            this.pageElementList = new ArrayList<PageElementStat>();
            this.cfStack = new CFStack();
        }
        this.queryStatList = new ArrayList<QueryStat>();
    }

    public String getThreadId() {
        return this.threadId;
    }

    public void setThreadId(String threadId) {
        this.threadId = threadId;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public void setClientHost(String clientHost) {
        this.clientHost = clientHost;
    }

    public List<QueryStat> getQueryStatList() {
        return this.queryStatList;
    }

    public Map<String, String> getReqMap() {
        return this.reqMap;
    }

    public void setReqMap(Map<String, String> reqMap) {
        this.reqMap = reqMap;
    }

    public Map<String, String> getRespMap() {
        return this.respMap;
    }

    public void setRespMap(Map<String, String> respMap) {
        this.respMap = respMap;
    }

    public Map getHiddenScope() {
        return this.hiddenScope;
    }

    public boolean isTimeOut() {
        return this.isTimeOut;
    }

    public void setTimeOut(boolean isTimeOut) {
        this.isTimeOut = isTimeOut;
    }

    public List<Map> getThreadDataList() {
        return this.threadDataList;
    }

    public void setHiddenScope(Scope hiddenScope) {
        for (String scpType : hiddenScope.keySet()) {
            if (scpType == null || !"URL".equals(scpType) && !"FORM".equals(scpType) && !"SESSION".equals(scpType)) continue;
            HashMap map = new HashMap();
            map.putAll((Map)hiddenScope.get(scpType));
            this.hiddenScope.put(scpType, map);
        }
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public void removeHiddenScope() {
        this.hiddenScope = null;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }

    public String getHttpMethod() {
        if (this.httpMethod != null) {
            this.httpMethod = this.httpMethod.toUpperCase();
        }
        return this.httpMethod;
    }

    public void setHttpMethod(String method) {
        this.httpMethod = method;
    }

    public String[][] getAliasParameters() {
        return this.aliasParameters;
    }

    public void setAliasParameters(String[][] aliasParameters) {
        this.aliasParameters = aliasParameters;
    }

    public boolean doProfile(String template) {
        boolean accept = false;
        int ixIn = RequestMonitorData.isIn(Configuration.INSTANCE.getMonitorSettings().getIncludeList(), template);
        if (ixIn == 2) {
            accept = true;
        }
        return true;
    }

    private static int isIn(List<String> strs, String pt) {
        int r = 0;
        if (strs == null) {
            return 0;
        }
        for (int i = 0; i < strs.size(); ++i) {
            if (pt.equalsIgnoreCase(strs.get(i))) {
                r = 2;
                break;
            }
            if (!pt.startsWith(strs.get(i)) || strs.get(i).length() <= 0) continue;
            r = 1;
        }
        return r;
    }

    public boolean doMonitor() {
        return this.doMonitor;
    }

    public void setDoMonitor(boolean doMonitor) {
        this.doMonitor = doMonitor;
    }

    public boolean isError() {
        return this.isError;
    }

    public void setError(boolean error) {
        this.isError = error;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable thrwable) {
        this.throwable = thrwable;
    }

    public CFStack getCFStack() {
        return this.cfStack;
    }

    public List<PageElementStat> getPageElementList() {
        return this.pageElementList;
    }

    public void addPageElementList(List<PageElementStat> list) {
        if (this.pageElementList == null) {
            this.pageElementList = new ArrayList<PageElementStat>();
        }
        if (list != null) {
            this.pageElementList.addAll(list);
        }
    }

    public long getRequestStartTime() {
        return this.requestStartTime;
    }

    public void setRequestStartTime(long requestStartTime) {
        this.requestStartTime = requestStartTime;
    }

    public long getRequestEndTime() {
        return this.requestEndTime;
    }

    public void setRequestEndTime(long requestEndTime) {
        this.requestEndTime = requestEndTime;
    }

    public void setRequestScope(RequestScope scope) {
        this.requestScope = scope;
    }

    public RequestScope getRequestScope() {
        return this.requestScope;
    }

    public MemoryTrackerProxy getRequestMTProxy() {
        if (this.requestScopeMTProxy == null && this.requestScope != null) {
            this.requestScopeMTProxy = this.requestScope.getMemoryTrackerProxy();
        }
        return this.requestScopeMTProxy;
    }

    public void addPageElement(FunctionEvent e, long startTime, long endTime, int lineNo, CFStack stackTrace) {
        if (this.pageElementList != null && this.pageElementList.size() <= TAGS_FUNCTIONS_COLLECTION_LIMIT) {
            this.pageElementList.add(PageElementUtil.translateToFunctionStat(e, startTime, endTime, lineNo, stackTrace));
        } else if (this.pageElementList != null) {
            String functionName = e.getFunctionName();
            Integer usage = this.heavyUsageFunctions.get(functionName);
            if (usage == null) {
                this.heavyUsageFunctions.put(functionName, new Integer(1));
            } else {
                if (usage > MAX_NUMBER_OF_TAGS_FUNCTIONS) {
                    this.tagFunctionLimitExceeded = true;
                    this.setProfileMemory(false);
                    MemoryTrackerProxy.setEnabled(false);
                    return;
                }
                this.heavyUsageFunctions.put(functionName, usage + 1);
            }
            this.pageElementList.add(PageElementUtil.translateToFunctionStat(e, startTime, endTime, lineNo, stackTrace));
        }
    }

    public void addPageElement(TagEvent e, long startTime, long endTime, int lineNo, CFStack stackTrace) {
        if (this.pageElementList != null && this.pageElementList.size() <= TAGS_FUNCTIONS_COLLECTION_LIMIT) {
            this.pageElementList.add(PageElementUtil.translateToTagStat(e, startTime, endTime, lineNo, stackTrace));
        } else if (this.pageElementList != null) {
            String tagName = e.getTagName();
            Integer usage = this.heavyUsageTags.get(tagName);
            if (usage == null) {
                this.heavyUsageTags.put(tagName, new Integer(1));
            } else {
                if (usage > MAX_NUMBER_OF_TAGS_FUNCTIONS) {
                    this.tagFunctionLimitExceeded = true;
                    return;
                }
                this.heavyUsageTags.put(tagName, usage + 1);
            }
            this.pageElementList.add(PageElementUtil.translateToTagStat(e, startTime, endTime, lineNo, stackTrace));
        }
    }

    public void setActiveQueryStat(QueryStat stat) {
        this.activeQueryStat = stat;
    }

    public QueryStat getActiveQueryStat() {
        return this.activeQueryStat;
    }

    public Iterator getVariableStatsIterator() {
        if (this.variables != null) {
            return this.variables.values().iterator();
        }
        return null;
    }

    public void updateVariableStat(String variableName, int scopeType, MemoryTracker mt, long size, String type, boolean removeOld) {
        if (this.shouldProfile() && this.isProfileMemory()) {
            if (this.variables == null || type.equals("JAVA") || this.cfStack == null || this.cfStack.isEmpty()) {
                return;
            }
            CFStackFrame currentStackFrame = this.cfStack.peekStackFrame();
            String templatePath = currentStackFrame.getTemplatePath();
            String functionName = null;
            if (!currentStackFrame.isTag()) {
                functionName = currentStackFrame.getElementName();
            }
            String key = VariableStat.makeKey(templatePath, functionName, variableName, scopeType);
            VariableStat stat = (VariableStat)this.variables.get(key);
            if (removeOld && mt == null) {
                Object removed = this.variables.remove(key);
                if (removed == null) {
                    CFStackFrame cfStackFrame = this.cfStack.peekFunctionStackFrame();
                    if (cfStackFrame == null) {
                        return;
                    }
                    functionName = cfStackFrame.getElementName();
                    key = VariableStat.makeKey(templatePath, functionName, variableName, scopeType);
                    this.variables.remove(key);
                }
                return;
            }
            if (stat == null) {
                stat = new VariableStat(variableName, scopeType, templatePath, functionName);
                this.variables.put(key, stat);
            }
            stat.setType(type);
            if (type.equals("SIMPLE")) {
                stat.setSize(size);
            } else {
                stat.setMemoryTracker(mt);
            }
        }
    }

    public void removeVariableStat(String variableName, int scopeType) {
        if (this.variables == null || this.cfStack == null || this.cfStack.isEmpty()) {
            return;
        }
        CFStackFrame currentStackFrame = this.cfStack.peekStackFrame();
        String templatePath = currentStackFrame.getTemplatePath();
        String functionName = null;
        if (!currentStackFrame.isTag()) {
            functionName = currentStackFrame.getElementName();
        }
        String key = VariableStat.makeKey(templatePath, functionName, variableName, scopeType);
        this.variables.remove(key);
    }

    public String getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParamters(String queryParameters) {
        this.queryParameters = queryParameters;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public String getRequestFunctionName() {
        return this.requestFunctionName;
    }

    public void setRequestFunctionName(String requestFunctionName) {
        if (this.requestFunctionName == null) {
            this.requestFunctionName = requestFunctionName;
        }
    }

    public long getResponseTime() {
        return this.requestEndTime > this.requestStartTime ? this.requestEndTime - this.requestStartTime : 0L;
    }

    public synchronized void addThreadMonitorData(ThreadMonitorData rmd) {
        if (this.threadMonitors == null) {
            this.threadMonitors = new HashSet();
            this.threadDataList = new ArrayList<Map>();
        }
        this.threadMonitors.add(rmd);
    }

    public void updateThreadData(ThreadMonitorData tmd) {
        this.threadDataList.add(tmd.getThreadInfoMap());
    }

    public void removeThreadMonitorData(ThreadMonitorData tmd) {
        if (this.threadMonitors != null) {
            this.threadMonitors.remove(tmd);
        }
    }

    public CFThreadMonitorData[] getThreadMonitorData() {
        if (this.threadMonitors == null) {
            return new CFThreadMonitorData[0];
        }
        return this.threadMonitors.toArray(new CFThreadMonitorData[this.threadMonitors.size()]);
    }

    public static RequestMonitorData setup(boolean td) {
        RequestMonitorData rmd = new RequestMonitorData();
        RequestMonitorData.setCurrent(rmd);
        return rmd;
    }

    public static void teardown() {
        RequestMonitorData rmd = current.get();
        if (rmd != null) {
            rmd.release();
        }
        RequestMonitorData.setCurrent(null);
    }

    private static void setCurrent(RequestMonitorData r) {
        current.set(r);
        ThreadDictionary.getInstance().set(r);
    }

    public static RequestMonitorData getCurrent() {
        return RequestMonitorData.getCurrent(false);
    }

    public static RequestMonitorData getCurrent(boolean force) {
        RequestMonitorData rmd = null;
        boolean isFrMonitoringEnabled = RequestMonitorData.getFRMonitoringStatus();
        if (Configuration.INSTANCE.isMonitoringEnabled() || force || isFrMonitoringEnabled) {
            rmd = current.get();
        }
        return rmd;
    }

    private static boolean getFRMonitoringStatus() {
        InMemoryMonitoringService ms = ServiceFactory.getInMemoryMonitoringService();
        if (ms != null) {
            return ms.isMonitoringEnabled();
        }
        return false;
    }

    public String getReqType() {
        return this.reqType;
    }

    public void setReqType(String reqType) {
        this.reqType = reqType;
    }

    public boolean hasExternalServices() {
        return this.hasExternalServices;
    }

    public void setHasExternalServices(boolean hasExternalServices) {
        if (!Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isTagMetrics()) {
            if (this.pageElementList == null) {
                this.pageElementList = new ArrayList<PageElementStat>();
            }
            if (this.cfStack == null) {
                this.cfStack = new CFStack();
            }
        }
        this.hasExternalServices = hasExternalServices;
    }

    private void release() {
        this.pageElementList = null;
        this.activeQueryStat = null;
        this.requestScope = null;
        this.requestScopeMTProxy = null;
        this.cfStack = null;
        this.variables = null;
        this.threadMonitors = null;
        this.hiddenScope = null;
        this.queryStatList = null;
    }
}

