/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.osgi.scanner;

import coldfusion.compiler.ASTstart;
import coldfusion.compiler.JJTreeVisitor;
import coldfusion.compiler.NeoTranslator;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.osgi.scanner.ModulesCodeScannerValidator;
import coldfusion.runtime.Struct;
import coldfusion.securityanalyzer.SecurityAnalyzerUtils;
import coldfusion.server.ConfigMap;
import coldfusion.server.felix.FelixUtil;
import coldfusion.tools.CompilerContext;
import coldfusion.util.FastHashtable;
import coldfusion.wddx.WddxDeserializer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.xml.sax.InputSource;

public class ModulesCodeScanner {
    private NeoTranslator translator = null;
    private String lib = null;
    public static Map<String, String> dbModules = new HashMap<String, String>();

    public ModulesCodeScanner(String libFolder) {
        this.lib = libFolder;
    }

    public Set<String> scan(String path) {
        try {
            final HashSet<String> modules = new HashSet<String>();
            Thread scanDatabasesThread = new Thread(){

                @Override
                public void run() {
                    ModulesCodeScanner.this.scanDatabases(modules);
                }
            };
            Thread scanSessionStorageThread = new Thread(){

                @Override
                public void run() {
                    ModulesCodeScanner.this.scanSessionStorage(modules);
                }
            };
            Thread scanDebuggerThread = new Thread(){

                @Override
                public void run() {
                    ModulesCodeScanner.this.scanDebugger(modules);
                }
            };
            Thread scanAxisThread = new Thread(){

                @Override
                public void run() {
                    ModulesCodeScanner.this.scanAxis(modules);
                }
            };
            Thread scanCloudThread = new Thread(){

                @Override
                public void run() {
                    ModulesCodeScanner.this.scanCloud(modules);
                }
            };
            scanDatabasesThread.start();
            scanSessionStorageThread.start();
            scanDebuggerThread.start();
            scanAxisThread.start();
            scanCloudThread.start();
            this.scanCode(path, modules);
            scanDatabasesThread.join();
            scanSessionStorageThread.join();
            scanDebuggerThread.join();
            scanAxisThread.join();
            scanCloudThread.join();
            return modules;
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e);
            return null;
        }
    }

    private void scanCode(String path, Set<String> modules) {
        this.createNeoTranslator(path);
        ModulesCodeScannerValidator validator = new ModulesCodeScannerValidator(modules);
        this._scanCode(path, validator);
    }

    private void scanDatabases(Set<String> modules) {
        String file = this.lib + File.separator + "neo-datasource.xml";
        WddxDeserializer deserializer = new WddxDeserializer();
        InputSource source = null;
        try {
            source = new InputSource(new FileReader(new File(file)));
        }
        catch (FileNotFoundException e) {
            CFLogs.SERVER_LOG.error(e);
            return;
        }
        try {
            Vector v = (Vector)deserializer.deserialize(source);
            ConfigMap map = (ConfigMap)v.elementAt(0);
            Enumeration elements = map.elements();
            while (elements.hasMoreElements()) {
                ConfigMap element = (ConfigMap)elements.nextElement();
                String driver = ((String)element.get("DRIVER")).toLowerCase();
                if (!dbModules.containsKey(driver)) continue;
                modules.add(dbModules.get(driver));
            }
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e);
        }
    }

    private void scanCloud(Set<String> modules) {
        String file = this.lib + File.separator + "neo-cloud-config.xml";
        WddxDeserializer deserializer = new WddxDeserializer();
        InputSource source = null;
        try {
            source = new InputSource(new FileReader(new File(file)));
        }
        catch (FileNotFoundException e) {
            CFLogs.SERVER_LOG.error(e);
            return;
        }
        try {
            Enumeration elements;
            ConfigMap map = (ConfigMap)deserializer.deserialize(source);
            if (map != null && (elements = map.elements()) != null) {
                while (elements.hasMoreElements()) {
                    Object elem = elements.nextElement();
                    String driver = "";
                    if (elem instanceof ConfigMap) {
                        element = (ConfigMap)elem;
                        driver = ((String)((FastHashtable)element).get("serviceName")).toLowerCase();
                    } else if (elem instanceof Struct) {
                        element = (Struct)elem;
                        driver = ((String)((Struct)element).get("serviceName")).toLowerCase();
                    }
                    if (!ModulesCodeScannerValidator.cloudModules.containsKey(driver)) continue;
                    modules.add(ModulesCodeScannerValidator.cloudModules.get(driver));
                }
            }
        }
        catch (Throwable e) {
            CFLogs.SERVER_LOG.error(e);
        }
    }

    private void scanSessionStorage(Set<String> modules) {
        String file = this.lib + File.separator + "neo-runtime.xml";
        WddxDeserializer deserializer = new WddxDeserializer();
        InputSource source = null;
        try {
            source = new InputSource(new FileReader(new File(file)));
        }
        catch (FileNotFoundException e) {
            CFLogs.SERVER_LOG.error(e);
            return;
        }
        try {
            Vector v = (Vector)deserializer.deserialize(source);
            ConfigMap map = (ConfigMap)v.elementAt(14);
            String storage = ((String)map.get("sessionStorage")).toLowerCase();
            if (storage.equals("redis")) {
                modules.add("redissessionstorage");
            }
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e);
        }
    }

    private void scanDebugger(Set<String> modules) {
        String file = this.lib + File.separator + "neo-debug.xml";
        WddxDeserializer deserializer = new WddxDeserializer();
        InputSource source = null;
        try {
            source = new InputSource(new FileReader(new File(file)));
        }
        catch (FileNotFoundException e) {
            CFLogs.SERVER_LOG.error(e);
            return;
        }
        try {
            Vector v = (Vector)deserializer.deserialize(source);
            ConfigMap map = (ConfigMap)v.elementAt(0);
            Boolean robust = (Boolean)map.get("robust_enabled");
            if (robust.booleanValue()) {
                modules.add("debugger");
            }
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e);
        }
    }

    private void scanAxis(Set<String> modules) {
        String file = this.lib + File.separator + "neo-xmlrpc.xml";
        WddxDeserializer deserializer = new WddxDeserializer();
        InputSource source = null;
        try {
            source = new InputSource(new FileReader(new File(file)));
        }
        catch (FileNotFoundException e) {
            CFLogs.SERVER_LOG.error(e);
            return;
        }
        try {
            Vector v = (Vector)deserializer.deserialize(source);
            ConfigMap map = (ConfigMap)v.elementAt(0);
            if (map.size() > 0) {
                modules.add("axis");
            }
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e);
        }
    }

    private void _scanCode(String path, JJTreeVisitor validator) {
        if (new File(path).isFile()) {
            if (path.toLowerCase().endsWith("cfm") || path.toLowerCase().endsWith("cfc")) {
                CFLogs.SERVER_LOG.info("Scanning : " + path);
                this.walkThroughNode(new File(path), validator);
            }
        } else {
            File[] paths;
            for (File ipath : paths = new File(path).listFiles()) {
                this._scanCode(ipath.getAbsolutePath(), validator);
            }
        }
    }

    private void createNeoTranslator(String path) {
        FusionContext fusionContext = SecurityAnalyzerUtils.getDummyFusionContext(path);
        FusionContext.setCurrent(fusionContext);
        CompilerContext application = new CompilerContext();
        Thread.currentThread().setContextClassLoader(application.getClass().getClassLoader());
        application.setWebRoot(FelixUtil.libFolder + File.separator + ".." + File.separator + "wwwroot");
        Object outputDir = System.getProperty("java.io.tmpdir");
        if (!((String)outputDir).endsWith("\\") && !((String)outputDir).endsWith("/")) {
            outputDir = (String)outputDir + File.separator;
        }
        outputDir = (String)outputDir + "Adobe" + File.separator + "ColdFusion" + File.separator + "cfclasses";
        application.setAttribute("coldfusion.compiler.outputDir", outputDir);
        application.setInitParameter("cftags", "/WEB-INF/cftags");
        fusionContext.application = application;
        try {
            this.translator = new NeoTranslator(fusionContext.application);
        }
        catch (IOException e) {
            CFLogs.SERVER_LOG.error(e);
        }
    }

    private void walkThroughNode(File filepath, JJTreeVisitor validator) {
        ASTstart root = null;
        try {
            FusionContext.setCurrent(SecurityAnalyzerUtils.getDummyFusionContext(filepath.getAbsolutePath()));
            root = this.translator.translateToASTNode(filepath.getAbsolutePath());
            root.accept(validator);
        }
        catch (Throwable e) {
            CFLogs.SERVER_LOG.error("Could not parse file : " + filepath.getAbsolutePath());
            CFLogs.SERVER_LOG.error(e);
        }
    }

    static {
        dbModules.put("mysql_dd", "mysql");
        dbModules.put("db2", "db2");
        dbModules.put("sequelink", "odbc");
        dbModules.put("oracle", "oracle");
        dbModules.put("derby", "derby");
        dbModules.put("mssqlserver", "sqlserver");
        dbModules.put("postgresql", "postgresql");
        dbModules.put("msaccess", "odbc");
        dbModules.put("apache derby embedded", "derby");
    }
}

