/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.osgi.scanner;

import coldfusion.compiler.ASTStructInitializer;
import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTfuncparams;
import coldfusion.compiler.ASTruntimeCall;
import coldfusion.compiler.ASTstart;
import coldfusion.compiler.ASTstructureReference;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.JJTreeVisitor;
import coldfusion.compiler.Node;
import coldfusion.compiler.TagNode;
import coldfusion.osgi.scanner.ModulesCodeScanner;
import coldfusion.runtime.CFPage;
import coldfusion.securityanalyzer.rules.RulesCommon;
import coldfusion.securityanalyzer.rules.VariableType;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModulesCodeScannerValidator
extends JJTreeVisitor {
    private Set<String> modules;
    public static Map<String, String> tags = new HashMap<String, String>();
    private static Map<String, String> functionPrefixes;
    private static Map<String, String> functionContains;
    private static Map<String, String> adminApis;
    public static Map<String, String> cloudModules;

    public ModulesCodeScannerValidator(Set<String> modules) {
        this.modules = modules;
    }

    public Set<String> getModules() {
        return this.modules;
    }

    @Override
    public void visit(TagNode tagNode) {
        String cfTagName = tagNode.getTagName();
        String tagName = cfTagName.substring(2);
        if (tagName.toLowerCase().equals("createobject")) {
            Node type = tagNode.getNamedAttribute("type");
            this._handleCreateObject(type);
        }
        if (tagName.toLowerCase().equals("file")) {
            this.handleS3(tagNode.getAttrNode("file"));
        } else if (tagName.toLowerCase().equals("directory")) {
            this.handleS3(tagNode.getAttrNode("directory"));
        } else if (tagName.toLowerCase().equals("query")) {
            this.handleQueryCache(tagNode);
            this.handleHQL(tagNode.getAttrNode("dbtype"));
        } else if (tags.keySet().contains(tagName)) {
            this.modules.add(tags.get(tagName));
        }
    }

    private void handleHQL(ExprNode node) {
        String value;
        VariableType type;
        if (node != null && (type = RulesCommon.getVariableReferenceTypeFromNode(node)) != null && type.getValue() != null && (value = type.getValue().toLowerCase()).equals("hql")) {
            this.modules.add("orm");
        }
    }

    private void handleQueryCache(TagNode tagNode) {
        if (tagNode.getAttrNode("cacheafter") != null || tagNode.getAttrNode("cachewithin") != null) {
            this.modules.add("caching");
        }
    }

    private void handleS3(ExprNode node) {
        String value;
        VariableType type;
        if (node != null && (type = RulesCommon.getVariableReferenceTypeFromNode(node)) != null && type.getValue() != null && (value = type.getValue().toLowerCase()).startsWith("s3")) {
            this.modules.add("awss3legacy");
        }
    }

    @Override
    public void visit(ASTfuncparams node) {
        String functionName = node.getFunctionName().toLowerCase();
        if (functionName.equals("createobject")) {
            this.handleCreateObject(node);
            return;
        }
        Method[] methods = CFPage.class.getMethods();
        boolean isCFPageFunction = false;
        for (Method method : methods) {
            if (!functionName.equalsIgnoreCase(method.getName())) continue;
            isCFPageFunction = true;
            break;
        }
        if (isCFPageFunction) {
            for (String prefix : functionPrefixes.keySet()) {
                if (!functionName.startsWith(prefix)) continue;
                this.modules.add(functionPrefixes.get(prefix));
                break;
            }
            for (String contain : functionContains.keySet()) {
                if (!functionName.contains(contain)) continue;
                this.modules.add(functionContains.get(contain));
                break;
            }
        }
    }

    private void handleCreateObject(ASTfuncparams node) {
        List<Node> children = node.getAllChildren();
        if (children != null && children.size() > 0) {
            Node child = children.get(0);
            this._handleCreateObject(child);
            if (children.size() > 1) {
                child = children.get(1);
                this._handleCreateObject(child);
            }
        }
    }

    private void _handleCreateObject(Node child) {
        String value;
        VariableType type = RulesCommon.getVariableReferenceTypeFromNode(child);
        if (type != null && (value = type.getValue().toLowerCase()) != null) {
            if (value.equals(".net") || value.equals("dotnet")) {
                this.modules.add("dotnet");
            } else if (value.equals("corba")) {
                this.modules.add("corba");
            } else if (value.startsWith("cfide.adminapi.")) {
                String cfc;
                String m;
                String[] splits = value.split("\\.");
                if (splits.length == 3 && (m = adminApis.get((cfc = splits[2]).toLowerCase())) != null) {
                    this.modules.add(m);
                }
                this.modules.add("adminapi");
            }
        }
    }

    @Override
    public void visit(ASTstart root) {
    }

    @Override
    public void visit(ASTcfscriptStatement cfscript) {
        ASTstructureReference sr;
        String[] keys;
        Node rval = cfscript.getNamedAttribute("RVAL");
        Node lval = cfscript.getNamedAttribute("LVAL");
        boolean isDatasourcesKey = false;
        if (lval instanceof ASTstructureReference && (keys = (sr = (ASTstructureReference)lval).getStructureKeys()) != null && keys.length > 0 && keys[0].equalsIgnoreCase("datasources")) {
            isDatasourcesKey = true;
        }
        if (rval instanceof ASTStructInitializer) {
            this.extractASTStructInitializer(rval, isDatasourcesKey);
        }
    }

    private void extractASTStructInitializer(Node rval, boolean isDatasourcesKey) {
        ASTStructInitializer si = (ASTStructInitializer)rval;
        Map initializers = si.getInitializers();
        Set keys = initializers.keySet();
        for (Object o : keys) {
            String driver;
            VariableType type;
            VariableType keytype;
            Object v = initializers.get(o);
            if (v instanceof ASTStructInitializer) {
                this.extractASTStructInitializer((Node)v, isDatasourcesKey);
            }
            if ((keytype = RulesCommon.getVariableReferenceTypeFromNode(o)) == null || keytype.getValue() == null) continue;
            String key = keytype.getValue();
            if (key.toLowerCase().equals("servicename")) {
                String value;
                type = RulesCommon.getVariableReferenceTypeFromNode(v);
                if (type == null || (value = type.getValue()) == null || !cloudModules.keySet().contains(value.toLowerCase())) continue;
                this.modules.add(cloudModules.get(value.toLowerCase()));
                continue;
            }
            if (!isDatasourcesKey || !key.toLowerCase().equals("driver") || (type = RulesCommon.getVariableReferenceTypeFromNode(v)) == null || (driver = type.getValue()) == null || !ModulesCodeScanner.dbModules.containsKey(driver.toLowerCase())) continue;
            this.modules.add(ModulesCodeScanner.dbModules.get(driver.toLowerCase()));
        }
    }

    @Override
    public void visit(ASTruntimeCall call) {
        ASTruntimeCall runtime;
        String funcName;
        Node stem = call.getNamedAttribute("STEM");
        if (stem != null && stem instanceof ASTruntimeCall && (funcName = (runtime = (ASTruntimeCall)stem).getFunctionName()).equalsIgnoreCase("getmongoservice")) {
            this.modules.add("cfmongodb");
        }
    }

    private void handleRest(ASTstart root) {
        Node restPathNode;
        VariableType type;
        String value;
        Node restNode = root.getNamedAttribute("rest");
        if (null != restNode && Boolean.valueOf(value = (type = RulesCommon.getVariableReferenceTypeFromNode(restNode)).getValue()).booleanValue()) {
            this.modules.add("rest");
        }
        if ((restPathNode = root.getNamedAttribute("restpath")) != null) {
            this.modules.add("rest");
        }
    }

    static {
        tags.put("cache", "caching");
        tags.put("slider", "ajax");
        tags.put("grid", "ajax");
        tags.put("progressbar", "ajax");
        tags.put("layout", "ajax");
        tags.put("map", "ajax");
        tags.put("window", "ajax");
        tags.put("pdf", "pdf");
        tags.put("pdfform", "pdf");
        tags.put("document", "document");
        tags.put("sharepoint", "sharepoint");
        tags.put("search", "search");
        tags.put("index", "search");
        tags.put("collection", "search");
        tags.put("ftp", "ftp");
        tags.put("report", "report");
        tags.put("print", "print");
        tags.put("feed", "feed");
        tags.put("schedule", "scheduler");
        tags.put("mail", "mail");
        tags.put("exchange", "exchange");
        tags.put("pop", "mail");
        tags.put("imap", "mail");
        tags.put("zip", "zip");
        tags.put("image", "image");
        tags.put("spreadsheet", "spreadsheet");
        tags.put("websocket", "websocket");
        tags.put("chart", "chart");
        tags.put("presentation", "presentation");
        tags.put("htmltopdf", "htmltopdf");
        tags.put("exchange", "exchange");
        tags.put("exchangecalendar", "exchange");
        tags.put("exchangeconnection", "exchange");
        tags.put("exchangecontact", "exchange");
        tags.put("exchangetask", "exchange");
        tags.put("exchangeconversation", "exchange");
        tags.put("exchangefilter", "exchange");
        tags.put("exchangefolder", "exchange");
        tags.put("exchangemail", "exchange");
        functionPrefixes = new HashMap<String, String>();
        functionPrefixes.put("spreadsheet", "spreadsheet");
        functionPrefixes.put("image", "image");
        functionPrefixes.put("ormsearch", "ormsearch");
        functionPrefixes.put("orm", "orm");
        functionPrefixes.put("cache", "caching");
        functionPrefixes.put("ws", "websocket");
        functionContains = new HashMap<String, String>();
        functionContains.put("saml", "saml");
        functionContains.put("gateway", "eventgateways");
        adminApis = new HashMap<String, String>();
        adminApis.put("mail", "mail");
        adminApis.put("collections", "search");
        adminApis.put("eventgateway", "eventgateways");
        adminApis.put("document", "htmltopdf");
        adminApis.put("scheduler", "scheduler");
        adminApis.put("websocket", "websocket");
        adminApis.put("websocket", "websocket");
        adminApis.put("nosql_datasource", "cfmongodb");
        adminApis.put("debugging", "debugger");
        cloudModules = new HashMap<String, String>();
        cloudModules.put("dynamodb", "awsdynamodb");
        cloudModules.put("sns", "awssns");
        cloudModules.put("sqs", "awssqs");
        cloudModules.put("azure_blob", "azureblob");
        cloudModules.put("s3", "awss3");
        cloudModules.put("service_bus", "azureservicebus");
    }
}

