/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.print.core;

import coldfusion.print.core.CFPrintException;

public class PrintExceptions {

    public static class CFPrintInvalidAttributeException
    extends CFPrintException {
        public String attrName = null;
        public String attrValue = null;
        public String valueList = null;

        public CFPrintInvalidAttributeException(String name, String value, String list) {
            this.attrName = name;
            this.attrValue = value;
            this.valueList = list;
        }
    }

    public static class CFPrintInvalidValueException
    extends CFPrintException {
        public String attrName = null;
        public String attrValue = null;
        public String valueList = null;

        public CFPrintInvalidValueException(String name, String value, String list) {
            this.attrName = name;
            this.attrValue = value == null ? "<unspecified>" : value;
            this.valueList = list;
        }
    }

    public static class CFPrintTypeConversionException
    extends CFPrintException {
        public String attrName = null;

        public CFPrintTypeConversionException(String name, Exception e) {
            super(e);
            this.attrName = name;
        }
    }

    public static class CFPrintEmptyAttributeException
    extends CFPrintException {
        public String attrName = null;

        public CFPrintEmptyAttributeException(String attrName) {
            this.attrName = attrName;
        }
    }

    public static class CFPrintPDFException
    extends CFPrintException {
        public String detail = "";

        public CFPrintPDFException(Exception e) {
            super(e);
            if (e.getMessage() != null) {
                this.detail = e.getMessage();
            }
        }
    }

    public static class CFPrintPDFLandscapeException
    extends CFPrintException {
        public String orientation;

        public CFPrintPDFLandscapeException(String orientation) {
            this.orientation = orientation;
        }
    }

    public static class CFPrintSecurityAuthorizationException
    extends CFPrintException {
        public String permission;

        public CFPrintSecurityAuthorizationException(String perm) {
            this.permission = perm;
        }
    }

    public static class CFPrintInvalidPageRangeException
    extends CFPrintException {
        public String range;
        public String total;

        public CFPrintInvalidPageRangeException(String range, String total) {
            this.range = range;
            this.total = total;
        }
    }

    public static class CFPrintInvalidPageNumberException
    extends CFPrintException {
        public String page;
        public String total;

        public CFPrintInvalidPageNumberException(String page, String total) {
            this.page = page;
            this.total = total;
        }
    }

    public static class CFPrintRequestAttributeException
    extends CFPrintException {
        public String attr;
        public String printer;

        public CFPrintRequestAttributeException(String attr, String printer) {
            this.attr = attr;
            this.printer = printer;
        }
    }

    public static class CFPrintInvalidMediaException
    extends CFPrintException {
        public String printer;
        public String invalidMedia;
        public String validMediaStrings;

        public CFPrintInvalidMediaException(String printer, String invalidMedia, String validMediaStrings) {
            this.printer = printer;
            this.invalidMedia = invalidMedia;
            this.validMediaStrings = validMediaStrings;
        }
    }

    public static class PrinterUnavailableException
    extends CFPrintException {
        public String printer;
        public String printerList;

        public PrinterUnavailableException(String printer, String printerList) {
            this.printer = printer;
            this.printerList = printerList;
        }
    }

    public static class NoDefaultPrinterException
    extends CFPrintException {
    }
}

