/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rds;

import coldfusion.rds.RDSPermissionException;
import coldfusion.rds.RdsCmdProcessor;
import coldfusion.rds.RdsCmdProcessorCompositeServlet;
import coldfusion.rds.RdsRequest;
import coldfusion.rds.RdsResponse;
import coldfusion.security.AuthorizedUser;
import coldfusion.security.ESAPIUtils;
import coldfusion.security.SandBoxFolderPermissions;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import jakarta.servlet.ServletException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FileServlet
extends RdsCmdProcessorCompositeServlet {
    private static DateFormat formatter = new SimpleDateFormat("hh:mm:ssa   MM/dd/yyyy");

    @Override
    public void doInit() throws ServletException {
        this.addCmdProcessor("READ", new FileReadOperator());
        this.addCmdProcessor("WRITE", new FileWriteOperator());
        this.addCmdProcessor("RENAME", new FileRenameOperator());
        this.addCmdProcessor("REMOVE", new FileDeleteOperator());
        this.addCmdProcessor("EXISTENCE", new FileExistsOperator());
        this.addCmdProcessor("CREATE", new FileCreateDirectoryOperator());
        this.addCmdProcessor("CF_DIRECTORY", new FileCFDirectoryOperator());
    }

    @Override
    protected void processCmd(RdsRequest request, RdsResponse response, AuthorizedUser user) throws ServletException, IOException {
        String operation = request.getMetaString(1).toUpperCase();
        RdsCmdProcessor rcp = this.getCmdProcessor(operation);
        if (rcp == null) {
            response.setError(RB.getString((Object)this, "FileServlet.UnsupportedOperation", (Object)ESAPIUtils.encodeForHTML(operation, false)));
            return;
        }
        rcp.processCmd(request, response, user);
    }

    File getFile(String path) {
        path = this.resolvePath(path);
        return new File(path);
    }

    File createDirectory(String name) throws IOException {
        File dir = new File(name = this.resolvePath(name));
        if (dir.exists()) {
            throw new IOException(RB.getString((Object)this, "FileServlet.FileAlreadyExists", (Object)ESAPIUtils.encodeForHTMLFilePath(name)));
        }
        if (!dir.mkdirs()) {
            throw new IOException(RB.getString((Object)this, "FileServlet.CreateDirError", (Object)ESAPIUtils.encodeForHTMLFilePath(name)));
        }
        return dir;
    }

    String getFileName(File f) {
        String fileName = null;
        try {
            fileName = f.getCanonicalPath();
        }
        catch (IOException e) {
            fileName = f.getAbsolutePath();
        }
        return fileName;
    }

    String resolvePath(String name) {
        if (name != null && ((String)name).length() > 1 && ((String)name).charAt(1) == ':') {
            String drive = ((String)name).substring(0, 2);
            String restPath = ((String)name).substring(2);
            name = drive + File.separator + restPath;
        }
        return name;
    }

    class FileReadOperator
    extends RdsCmdProcessor {
        FileReadOperator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processCmd(RdsRequest request, RdsResponse response, AuthorizedUser user) throws IOException, ServletException {
            SandBoxFolderPermissions authorizedFolders;
            String filename = request.getMetaString(0);
            File file = FileServlet.this.getFile(filename);
            boolean doAction = true;
            if (user != null && (authorizedFolders = user.getAuthorizedFolders()) != null && !authorizedFolders.isAuthorized(file, "read")) {
                doAction = false;
                response.setError(new RDSPermissionException(filename, "read"));
            }
            if (doAction) {
                String lastModString;
                try (FileInputStream in = new FileInputStream(file);){
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] buf = new byte[255];
                    int numRead = ((InputStream)in).read(buf);
                    while (numRead != -1) {
                        out.write(buf, 0, numRead);
                        numRead = ((InputStream)in).read(buf);
                    }
                    response.addMetaData(out.toByteArray());
                }
                Date lastMod = new Date(file.lastModified());
                DateFormat dateFormat = formatter;
                synchronized (dateFormat) {
                    lastModString = formatter.format(lastMod);
                }
                response.addMetaData(lastModString);
                if (file.canWrite()) {
                    response.addMetaData("Normal");
                } else {
                    response.addMetaData("Read only");
                }
            }
        }
    }

    class FileWriteOperator
    extends RdsCmdProcessor {
        FileWriteOperator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processCmd(RdsRequest request, RdsResponse response, AuthorizedUser user) throws IOException, ServletException {
            SandBoxFolderPermissions authorizedFolders;
            String filename = request.getMetaString(0);
            File file = FileServlet.this.getFile(filename);
            boolean doAction = true;
            if (user != null && (authorizedFolders = user.getAuthorizedFolders()) != null && !authorizedFolders.isAuthorized(file, "write")) {
                doAction = false;
                response.setError(new RDSPermissionException(filename, "write"));
            }
            if (doAction) {
                byte[] fileData = request.getMetaBytes(3);
                try (FileOutputStream fout = new FileOutputStream(file);){
                    ((OutputStream)fout).write(fileData);
                    response.addMetaData("XX");
                }
            }
        }
    }

    class FileRenameOperator
    extends RdsCmdProcessor {
        FileRenameOperator() {
        }

        @Override
        public void processCmd(RdsRequest request, RdsResponse response, AuthorizedUser user) throws IOException, ServletException {
            String newPath;
            File newFile;
            String filename = request.getMetaString(0);
            File file = FileServlet.this.getFile(filename);
            if (file.renameTo(newFile = new File(newPath = request.getMetaString(3)))) {
                response.addMetaData("");
            } else {
                response.setError(RB.getString((Object)this, "FileServlet.RenameError", (Object)ESAPIUtils.encodeForHTMLFilePath(filename), (Object)ESAPIUtils.encodeForHTMLFilePath(newPath)));
            }
        }
    }

    class FileDeleteOperator
    extends RdsCmdProcessor {
        FileDeleteOperator() {
        }

        @Override
        public void processCmd(RdsRequest request, RdsResponse response, AuthorizedUser user) throws IOException, ServletException {
            SandBoxFolderPermissions authorizedFolders;
            String filename = request.getMetaString(0);
            File file = FileServlet.this.getFile(filename);
            boolean doAction = true;
            if (user != null && (authorizedFolders = user.getAuthorizedFolders()) != null && !authorizedFolders.isAuthorized(file, "delete")) {
                doAction = false;
                response.setError(new RDSPermissionException(filename, "delete"));
            }
            if (doAction) {
                try {
                    this.deleteAll(file);
                    response.addMetaData("");
                }
                catch (IOException ioe) {
                    response.setError(RB.getString((Object)this, "FileServlet.DeleteError", (Object)ESAPIUtils.encodeForHTMLFilePath(filename)));
                }
            }
        }

        private void deleteAll(File f) throws IOException {
            if (f.isDirectory()) {
                String[] files = f.list();
                for (int i = 0; i < files.length; ++i) {
                    File child = new File(f, files[i]);
                    this.deleteAll(child);
                }
            }
            if (!f.delete()) {
                throw new IOException(RB.getString((Object)this, "FileServlet.DeleteError", (Object)ESAPIUtils.encodeForHTMLFilePath(FileServlet.this.getFileName(f))));
            }
        }
    }

    class FileExistsOperator
    extends RdsCmdProcessor {
        FileExistsOperator() {
        }

        @Override
        public void processCmd(RdsRequest request, RdsResponse response, AuthorizedUser user) throws IOException, ServletException {
            String filename = request.getMetaString(0);
            File file = FileServlet.this.getFile(filename);
            boolean success = file.exists();
            if (success) {
                response.addMetaData("");
            } else {
                response.setError(RB.getString((Object)this, "FileServlet.NoPath", (Object)ESAPIUtils.encodeForHTMLFilePath(filename)));
            }
        }
    }

    class FileCreateDirectoryOperator
    extends RdsCmdProcessor {
        FileCreateDirectoryOperator() {
        }

        @Override
        public void processCmd(RdsRequest request, RdsResponse response, AuthorizedUser user) throws IOException, ServletException {
            SandBoxFolderPermissions authorizedFolders;
            String filename = request.getMetaString(0);
            boolean doAction = true;
            if (user != null && (authorizedFolders = user.getAuthorizedFolders()) != null && !authorizedFolders.isAuthorized(new File(filename), "write")) {
                doAction = false;
                response.setError(new RDSPermissionException(filename, "write"));
            }
            if (doAction) {
                try {
                    FileServlet.this.createDirectory(filename);
                    response.addMetaData("");
                }
                catch (IOException e) {
                    response.setError(RB.getString((Object)this, "FileServlet.CreateDirError", (Object)filename), e);
                }
            }
        }
    }

    class FileCFDirectoryOperator
    extends RdsCmdProcessor {
        FileCFDirectoryOperator() {
        }

        @Override
        public void processCmd(RdsRequest request, RdsResponse response, AuthorizedUser user) throws IOException, ServletException {
            response.addMetaData(ServiceFactory.getRuntimeService().getRootDir());
        }
    }
}

