/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rds;

import coldfusion.graph.ChartDataSeries;
import coldfusion.graph.GraphDataPoint;
import coldfusion.graph.InteractiveChart;
import coldfusion.graph.JSONManipulator;
import coldfusion.rds.RdsCmdProcessor;
import coldfusion.rds.RdsCmdProcessorCompositeServlet;
import coldfusion.rds.RdsRequest;
import coldfusion.rds.RdsResponse;
import coldfusion.security.AuthorizedUser;
import coldfusion.security.ESAPIUtils;
import coldfusion.server.GraphingService;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;

public class GraphingServlet
extends RdsCmdProcessorCompositeServlet {
    private static final int CHARTHEIGHT = 1;
    private static final int CHARTWIDTH = 2;
    private static final int SCALETO = 3;
    private static final int SCALEFROM = 4;
    private static final int SHOWXGRIDLINES = 5;
    private static final int SHOWYGRIDLINES = 6;
    private static final int GRIDLINES = 7;
    private static final int SERIESPLACEMENT = 8;
    private static final int FOREGROUNDCOLOR = 9;
    private static final int DATABACKGROUNDCOLOR = 10;
    private static final int BACKGROUNDCOLOR = 11;
    private static final int SHOWBORDER = 12;
    private static final int FONT = 13;
    private static final int FONTSIZE = 14;
    private static final int FONTBOLD = 15;
    private static final int FONTITALIC = 16;
    private static final int XAXISTITLE = 17;
    private static final int YAXISTITLE = 18;
    private static final int SHOW3D = 19;
    private static final int XOFFSET = 20;
    private static final int YOFFSET = 21;
    private static final int ROTATED = 22;
    private static final int SHOWLEGEND = 23;
    private static final int LABELFORMAT = 24;
    private static final int LABELMASK = 25;
    private static final int SHOWMARKERS = 26;
    private static final int MARKERSIZE = 27;
    private static final int PIESLICESTYLE = 28;
    private static final int SORTXAXIS = 29;
    private static final int XAXISTYPE = 30;
    private static final int YAXISTYPE = 31;
    private static final int TITLE = 32;
    private static final int STYLE = 33;
    private static final String GRAPHSET = "graphset";
    private static HashMap chartMap = new HashMap();
    private static final int SERIESLABEL = 1;
    private static final int SERIESCOLOR = 2;
    private static final int PAINTSTYLE = 3;
    private static final int MARKERSTYLE = 4;
    private static final int TYPE = 5;
    private static final int DATALABELSTYLE = 6;
    static HashMap seriesMap;

    @Override
    public void doInit() throws ServletException {
        this.addCmdProcessor("GRAPH", new GraphingGraphOperator());
    }

    @Override
    protected void processCmd(RdsRequest request, RdsResponse response, AuthorizedUser user) throws ServletException, IOException {
        String operation = request.getMetaString(0).toUpperCase();
        RdsCmdProcessor rcp = this.getCmdProcessor(operation);
        if (rcp == null) {
            response.setError(RB.getString((Object)this, "GraphingServliet.UnsupportedOperation", (Object)ESAPIUtils.encodeForHTML(operation, false)));
            return;
        }
        rcp.processCmd(request, response, user);
    }

    static {
        chartMap.put("CHARTHEIGHT", new Integer(1));
        chartMap.put("CHARTWIDTH", new Integer(2));
        chartMap.put("SCALETO", new Integer(3));
        chartMap.put("SCALEFROM", new Integer(4));
        chartMap.put("SHOWXGRIDLINES", new Integer(5));
        chartMap.put("SHOWYGRIDLINES", new Integer(6));
        chartMap.put("GRIDLINES", new Integer(7));
        chartMap.put("SERIESPLACEMENT", new Integer(8));
        chartMap.put("FOREGROUNDCOLOR", new Integer(9));
        chartMap.put("DATABACKGROUNDCOLOR", new Integer(10));
        chartMap.put("BACKGROUNDCOLOR", new Integer(11));
        chartMap.put("SHOWBORDER", new Integer(12));
        chartMap.put("FONT", new Integer(13));
        chartMap.put("FONTSIZE", new Integer(14));
        chartMap.put("FONTBOLD", new Integer(15));
        chartMap.put("FONTITALIC", new Integer(16));
        chartMap.put("XAXISTITLE", new Integer(17));
        chartMap.put("YAXISTITLE", new Integer(18));
        chartMap.put("SHOW3D", new Integer(19));
        chartMap.put("XOFFSET", new Integer(20));
        chartMap.put("YOFFSET", new Integer(21));
        chartMap.put("ROTATED", new Integer(22));
        chartMap.put("SHOWLEGEND", new Integer(23));
        chartMap.put("LABELFORMAT", new Integer(24));
        chartMap.put("LABELMASK", new Integer(25));
        chartMap.put("SHOWMARKERS", new Integer(26));
        chartMap.put("MARKERSIZE", new Integer(27));
        chartMap.put("PIESLICESTYLE", new Integer(28));
        chartMap.put("SORTXAXIS", new Integer(29));
        chartMap.put("XAXISTYPE", new Integer(30));
        chartMap.put("YAXISTYPE", new Integer(31));
        chartMap.put("TITLE", new Integer(32));
        chartMap.put("STYLE", new Integer(33));
        seriesMap = new HashMap();
        seriesMap.put("SERIESLABEL", new Integer(1));
        seriesMap.put("SERIESCOLOR", new Integer(2));
        seriesMap.put("PAINTSTYLE", new Integer(3));
        seriesMap.put("MARKERSTYLE", new Integer(4));
        seriesMap.put("TYPE", new Integer(5));
        seriesMap.put("DATALABELSTYLE", new Integer(6));
    }

    class GraphingGraphOperator
    extends RdsCmdProcessor {
        private static final String REL_STYLE_DIR = "charting/styles/";

        GraphingGraphOperator() {
        }

        private Vector getAttributeVector(String attribs) {
            Vector<String> tmpVector = new Vector<String>();
            int index = attribs.indexOf(";");
            int start = 0;
            while (index != -1) {
                String tmpComparison = attribs.substring(start, index);
                if (!tmpComparison.equals("")) {
                    tmpVector.add(tmpComparison);
                }
                if ((index = attribs.indexOf(";", start = index + 1)) != -1 || (tmpComparison = attribs.substring(start)).equals("")) continue;
                tmpVector.add(tmpComparison);
            }
            return tmpVector;
        }

        private String getNameFromPair(String attrib) {
            int index = attrib.indexOf("=");
            return attrib.substring(0, index);
        }

        private String getValueFromPair(String attrib) {
            int index = attrib.indexOf("=");
            return attrib.substring(index + 1);
        }

        @Override
        public void processCmd(RdsRequest request, RdsResponse response, AuthorizedUser user) throws IOException, ServletException {
            Integer HashResult;
            String Value2;
            String Name2;
            String chartAttribString;
            int i;
            String _style = null;
            int numOfSeries = Integer.parseInt(request.getMetaString(2));
            Random rnd = new Random(1234567890L);
            Vector chartAttribs = this.getAttributeVector(request.getMetaString(1));
            InteractiveChart _graph = new InteractiveChart();
            _graph.setImageFormat("png");
            int scaleFrom = 0;
            int scaleTo = 100;
            block43: for (i = 0; i < chartAttribs.size(); ++i) {
                chartAttribString = (String)chartAttribs.get(i);
                Name2 = this.getNameFromPair(chartAttribString).toUpperCase();
                Value2 = this.getValueFromPair(chartAttribString);
                HashResult = (Integer)chartMap.get(Name2);
                if (HashResult == null) continue;
                switch (HashResult) {
                    case 1: {
                        _graph.setGraphHeight(Value2);
                        continue block43;
                    }
                    case 2: {
                        _graph.setGraphWidth(Value2);
                        continue block43;
                    }
                    case 3: {
                        scaleTo = Integer.parseInt(Value2);
                        _graph.setScaleTo(new Integer(scaleTo).doubleValue());
                        continue block43;
                    }
                    case 4: {
                        scaleFrom = Integer.parseInt(Value2);
                        _graph.setScaleFrom(new Integer(scaleFrom).doubleValue());
                        continue block43;
                    }
                    case 5: {
                        _graph.setShowXGridlines(Value2.equalsIgnoreCase("yes"));
                        continue block43;
                    }
                    case 6: {
                        _graph.setShowYGridlines(Value2.equalsIgnoreCase("yes"));
                        continue block43;
                    }
                    case 7: {
                        _graph.setNumGridelines(Integer.parseInt(Value2));
                        continue block43;
                    }
                    case 8: {
                        _graph.setPlaceStyle(Value2);
                        continue block43;
                    }
                    case 9: {
                        _graph.setForegroundNGridColor(Value2);
                        continue block43;
                    }
                    case 10: {
                        _graph.setInnerColor(Value2);
                        continue block43;
                    }
                    case 11: {
                        _graph.setOuterColor(Value2);
                        continue block43;
                    }
                    case 12: {
                        _graph.setShowBorder(Value2.equalsIgnoreCase("yes"));
                        continue block43;
                    }
                    case 13: {
                        _graph.setFont(Value2);
                        continue block43;
                    }
                    case 14: {
                        _graph.setFontSize(Integer.parseInt(Value2));
                        continue block43;
                    }
                    case 15: {
                        _graph.setFontBold(Value2.equalsIgnoreCase("yes"));
                        continue block43;
                    }
                    case 16: {
                        _graph.setFontItalic(Value2.equalsIgnoreCase("yes"));
                        continue block43;
                    }
                    case 17: {
                        _graph.setXAxisTitle(Value2);
                        continue block43;
                    }
                    case 18: {
                        _graph.setYAxisTitle(Value2);
                        continue block43;
                    }
                    case 19: {
                        _graph.setIs3D(Value2.equalsIgnoreCase("yes"));
                        continue block43;
                    }
                    case 20: {
                        _graph.setXOffset(Double.parseDouble(Value2));
                        continue block43;
                    }
                    case 21: {
                        _graph.setYOffset(Double.parseDouble(Value2));
                        continue block43;
                    }
                    case 22: {
                        _graph.setRotated(Value2.equalsIgnoreCase("yes"));
                        continue block43;
                    }
                    case 23: {
                        _graph.setHasLegend(Value2.equalsIgnoreCase("yes"));
                        continue block43;
                    }
                    case 24: {
                        _graph.setLabelFormat(Value2);
                        continue block43;
                    }
                    case 25: {
                        _graph.setLabelMask(Value2);
                        continue block43;
                    }
                    case 26: {
                        _graph.setShowMarkers(Value2.equalsIgnoreCase("yes"));
                        continue block43;
                    }
                    case 27: {
                        _graph.setMarkerSize(Integer.parseInt(Value2));
                        continue block43;
                    }
                    case 28: {
                        _graph.setPieSliceStyle(Value2);
                        continue block43;
                    }
                    case 29: {
                        _graph.setSortColumnNames(Value2.equalsIgnoreCase("yes"));
                        continue block43;
                    }
                    case 30: {
                        _graph.setXAxisType(Value2.toLowerCase());
                        continue block43;
                    }
                    case 31: {
                        _graph.setYAxisType(Value2.toLowerCase());
                        continue block43;
                    }
                    case 32: {
                        _graph.setTitle(Value2);
                        continue block43;
                    }
                    case 33: {
                        _style = Value2;
                    }
                }
            }
            for (i = 0; i < numOfSeries; ++i) {
                int j;
                chartAttribs.clear();
                chartAttribs = this.getAttributeVector(request.getMetaString(3 + i));
                ChartDataSeries _dataSeries = new ChartDataSeries();
                block45: for (j = 0; j < chartAttribs.size(); ++j) {
                    chartAttribString = (String)chartAttribs.get(j);
                    Name2 = this.getNameFromPair(chartAttribString).toUpperCase();
                    Value2 = this.getValueFromPair(chartAttribString);
                    HashResult = (Integer)seriesMap.get(Name2);
                    if (HashResult == null) continue;
                    switch (HashResult) {
                        case 1: {
                            _dataSeries.setSeriesLabel(Value2);
                            continue block45;
                        }
                        case 2: {
                            _dataSeries.setForeColor(Value2);
                            continue block45;
                        }
                        case 3: {
                            _dataSeries.setPaintStyle(Value2);
                            continue block45;
                        }
                        case 4: {
                            _dataSeries.setMarkerStyle(Value2);
                            continue block45;
                        }
                        case 5: {
                            _dataSeries.setChartType(Value2);
                            continue block45;
                        }
                        case 6: {
                            _dataSeries.setDataLabelStyle(Value2);
                        }
                    }
                }
                for (j = 0; j < 5; ++j) {
                    GraphDataPoint _datapoint = new GraphDataPoint("Sample" + String.valueOf(j), String.valueOf(rnd.nextInt(scaleTo - scaleFrom) + scaleFrom));
                    _dataSeries.addDataPoint(_datapoint);
                }
            }
            String graphStyle = null;
            HashMap graphdata = new HashMap();
            graphdata.put(GraphingServlet.GRAPHSET, new ArrayList());
            _graph.mergeJSON(graphdata, false);
            String graphContent = JSONManipulator.serializeJSON(graphdata);
            String url = null;
            GraphingService graphService = ServiceFactory.getGraphingService();
            byte[] graphData = graphService.generateBytes(_graph.getImageFormat(), _graph.getGraphHeight(), _graph.getGraphWidth(), url, graphStyle, graphContent, "", null);
            response.addMetaData(graphData);
        }
    }
}

