/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rds;

import coldfusion.rds.MetaHeader;
import coldfusion.rds.RdsGlobals;
import coldfusion.rds.RdsHttpResponseFormatter;
import coldfusion.rds.RdsResponse;
import coldfusion.util.RB;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;

class RdsResponseImpl
implements RdsResponse,
RdsGlobals {
    private HttpServletResponse _response;
    private final MetaHeader _meta = new MetaHeader("utf-8");
    private String _errorMessage;
    private boolean _errorOccurred;
    private Throwable _error;
    private int _errorCode = -1;

    RdsResponseImpl() {
    }

    final void init(HttpServletResponse resp) {
        this._response = resp;
    }

    final void finish() throws ServletException, IOException {
        try {
            RdsHttpResponseFormatter formatter = new RdsHttpResponseFormatter();
            if (this.errorOccurred()) {
                formatter.setError(this._errorCode, this._errorMessage, this._error);
            } else {
                Enumeration metadataEnum = this.enumerateMetaData();
                while (metadataEnum.hasMoreElements()) {
                    Object obj = metadataEnum.nextElement();
                    if (obj instanceof String) {
                        formatter.add((String)obj);
                        continue;
                    }
                    if (obj instanceof byte[]) {
                        formatter.add((byte[])obj);
                        continue;
                    }
                    throw new IOException(RB.getString((Object)this, "RdsServlet.UnsupportedType", (Object)obj.getClass().getName()));
                }
            }
            byte[] bytes = formatter.getMessageBytes();
            this._response.setContentType("text/html");
            ServletOutputStream out = this._response.getOutputStream();
            out.write(bytes);
            this._response.flushBuffer();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    final void reset() {
        this._response = null;
        this._error = null;
        this._errorMessage = null;
        this._errorOccurred = false;
    }

    @Override
    public final void addMetaData(String metaString) {
        this._meta.add(metaString);
    }

    @Override
    public final void addMetaData(byte[] metaBytes) {
        this._meta.add(metaBytes);
    }

    @Override
    public final void setMetaData(int index, String metaString) {
        this._meta.set(index, metaString);
    }

    @Override
    public final void setMetaData(int index, byte[] metaBytes) {
        this._meta.set(index, metaBytes);
    }

    @Override
    public final String getMetaString(int index) {
        return this._meta.getString(index);
    }

    @Override
    public final byte[] getMetaBytes(int index) {
        return this._meta.getBytes(index);
    }

    @Override
    public final int getMetaCount() {
        return this._meta.size();
    }

    @Override
    public final Enumeration enumerateMetaData() {
        return this._meta.enumerate();
    }

    @Override
    public final HttpServletResponse getHttpServletResponse() {
        return this._response;
    }

    public final void setError(int errorCode, String message, Throwable th) {
        this._errorCode = errorCode;
        this._errorMessage = message;
        this._error = th;
        this._errorOccurred = true;
    }

    @Override
    public final void setError(String message, Throwable th) {
        this.setError(-1, message, th);
    }

    @Override
    public final void setError(Throwable th) {
        this.setError(-1, th.getMessage(), th);
    }

    @Override
    public final void setError(String message) {
        this.setError(message, new ServletException(message));
    }

    Throwable getError() {
        return this._error;
    }

    boolean errorOccurred() {
        return this._errorOccurred;
    }
}

