/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rest;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.ApplicationEventListener;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.Cast;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.server.JaxRsService;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.util.Map;

public class JaxRsAppEventListener
implements ApplicationEventListener {
    private static final Logger logger = CFLogs.SERVER_LOG;

    @Override
    public void beforeApplicationStart(ApplicationScope appScope) {
    }

    private String getHostFromRequestURL(HttpServletRequest request) {
        StringBuffer requestURI = request.getRequestURL();
        String pathAfterProtocol = requestURI.substring(requestURI.indexOf("//") + 2);
        String host = pathAfterProtocol.substring(0, pathAfterProtocol.indexOf("/"));
        return host;
    }

    @Override
    public void onApplicationStart(ApplicationScope appScope) {
        Map appSettings;
        boolean autoRegister = false;
        String serializer = null;
        if (appScope != null && (appSettings = appScope.getApplicationSettingsMap()) != null) {
            serializer = (String)appSettings.get("CustomSerializer");
            Map restSettings = (Map)appSettings.get("restsettings");
            if (null != restSettings) {
                Object object;
                Object isRESTEnabledObj = restSettings.get("restenabled");
                if (null != isRESTEnabledObj) {
                    boolean restenabled;
                    autoRegister = restenabled = Cast._boolean(isRESTEnabledObj);
                }
                if (isRESTEnabledObj == null && restSettings.size() > 0) {
                    autoRegister = true;
                }
                if (null != (object = restSettings.get("autoregister"))) {
                    autoRegister = Cast._boolean(object);
                }
                if (autoRegister) {
                    String applicationPath = appScope.getApplicationPath();
                    File file = new File(applicationPath);
                    applicationPath = file.getParent();
                    JaxRsService service = ServiceFactory.getJaxRsService();
                    Object restService = service.getRestServices().get(applicationPath);
                    if (null == restService) {
                        boolean useHost = true;
                        String serviceMapping = null;
                        String host = null;
                        Object serviceMappingObj = restSettings.get("serviceMapping");
                        Object useHostObj = restSettings.get("usehost");
                        Object hostObj = restSettings.get("host");
                        Object isDefaultObj = restSettings.get("isDefault");
                        boolean isDefault = false;
                        if (null != hostObj) {
                            host = Cast._String(hostObj).trim();
                        }
                        if (null != serviceMappingObj) {
                            serviceMapping = Cast._String(serviceMappingObj).trim();
                        }
                        if (null != useHostObj) {
                            useHost = Cast._boolean(useHostObj);
                        }
                        if (null == host && useHost) {
                            host = this.getHostFromRequestURL(FusionContext.getCurrent().getRequest());
                        }
                        if (null != isDefaultObj) {
                            isDefault = Cast._boolean(isDefaultObj);
                        }
                        if (null == serviceMapping) {
                            String appName = appScope.getName();
                            serviceMapping = appName != null && appName.length() > 0 ? appScope.getName() : new File(applicationPath).getName();
                        }
                        try {
                            service.updateApplication(applicationPath, applicationPath, serviceMapping, autoRegister, isDefault, true, host, false, false);
                            CFLogs.AUDIT_LOG.info("Registered REST service : " + serviceMapping + " through auto registration by accessing the URL.");
                        }
                        catch (Exception e) {
                            logger.error(RB.getString(this, "JaxRsAppEventListener.autoRegisterError"), e);
                        }
                    }
                }
            }
        }
        if (null != serializer) {
            this.validateSerializer(serializer);
        }
    }

    private void validateSerializer(String serializer) {
        try {
            TemplateProxyFactory.resolveName(serializer, FusionContext.getCurrent().pageContext);
        }
        catch (Throwable e) {
            logger.error(RB.getString((Object)this, "JaxRsAppEventListener.invalidSerializer", new Object[]{serializer}), e);
        }
    }

    @Override
    public void onApplicationChange(ApplicationScope appScope) {
        this.onApplicationStop(appScope);
        this.onApplicationStart(appScope);
    }

    @Override
    public void beforeApplicationStop(ApplicationScope appScope) {
    }

    @Override
    public void onApplicationStop(ApplicationScope appScope) {
    }

    public static class InvalidSerializerException
    extends ApplicationException {
        public final String serializer;
        public final String message;

        public InvalidSerializerException(String serializer, Throwable t) {
            super(t);
            this.serializer = serializer;
            this.message = t.getMessage();
        }
    }
}

