/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rest;

import coldfusion.featurerouter.EFRConstants;
import coldfusion.featurerouter.FeatureRouter;
import coldfusion.log.CFLogs;
import coldfusion.rest.RestAppAdapter;
import coldfusion.rest.core.AppNameRootPair;
import coldfusion.rest.servlet.CFRestServlet;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.Cast;
import coldfusion.server.ConfigMap;
import coldfusion.server.JaxRsService;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.ServiceRuntimeException;
import coldfusion.serverless.ServerlessUtil;
import coldfusion.util.FastHashtable;
import coldfusion.util.RB;
import coldfusion.util.Utils;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class JaxRsServiceImpl
extends ServiceBase
implements JaxRsService {
    private File file;
    private ServletContext context = null;
    private String restPath;
    private FastHashtable restServices = new FastHashtable();
    private ConfigMap mappings = null;
    private String defaultApp;
    private boolean isSecureProfile;

    public JaxRsServiceImpl(File f, ServletContext context) {
        this.file = f;
        this.context = context;
        this.setEnableWatch(true);
        this.setWatchFile(this.file);
    }

    @Override
    public String getDefaultApp() {
        return this.defaultApp;
    }

    @Override
    public FastHashtable getRestServices() {
        return this.restServices;
    }

    @Override
    public ConfigMap getMappings() {
        return this.mappings;
    }

    @Override
    public synchronized void unregisterApplication(String apppath) {
        try {
            apppath = this.getFullPath(apppath, false);
        }
        catch (IOException e) {
            throw new ServiceRuntimeException(e);
        }
        AppNameRootPair remove = (AppNameRootPair)this.restServices.get(apppath);
        if (remove != null) {
            String cfAppName;
            CFRestServlet.getCFRestServlet().deleteRestApplication(remove);
            this.mappings.remove(apppath);
            this.restServices.remove(apppath);
            if (apppath.equalsIgnoreCase(this.defaultApp)) {
                CFRestServlet.getCFRestServlet().deleteDefaultRestApplication(false);
                this.defaultApp = "";
            }
            try {
                this.store();
            }
            catch (ServiceException ex) {
                throw new ServiceRuntimeException(ex);
            }
            Map appSettings = remove.getAppSettings();
            if (appSettings != null && (cfAppName = (String)appSettings.get("name")) != null && cfAppName.length() > 0) {
                ApplicationScopeTracker.stopApplication(cfAppName);
            }
        } else {
            throw new DeleteRestAppException(apppath);
        }
    }

    @Override
    public synchronized void unregisterApplicationAppName(String appName) {
        Enumeration em = this.restServices.keys();
        while (em.hasMoreElements()) {
            String apppath = (String)em.nextElement();
            Object appInst = this.restServices.get(apppath);
            if (!(appInst instanceof AppNameRootPair) || !((AppNameRootPair)appInst).getAppName().equals(appName)) continue;
            AppNameRootPair remove = (AppNameRootPair)this.restServices.get(apppath);
            if (remove != null) {
                String cfAppName;
                CFRestServlet.getCFRestServlet().deleteRestApplication(remove);
                this.mappings.remove(apppath);
                this.restServices.remove(apppath);
                if (apppath.equalsIgnoreCase(this.defaultApp)) {
                    CFRestServlet.getCFRestServlet().deleteDefaultRestApplication(false);
                    this.defaultApp = "";
                }
                try {
                    this.store();
                }
                catch (ServiceException ex) {
                    throw new ServiceRuntimeException(ex);
                }
                Map appSettings = remove.getAppSettings();
                if (appSettings == null || (cfAppName = (String)appSettings.get("name")) == null || cfAppName.length() <= 0) break;
                ApplicationScopeTracker.stopApplication(cfAppName);
                break;
            }
            throw new DeleteRestAppException(apppath);
        }
    }

    @Override
    public synchronized void refreshApplication(String apppath) throws Exception {
        try {
            apppath = this.getFullPath(apppath);
        }
        catch (IOException e) {
            throw new ServiceRuntimeException(e);
        }
        AppNameRootPair pair = (AppNameRootPair)this.restServices.get(apppath);
        if (pair != null) {
            pair.setUnInitialized();
            RestAppAdapter.getAppKey(pair);
            try {
                CFRestServlet.getCFRestServlet().refreshRestApplication(pair);
                if (apppath.equalsIgnoreCase(this.defaultApp)) {
                    CFRestServlet.getCFRestServlet().refreshDefaultRestApplication(pair);
                }
            }
            catch (ServletException e) {
                throw new ServiceRuntimeException(e);
            }
        }
    }

    @Override
    public synchronized AppNameRootPair getAppNameRootPair(String serviceMapName) {
        Enumeration em = this.restServices.keys();
        AppNameRootPair pair = null;
        String apppath = "";
        while (em.hasMoreElements()) {
            apppath = (String)em.nextElement();
            Object appInst = this.restServices.get(apppath);
            if (!(appInst instanceof AppNameRootPair) || !((AppNameRootPair)appInst).getAppName().equals(serviceMapName)) continue;
            pair = (AppNameRootPair)this.restServices.get(apppath);
            return pair;
        }
        return null;
    }

    @Override
    public synchronized void refreshApplicationByName(String serviceMapName) throws Exception {
        AppNameRootPair pair = this.getAppNameRootPair(serviceMapName);
        if (pair != null) {
            pair.setUnInitialized();
            RestAppAdapter.getAppKey(pair);
            try {
                CFRestServlet.getCFRestServlet().refreshRestApplication(pair);
                if (pair.isDefaultApplication()) {
                    CFRestServlet.getCFRestServlet().refreshDefaultRestApplication(pair);
                }
            }
            catch (ServletException e) {
                throw new ServiceRuntimeException(e);
            }
        }
    }

    @Override
    public void registerApplication(String apppath, String mapping) throws Exception {
        this.updateApplication(apppath, apppath, mapping, true);
    }

    @Override
    public void registerApplication(String apppath, String mapping, boolean isDefault) throws Exception {
        this.updateApplication(apppath, apppath, mapping, true, isDefault);
    }

    @Override
    public void registerApplication(String apppath, String mapping, String host, boolean isDefault, boolean isnewRegisterAdmin) throws Exception {
        this.updateApplication(apppath, apppath, mapping, true, isDefault, false, host, false, isnewRegisterAdmin);
    }

    public synchronized void updateApplication(String oldAppPath, String appPath, String mapping) throws Exception {
        this.updateApplication(oldAppPath, appPath, mapping, false);
    }

    @Override
    public synchronized void updateApplication(String oldAppPath, String appPath, String mapping, boolean register, boolean defApp) throws Exception {
        this.updateApplication(oldAppPath, appPath, mapping, register, defApp, false);
    }

    public synchronized void updateApplication(String oldAppPath, String appPath, String mapping, boolean register, boolean defApp, boolean maintainDefault) throws Exception {
        this.updateApplication(oldAppPath, appPath, mapping, register, defApp, maintainDefault, null, false, false);
    }

    private synchronized void updateApplication(String oldAppPath, String appPath, String mapping, boolean register) throws Exception {
        this.updateApplication(oldAppPath, appPath, mapping, register, false);
    }

    @Override
    public void load() throws ServiceException {
        try {
            Vector v = (Vector)this.deserialize(this.file);
            this.defaultApp = (String)v.elementAt(0);
            this.mappings = (ConfigMap)v.elementAt(1);
            this.mappings.init(this, "mappings");
            this._initializeRestService();
        }
        catch (Exception ex) {
            throw new ServiceException(ex);
        }
    }

    private synchronized void _initializeRestService() throws Exception {
        boolean mappingsChanged = false;
        for (Object path : this.mappings.keySet()) {
            String appPath = (String)path;
            Vector appSettings = (Vector)this.mappings.get(path);
            String mapping = (String)appSettings.get(0);
            String hostName = (String)appSettings.get(1);
            Object isDefault = appSettings.get(2);
            try {
                appPath = this.getFullPath(appPath);
            }
            catch (Exception e) {
                CFLogs.RESTSERVICE_LOG.error(RB.getString((Object)this, "JaxRsServiceImpl.ErrorOnInitializing", new Object[]{mapping, e.getMessage()}), e);
            }
            if (!appPath.equals(path)) {
                this.mappings.remove(path);
                this.mappings.put(appPath, (Object)appSettings);
                mappingsChanged = true;
            }
            AppNameRootPair pair = new AppNameRootPair(mapping, appPath);
            if (null != hostName && hostName.length() > 0) {
                pair.setHost(hostName);
            }
            pair.setDefaultApplication(Cast._boolean(isDefault));
            this.restServices.put(appPath, (Object)pair);
        }
        if (mappingsChanged) {
            this.store();
        }
    }

    private String getFullPath(String appPath) throws IOException {
        return this.getFullPath(appPath, true);
    }

    private String getFullPath(String appPath, boolean throwException) throws IOException {
        File appFile;
        String fauxAppPath = appPath;
        if (ServerlessUtil.isLambdaEnv()) {
            fauxAppPath = ServerlessUtil.getLambdaWebRootPath(appPath);
        }
        if (fauxAppPath != null && (appFile = new File(fauxAppPath)).exists()) {
            return appFile.getCanonicalPath();
        }
        appFile = Utils.getCanonicalFile(ServiceFactory.getRuntimeService().getRealPath(this.context, appPath));
        if (appFile.exists()) {
            appPath = appFile.getCanonicalPath();
        } else if (throwException) {
            File errMsgPath = new File(appPath);
            if (errMsgPath.toString().contains("" + File.separatorChar)) {
                throw new FileDoesNotExistException(new File(appPath).toURI().toString());
            }
            throw new FileDoesNotExistException(new File(appPath).toString());
        }
        return appPath;
    }

    @Override
    public void store() throws ServiceException {
        Vector<Object> v = new Vector<Object>();
        v.addElement(this.defaultApp);
        v.addElement(this.mappings);
        this.serialize(v, this.file);
    }

    @Override
    public Map getResourceBundle() {
        if (this.rb == null) {
            this.rb = new HashMap();
            this.rb.put("mappings.keys", "");
            this.rb.put("mappings.types", "java.util.Vector");
            this.rb.put("mappings.formats", "coldfusion.server.MapFormatter");
        }
        return this.rb;
    }

    @Override
    public void updateRestPath(String restPathNew) throws Exception {
        this.setRestPath(restPathNew);
        this.store();
    }

    @Override
    public void updateApplication(String oldAppPath, String appPath, String mapping, boolean register, boolean defApp, boolean maintainDefault, String hostName, boolean isInvokedFmRestInit, boolean isnewRegisterAdmin) throws Exception {
        String string = hostName = hostName != null ? hostName : "";
        if (hostName.trim().length() > 0) {
            FeatureRouter.getInstance().allowFeature(EFRConstants.multi_host_support, null);
        }
        mapping = mapping != null ? mapping : "";
        try {
            appPath = this.getFullPath(appPath);
            oldAppPath = this.getFullPath(oldAppPath);
        }
        catch (IOException e) {
            throw new ServiceRuntimeException(e);
        }
        for (Object regDir : this.restServices.keySet()) {
            AppNameRootPair appNameRootPair;
            String strRegDir = (String)regDir;
            if (appPath.length() != strRegDir.length() && (JaxRsServiceImpl.isSubDirectory(strRegDir, appPath) || JaxRsServiceImpl.isSubDirectory(appPath, strRegDir)) && (appPath.length() == oldAppPath.length() || !appPath.startsWith(oldAppPath) && !oldAppPath.startsWith(appPath))) {
                throw new NestedRestAppException(new File((String)regDir).toURI().toString());
            }
            AppNameRootPair appNameRootPairWithUserSmp = this.getAppNameRootPair(mapping);
            String retrivedAppPath = null;
            if (appNameRootPairWithUserSmp != null) {
                retrivedAppPath = appNameRootPairWithUserSmp.getAppRoot().getCanonicalPath();
            }
            if (isnewRegisterAdmin && appNameRootPairWithUserSmp != null) {
                throw new CFRestServlet.DuplicateApplicationException(mapping);
            }
            if (register && isInvokedFmRestInit && retrivedAppPath != null && !retrivedAppPath.equals(appPath)) {
                throw new CFRestServlet.DuplicateApplicationException(mapping);
            }
            if (isInvokedFmRestInit && retrivedAppPath != null && !retrivedAppPath.equals(appPath)) {
                throw new CFRestServlet.DuplicateApplicationException(mapping);
            }
            if (!defApp || oldAppPath.equals(appPath) || !(appNameRootPair = (AppNameRootPair)this.restServices.get(regDir)).isDefaultApplication() || !appNameRootPair.getHost().equalsIgnoreCase(hostName)) continue;
            if (null == hostName || hostName.trim().length() == 0) {
                throw new CFRestServlet.MultipleDefaultApplicationException("default");
            }
            throw new CFRestServlet.MultipleDefaultApplicationException(hostName);
        }
        AppNameRootPair newPair = new AppNameRootPair(mapping, appPath);
        newPair.setHost(hostName);
        newPair.setDefaultApplication(defApp);
        AppNameRootPair oldPair = (AppNameRootPair)this.restServices.get(oldAppPath);
        if (maintainDefault && oldPair == null) {
            register = true;
        }
        oldPair = oldPair == null ? newPair : oldPair;
        CFRestServlet CFRestServlet2 = null;
        if ((CFRestServlet2 = CFRestServlet2.getCFRestServlet()) != null) {
            CFRestServlet2.refreshRestApplication(newPair, oldPair, register);
        }
        this.mappings.remove(oldAppPath);
        this.restServices.remove(oldAppPath);
        Vector<Object> restAppSettings = new Vector<Object>();
        restAppSettings.add(mapping);
        restAppSettings.add(hostName);
        restAppSettings.add(defApp);
        this.mappings.put(appPath, (Object)restAppSettings);
        this.restServices.put(appPath, (Object)newPair);
        if (defApp && (null == hostName || hostName.trim().length() == 0) || maintainDefault && oldAppPath.equalsIgnoreCase(this.defaultApp)) {
            if (CFRestServlet2 != null) {
                CFRestServlet2.refreshDefaultRestApplication(newPair);
            }
            this.defaultApp = appPath;
        } else if (oldAppPath.equalsIgnoreCase(this.defaultApp)) {
            if (CFRestServlet2 != null) {
                CFRestServlet2.deleteDefaultRestApplication(true);
            }
            this.defaultApp = "";
        }
        this.store();
    }

    static boolean isSubDirectory(String basePath, String childPath) {
        File base = new File(basePath);
        File child = new File(childPath);
        try {
            base = base.getCanonicalFile();
            child = child.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (File parentFile = child; parentFile != null; parentFile = parentFile.getParentFile()) {
            if (!base.equals(parentFile)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, String> getAllDefaultApps() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String restServicePath : this.restServices.keySet()) {
            AppNameRootPair pair = (AppNameRootPair)this.restServices.get(restServicePath);
            if (!pair.isDefaultApplication()) continue;
            result.put(restServicePath, pair.getHost());
        }
        return result;
    }

    @Override
    public String getRestPath() {
        return this.restPath;
    }

    public void setRestPath(String restPath) {
        this.restPath = restPath;
    }

    @Override
    public void registerServlets(ServletContext servletContext) {
        ServletRegistration.Dynamic restServlet = servletContext.addServlet("CFRestServlet", "coldfusion.bootstrap.BootstrapServlet");
        restServlet.setInitParameter("servlet.class", "coldfusion.rest.servlet.CFRestServlet");
        restServlet.setInitParameter("com.sun.jersey.spi.container.ContainerRequestFilters", "coldfusion.rest.servlet.CFUriConnegFilter;com.sun.jersey.api.container.filter.GZIPContentEncodingFilter;");
        restServlet.setInitParameter("com.sun.jersey.spi.container.ContainerResponseFilters", "coldfusion.rest.servlet.CFResponseFilter;com.sun.jersey.api.container.filter.GZIPContentEncodingFilter");
        restServlet.addMapping(new String[]{"/" + this.getRestPath() + "/*"});
        restServlet.addMapping(new String[]{"/restapps/*"});
        restServlet.addMapping(new String[]{"/cfapiresources/*"});
        FilterRegistration.Dynamic restServletMonitoringFilter = servletContext.addFilter("CFMonitoringFilter", "coldfusion.bootstrap.BootstrapFilter");
        if (restServletMonitoringFilter != null) {
            restServletMonitoringFilter.addMappingForServletNames(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"CFRestServlet"});
            restServletMonitoringFilter.setInitParameter("filter.class", "coldfusion.monitor.event.MonitoringServletFilter");
        }
    }

    public static class DeleteRestAppException
    extends ApplicationException {
        public String path;

        public DeleteRestAppException(String path) {
            this.path = path;
        }
    }

    public static class FileDoesNotExistException
    extends ApplicationException {
        public String path;

        public FileDoesNotExistException(String path) {
            this.path = path;
        }
    }

    public static class NestedRestAppException
    extends ApplicationException {
        public String path;

        public NestedRestAppException(String path) {
            this.path = path;
        }
    }
}

