/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rest;

import coldfusion.CfmServlet;
import coldfusion.cfc.DummyHttpServletRequest;
import coldfusion.cfc.DummyHttpServletResponse;
import coldfusion.filter.CfincludeFilter;
import coldfusion.filter.FusionContext;
import coldfusion.rest.RestInitThreadlocal;
import coldfusion.rest.core.AppNameRootPair;
import coldfusion.rest.servlet.CFRestServlet;
import coldfusion.runtime.AppEventInvoker;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Cast;
import coldfusion.runtime.Struct;
import coldfusion.util.Utils;
import coldfusion.xml.rpc.CFCServlet;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class RestAppAdapter {
    public static String getAppKey(AppNameRootPair root) {
        if (!root.isInitialized()) {
            RestAppAdapter.initialize(root);
        }
        return root.getAppKey();
    }

    public static String getAppName(AppNameRootPair root) {
        String appName = root.getAppName();
        if (appName == null && !root.isInitialized()) {
            RestAppAdapter.initialize(root);
            appName = root.getAppName();
        }
        return appName;
    }

    public static File[] getRestDirectory(AppNameRootPair root) {
        File[] path = root.getRestDirectory();
        if (path == null && !root.isInitialized()) {
            RestAppAdapter.initialize(root);
            path = root.getRestDirectory();
        }
        return path;
    }

    public static boolean getSkipCFCOnError(AppNameRootPair root) {
        Boolean skip = false;
        if (root != null && (skip = root.getSkipCFCOnError()) == null && !root.isInitialized()) {
            RestAppAdapter.initialize(root);
            skip = root.getSkipCFCOnError();
            if (skip == null) {
                skip = true;
            }
        }
        return skip;
    }

    private static void initialize(AppNameRootPair root) {
        String appName = root.getAppName();
        File appPath = root.getAppRoot();
        boolean isCFC = false;
        File applicationFile = RestAppAdapter.getApplicationFile(appPath);
        if (applicationFile != null) {
            if (!applicationFile.isFile()) {
                applicationFile = null;
            } else if (applicationFile.getPath().endsWith(".cfc")) {
                isCFC = true;
            }
        }
        Map appSettings = null;
        if (applicationFile != null) {
            String cfcPath = applicationFile.getPath();
            if (isCFC) {
                try {
                    appSettings = RestAppAdapter.getRestSetting(cfcPath);
                    root.setApplicationCFCLoc(cfcPath);
                    List directory = null;
                    Boolean skipCFCOnError = null;
                    Boolean generateRestDoc = null;
                    if (appSettings != null) {
                        appName = (String)appSettings.get("name");
                        directory = (List)appSettings.get("cfclocation");
                        Object skip = appSettings.get("skipcfcwitherror");
                        Object genrateDoc = appSettings.get("generateRestDoc");
                        generateRestDoc = genrateDoc == null ? true : Cast._boolean(genrateDoc);
                        skipCFCOnError = skip == null ? false : Cast._boolean(skip);
                        root.setGenrateRestDoc(generateRestDoc);
                        Map restDocInfo = (Map)appSettings.get("restDocInfo");
                        if (restDocInfo != null) {
                            root.setRestDocInfo(restDocInfo);
                        }
                    }
                    if (root.getAppName() == null && appName != null) {
                        root.setAppName(appName);
                    }
                    root.setAppSettings(appSettings);
                    if (directory != null) {
                        restDirectory = new File[directory.size()];
                        for (int i = 0; i < directory.size(); ++i) {
                            File file;
                            restDirectory[i] = file = new File((String)directory.get(i));
                        }
                        root.setRestDirectory(restDirectory);
                    } else {
                        restDirectory = new File[]{appPath};
                        root.setRestDirectory(restDirectory);
                    }
                    if (skipCFCOnError != null) {
                        root.setSkipCFCOnError(skipCFCOnError);
                    }
                    root.setSkipCFCOnError(false);
                }
                catch (CFRestServlet.RecursiveApplicationInitializationException e) {
                    throw e;
                }
                catch (Throwable e) {}
            } else {
                CfincludeFilter cfinclude = new CfincludeFilter();
                try {
                    FusionContext fusionContext = RestAppAdapter.getFusionContext(cfcPath);
                    cfinclude.include(cfcPath, fusionContext);
                    if (root.getAppName() == null) {
                        appName = fusionContext.getApplicationName();
                        root.setAppName(appName);
                    }
                    File[] restDirectory = new File[]{appPath};
                    root.setRestDirectory(restDirectory);
                    root.setSkipCFCOnError(false);
                }
                catch (Throwable throwable) {}
            }
        } else {
            root.setSkipCFCOnError(false);
            File[] restDirectory = new File[]{appPath};
            root.setRestDirectory(restDirectory);
            root.setGenrateRestDoc(true);
            root.setRestDocInfo(null);
        }
        root.setInitialized();
        if (root.getAppName() == null) {
            throw new InvalidApplicationException(root.getAppRoot().getPath());
        }
    }

    private static File getApplicationFile(File appPath) {
        if (appPath == null) {
            return null;
        }
        File applicationFile = new File(appPath, "Application.cfc");
        if (!applicationFile.isFile() && !(applicationFile = new File(appPath, "Application.cfm")).isFile()) {
            applicationFile = RestAppAdapter.getApplicationFile(appPath.getParentFile());
        }
        return applicationFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getRestSetting(String cfcPath) throws Throwable {
        Map result = null;
        FusionContext fusionContext = RestAppAdapter.getFusionContext(cfcPath);
        FusionContext oldFusionContext = FusionContext.setCurrent(fusionContext);
        List<String> initializingApplications = RestInitThreadlocal.getInitializingApplications();
        if (initializingApplications.contains(cfcPath.toLowerCase())) {
            throw new CFRestServlet.RecursiveApplicationInitializationException(cfcPath);
        }
        initializingApplications.add(cfcPath.toLowerCase());
        try {
            AppEventInvoker appProxy = new AppEventInvoker(cfcPath);
            Map thisScope = appProxy.getThisScope();
            result = (Map)thisScope.get("restsettings");
            if (result != null) {
                result.put("name", thisScope.get("name"));
                String cfcLoc = (String)result.get("cfclocation");
                if (cfcLoc != null) {
                    ArrayList<String> list = new ArrayList<String>();
                    StringTokenizer t = new StringTokenizer(cfcLoc, ",");
                    while (t.hasMoreTokens()) {
                        String nextToken = t.nextToken();
                        String loc = Utils.expandPath(nextToken, fusionContext.pageContext);
                        if (!new File(loc).exists()) {
                            loc = nextToken;
                        }
                        list.add(loc);
                    }
                    result.put("cfclocation", list);
                }
            } else {
                result = new Struct();
                result.put("name", thisScope.get("name"));
            }
        }
        finally {
            FusionContext.setCurrent(oldFusionContext);
            initializingApplications.remove(cfcPath.toLowerCase());
        }
        return result;
    }

    private static FusionContext getFusionContext(String cfcPath) {
        HttpServlet servlet;
        DummyHttpServletRequest req = null;
        DummyHttpServletResponse resp = null;
        FusionContext fusionContext = new FusionContext();
        fusionContext.setUseMappings(true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (req == null) {
            req = new DummyHttpServletRequest(cfcPath);
        }
        if (baos != null || resp == null) {
            resp = new DummyHttpServletResponse(baos);
        }
        if ((servlet = CFCServlet.getCFCServlet()) == null) {
            servlet = CfmServlet.getCfmServlet();
        }
        fusionContext.setServletObjects((Servlet)servlet, (ServletRequest)req, (ServletResponse)resp);
        fusionContext.setPagePath(cfcPath);
        try {
            fusionContext.SymTab_initForRequest(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return fusionContext;
    }

    public static class InvalidApplicationException
    extends ApplicationException {
        public String path;

        public InvalidApplicationException(String path) {
            this.path = path;
        }
    }
}

