/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rest.classloader;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.xml.rpc.BaseSkeletonClassLoader;
import coldfusion.xml.rpc.CFComponentSkeleton;
import coldfusion.xml.rpc.SkeletonClassLoader;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;

public class RestSkeletonClassLoader
extends BaseSkeletonClassLoader {
    private static final Logger logger = CFLogs.SERVER_LOG;
    private final String path;

    public RestSkeletonClassLoader(String outputdir, NeoPageContext pageContext, String path) {
        super(outputdir, pageContext, true);
        this.path = path;
    }

    public static Class<?> getAnnotatedClass(String cfcPath, TemplateProxy proxy, boolean skipCFC) throws Throwable {
        final String outputdir = RestSkeletonClassLoader.getOutputDirectory();
        AttributeCollection metadata = (AttributeCollection)proxy.getMetadata();
        final String cfcFullName = (String)metadata.get("name");
        final String path = RestSkeletonClassLoader.getPath(cfcPath, cfcFullName);
        try {
            Class<?> loadClass = null;
            if (System.getSecurityManager() == null) {
                RestSkeletonClassLoader loader = new RestSkeletonClassLoader(outputdir, FusionContext.getCurrent().pageContext, path);
                loadClass = loader.loadClass(cfcFullName, true);
            } else {
                loadClass = (Class<?>)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        RestSkeletonClassLoader loader = new RestSkeletonClassLoader(outputdir, FusionContext.getCurrent().pageContext, path);
                        return loader.loadClass(cfcFullName, true);
                    }
                });
            }
            return loadClass;
        }
        catch (Exception e) {
            if (!skipCFC) {
                throw e.getCause();
            }
            logger.error(e);
            return null;
        }
    }

    private static String getPath(String cfcPath, String cfcFullName) {
        cfcFullName = ((String)cfcFullName).replaceAll("\\.", "/");
        cfcFullName = (String)cfcFullName + ".cfc";
        int indexOf = (cfcPath = cfcPath.replaceAll("\\\\", "/")).indexOf((String)cfcFullName);
        if (-1 != indexOf) {
            String path = cfcPath.substring(0, indexOf);
            return path;
        }
        return null;
    }

    private static String getOutputDirectory() {
        return (String)FusionContext.getCurrent().pageContext.getServletContext().getAttribute("coldfusion.rest.servlet.CFRestServlet.outputdir");
    }

    public static CFComponentSkeleton newInstance(String path, NeoPageContext pageContext) throws Throwable {
        return SkeletonClassLoader.newInstance(path, pageContext, null, new RestSkeletonClassLoader(RestSkeletonClassLoader.getOutputDirectory(), FusionContext.getCurrent().pageContext, path), null);
    }

    public static CFComponentSkeleton newInstance(String path, NeoPageContext pageContext, TemplateProxy proxy) throws Throwable {
        return SkeletonClassLoader.newInstance(path, pageContext, null, new RestSkeletonClassLoader(RestSkeletonClassLoader.getOutputDirectory(), FusionContext.getCurrent().pageContext, path), proxy);
    }

    @Override
    protected Class findClass(String className) throws ClassNotFoundException {
        Class findClass = super.findClass(className);
        findClass.getMethods();
        return findClass;
    }

    @Override
    protected void updateSkeletonMetadata(AttributeCollection metadata, Class clazz) {
        metadata.put("restskeleton", (Object)clazz);
    }

    @Override
    protected Class getSkeletonMetadata(AttributeCollection metadata) {
        return (Class)metadata.get("restskeleton");
    }

    @Override
    protected TemplateProxy resolveProxy(String className, NeoPageContext pageContext) throws Throwable {
        TemplateProxy proxy = null;
        try {
            proxy = super.resolveProxy(className, pageContext);
        }
        catch (Exception e) {
            if (null != this.path) {
                String cfcPath = this.path + className.replaceAll("\\.", "/") + ".cfc";
                proxy = TemplateProxyFactory.resolveFile(FusionContext.getCurrent().pageContext, new File(cfcPath));
            }
            throw e;
        }
        return proxy;
    }

    static {
        boolean bl = RestSkeletonClassLoader.registerAsParallelCapable();
    }
}

