/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rest.component;

import coldfusion.filter.EndFilter;
import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.filter.PathFilter;
import coldfusion.rest.classloader.RestSkeletonClassLoader;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.xml.rpc.CFComponentSkeleton;
import coldfusion.xml.rpc.FilePath;
import jakarta.ws.rs.ext.Provider;
import java.io.File;
import java.util.Set;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.binding.BindingBuilder;
import org.glassfish.hk2.utilities.binding.BindingBuilderFactory;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.server.spi.ComponentProvider;

@Provider
public class CFComponentProvider
implements ComponentProvider {
    private ServiceLocator locator;
    private InjectionManager injectionManager;

    private Object getInstance(Class<?> annotatedCFCClass) {
        FilePath filePath = annotatedCFCClass.getAnnotation(FilePath.class);
        String path = filePath.value();
        FusionContext fusionContext = FusionContext.getCurrent();
        boolean useMap = true;
        useMap = fusionContext.setUseMappings(useMap);
        try {
            ClassLoader restAppClassLoader;
            this.getFilterChain(path).invoke(FusionContext.getCurrent());
            TemplateProxy proxy = TemplateProxyFactory.resolveFile(FusionContext.getCurrent().pageContext, new File(path));
            AttributeCollection metadata = (AttributeCollection)proxy.getMetadata();
            Object name = (String)metadata.get("name");
            name = "/" + ((String)name).replace('.', '/') + ".cfc";
            Object jerseyResourceInstance = annotatedCFCClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (jerseyResourceInstance instanceof CFComponentSkeleton) {
                CFComponentSkeleton cfCompSkel = (CFComponentSkeleton)CFComponentSkeleton.class.cast(jerseyResourceInstance);
                cfCompSkel.__setTemplateProxy(proxy);
                cfCompSkel.__setPageContext(FusionContext.getCurrent().pageContext);
                Object obj = jerseyResourceInstance;
                return obj;
            }
            CFComponentSkeleton newInstance = RestSkeletonClassLoader.newInstance((String)name, FusionContext.getCurrent().pageContext, proxy);
            ClassLoader newInstanceLoader = newInstance.getClass().getClassLoader();
            if (newInstanceLoader != (restAppClassLoader = annotatedCFCClass.getClassLoader())) {
                String serviceName = fusionContext.getRestServiceName();
                if ("_cf__default_".equalsIgnoreCase(serviceName)) {
                    serviceName = "Default";
                }
                throw new ModifiedResourceException(serviceName);
            }
            CFComponentSkeleton cFComponentSkeleton = newInstance;
            return cFComponentSkeleton;
        }
        catch (ModifiedResourceException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ResourceNotCreatedException(annotatedCFCClass.getName(), e);
        }
        finally {
            fusionContext.setUseMappings(useMap);
        }
    }

    private FusionFilter getFilterChain(String calledPagePath) {
        FusionFilter filter = new EndFilter();
        filter = new PathFilter(filter, calledPagePath);
        return filter;
    }

    public boolean bind(final Class<?> arg0, Set<Class<?>> arg1) {
        if (arg0.getAnnotation(FilePath.class) != null) {
            DynamicConfiguration dynConfig = ((DynamicConfigurationService)this.injectionManager.getInstance(DynamicConfigurationService.class)).createDynamicConfiguration();
            BindingBuilderFactory.addBinding((BindingBuilder)BindingBuilderFactory.newFactoryBinder((Factory)new Factory(){
                private Class<?> annotatedCFCClass;
                {
                    this.annotatedCFCClass = arg0;
                }

                public void dispose(Object arg02) {
                }

                public Object provide() {
                    return CFComponentProvider.this.getInstance(this.annotatedCFCClass);
                }
            }).to(arg0), (DynamicConfiguration)dynConfig);
            dynConfig.commit();
            return true;
        }
        return false;
    }

    public void done() {
    }

    public void initialize(InjectionManager injectionManager) {
        this.injectionManager = injectionManager;
    }

    public static class ModifiedResourceException
    extends ApplicationException {
        public String service;

        public ModifiedResourceException(String service) {
            this.service = service;
        }
    }

    public static class ResourceNotCreatedException
    extends ApplicationException {
        public String name;
        public String message;

        public ResourceNotCreatedException(String name, Throwable t) {
            super(t);
            this.name = name;
            this.message = t.getLocalizedMessage();
        }
    }

    public static class ResourceNotFoundException
    extends ApplicationException {
        public String name;

        public ResourceNotFoundException(String name) {
            this.name = name;
        }
    }
}

