/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rest.method.dispatch;

import coldfusion.filter.ApplicationFilter;
import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.filter.MonitoringFilter;
import coldfusion.filter.RequestMonitorFilter;
import coldfusion.rest.method.dispatch.CFExecutionFilter;
import coldfusion.rest.method.dispatch.CFRestException;
import coldfusion.rest.utils.CFResponseBuilder;
import coldfusion.runtime.Cast;
import coldfusion.xml.rpc.CFComponentSkeleton;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.InvocationHandler;
import java.util.List;
import java.util.Map;
import org.glassfish.jersey.internal.util.collection.StringKeyIgnoreCaseMultivaluedMap;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.spi.internal.ParamValueFactoryWithSource;
import org.glassfish.jersey.server.spi.internal.ParameterValueHelper;
import org.glassfish.jersey.server.spi.internal.ResourceMethodDispatcher;

public class CFInvoker
implements ResourceMethodDispatcher {
    private final List<ParamValueFactoryWithSource<?>> pp;
    Invocable invocable;
    InvocationHandler invocationHandler;

    public CFInvoker(Invocable invocable, InvocationHandler invocationHandler, List<ParamValueFactoryWithSource<?>> pp) {
        this.invocable = invocable;
        this.invocationHandler = invocationHandler;
        this.pp = pp;
    }

    public Response dispatch(Object resource, ContainerRequest request) throws ProcessingException {
        try {
            Object[] params = ParameterValueHelper.getParameterValues(this.pp, (ContainerRequest)request);
            if (MediaTypes.typeEqual((MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE, (MediaType)request.getMediaType())) {
                String propName = null;
                if (request.getProperty("jersey.config.server.representation.decoded.form") != null) {
                    propName = "jersey.config.server.representation.decoded.form";
                } else if (request.getProperty("jersey.config.server.representation.form") != null) {
                    propName = "jersey.config.server.representation.form";
                }
                if (propName != null) {
                    Form form = (Form)request.getProperty(propName);
                    StringKeyIgnoreCaseMultivaluedMap caseInsensitiveParameters = new StringKeyIgnoreCaseMultivaluedMap();
                    caseInsensitiveParameters.putAll((Map)form.asMap());
                    request.setProperty(propName, (Object)new Form((MultivaluedMap)caseInsensitiveParameters));
                }
                params = ParameterValueHelper.getParameterValues(this.pp, (ContainerRequest)request);
            }
            this.getFilterChain(resource, params).invoke(FusionContext.getCurrent());
        }
        catch (WebApplicationException e1) {
            throw e1;
        }
        catch (Throwable e) {
            CFRestException.handleException(this.invocable.getDefinitionMethod().getDeclaredAnnotations(), request, e);
        }
        Object customResponse = FusionContext.getCurrent().getRestCustomResponse();
        if (FusionContext.getCurrent().isCustomRestResponse() && null != customResponse) {
            return CFResponseBuilder.buildResponse((Map)customResponse);
        }
        if (null != customResponse) {
            if (customResponse instanceof Response) {
                return (Response)Response.class.cast(customResponse);
            }
            return Response.ok().entity(customResponse).build();
        }
        return Response.noContent().build();
    }

    private FusionFilter getFilterChain(Object resource, Object[] params) {
        FusionFilter filter = new CFExecutionFilter(resource, params, this.invocationHandler, this.invocable.getDefinitionMethod());
        if (resource instanceof CFComponentSkeleton) {
            filter = new ApplicationFilter(filter, 1, resource, this.invocable.getDefinitionMethod(), params);
            if (RequestMonitorFilter.isFilterEnabled()) {
                filter = new RequestMonitorFilter(filter);
            }
            filter = new MonitoringFilter(filter, "WEB SERVICE REQUEST");
        }
        return filter;
    }

    protected int getErrorStatusCodeFromResponse(Object customResponse) {
        Object statusObj;
        if (customResponse instanceof Map && (statusObj = ((Map)customResponse).get("STATUS")) != null) {
            try {
                return Cast._int(statusObj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 200;
    }
}

