/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rest.provider;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Map;
import java.util.function.Function;
import org.glassfish.jersey.internal.inject.ExtractorException;
import org.glassfish.jersey.internal.util.collection.StringKeyIgnoreCaseMultivaluedMap;
import org.glassfish.jersey.model.Parameter;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ParamException;
import org.glassfish.jersey.server.internal.inject.AbstractValueParamProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.model.Parameter;

@Singleton
public final class CFCookieParamValueParamProvider
extends AbstractValueParamProvider {
    @Inject
    public CFCookieParamValueParamProvider(Provider<MultivaluedParameterExtractorProvider> mpep) {
        super(mpep, new Parameter.Source[]{Parameter.Source.COOKIE});
    }

    public Function<ContainerRequest, ?> createValueProvider(Parameter parameter) {
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        if (parameter.getRawType() == Cookie.class) {
            return new CookieTypeParamValueProvider(parameterName);
        }
        MultivaluedParameterExtractor e = this.get(parameter);
        if (e == null) {
            return null;
        }
        return new CookieParamValueProvider(e);
    }

    private static final class CookieTypeParamValueProvider
    implements Function<ContainerRequest, Cookie> {
        private final String name;

        CookieTypeParamValueProvider(String name) {
            this.name = name;
        }

        @Override
        public Cookie apply(ContainerRequest containerRequest) {
            return (Cookie)containerRequest.getCookies().get(this.name);
        }
    }

    private static final class CookieParamValueProvider
    implements Function<ContainerRequest, Object> {
        private final MultivaluedParameterExtractor<?> extractor;

        CookieParamValueProvider(MultivaluedParameterExtractor<?> extractor) {
            this.extractor = extractor;
        }

        @Override
        public Object apply(ContainerRequest containerRequest) {
            StringKeyIgnoreCaseMultivaluedMap cookies = new StringKeyIgnoreCaseMultivaluedMap();
            for (Map.Entry e : containerRequest.getCookies().entrySet()) {
                cookies.putSingle((Object)((String)e.getKey()), (Object)((Cookie)e.getValue()).getValue());
            }
            try {
                return this.extractor.extract((MultivaluedMap)cookies);
            }
            catch (ExtractorException ex) {
                throw new ParamException.CookieParamException(ex.getCause(), this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }
    }
}

