/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rest.provider;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.rest.method.dispatch.CFRestException;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CustomException;
import coldfusion.xml.rpc.CFCInvocationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.util.HashMap;
import java.util.Map;

@Provider
public class CFExceptionMapper
implements ExceptionMapper<CFRestException> {
    private static final Logger logger = CFLogs.SERVER_LOG;

    public Response toResponse(CFRestException cause) {
        logger.error((Throwable)((Object)cause));
        HashMap<String, String> responseContent = new HashMap<String, String>();
        Throwable baseCause = cause.getCause();
        if (baseCause instanceof CFCInvocationException) {
            Throwable rootCause = ((CFCInvocationException)baseCause).getCause();
            if (rootCause instanceof CustomException) {
                return this.handleCustomException(responseContent, rootCause);
            }
            return this.generateResponse(responseContent, rootCause);
        }
        if (baseCause instanceof CustomException) {
            return this.handleCustomException(responseContent, baseCause);
        }
        return this.generateResponse(responseContent, baseCause);
    }

    private Response handleCustomException(Map<String, String> responseContent, Throwable rootCause) {
        String extendedInfo;
        String detail;
        String type;
        String message;
        CustomException root = (CustomException)rootCause;
        int status = 500;
        String errorCode = root.getErrorCode();
        if (null != errorCode && errorCode.trim().length() > 0) {
            try {
                status = Cast._int(errorCode);
            }
            catch (Cast.NumberConversionException e) {
                throw new CFPage.InvalidHTTPStatusException((Object)errorCode);
            }
        }
        if (null != (message = root.getMessage()) && message.trim().length() > 0) {
            responseContent.put("Message", message);
        }
        if (null != (type = root.getType()) && type.trim().length() > 0) {
            responseContent.put("Type", type);
        }
        if (null != (detail = root.getDetail()) && detail.trim().length() > 0) {
            responseContent.put("Detail", detail);
        }
        if (null != (extendedInfo = root.getExtendedInfo()) && extendedInfo.trim().length() > 0) {
            responseContent.put("ExtendedInfo", extendedInfo);
        }
        Response.ResponseBuilder resBuilder = Response.status((int)status);
        resBuilder.entity(responseContent);
        Response response = resBuilder.build();
        return response;
    }

    private Response generateResponse(Map<String, String> responseContent, Throwable baseCause) {
        Response.ResponseBuilder resBuilder = Response.status((int)500);
        responseContent.put("Message", baseCause.getMessage());
        resBuilder.entity(responseContent);
        Response response = resBuilder.build();
        return response;
    }
}

