/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rest.provider;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.MultivaluedMap;
import java.net.URI;
import java.util.Map;
import java.util.function.Function;
import org.glassfish.jersey.internal.inject.ExtractorException;
import org.glassfish.jersey.internal.util.collection.StringKeyIgnoreCaseMultivaluedMap;
import org.glassfish.jersey.model.Parameter;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ParamException;
import org.glassfish.jersey.server.internal.inject.AbstractValueParamProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.uri.UriComponent;

@Singleton
public final class CFQueryParamValueParamProvider
extends AbstractValueParamProvider {
    @Inject
    public CFQueryParamValueParamProvider(Provider<MultivaluedParameterExtractorProvider> mpep) {
        super(mpep, new Parameter.Source[]{Parameter.Source.QUERY});
    }

    public Function<ContainerRequest, ?> createValueProvider(Parameter parameter) {
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        MultivaluedParameterExtractor e = this.get(parameter);
        if (e == null) {
            return null;
        }
        return new QueryParamValueProvider(e, !parameter.isEncoded());
    }

    private static final class QueryParamValueProvider
    implements Function<ContainerRequest, Object> {
        private final MultivaluedParameterExtractor<?> extractor;
        private final boolean decode;

        QueryParamValueProvider(MultivaluedParameterExtractor<?> extractor, boolean decode) {
            this.extractor = extractor;
            this.decode = decode;
        }

        @Override
        public Object apply(ContainerRequest containerRequest) {
            try {
                StringKeyIgnoreCaseMultivaluedMap queryParameters = new StringKeyIgnoreCaseMultivaluedMap();
                MultivaluedMap caseSensitiveParameters = UriComponent.decodeQuery((URI)containerRequest.getUriInfo().getRequestUri(), (boolean)true);
                queryParameters.putAll((Map)caseSensitiveParameters);
                return this.extractor.extract((MultivaluedMap)queryParameters);
            }
            catch (ExtractorException e) {
                throw new ParamException.QueryParamException(e.getCause(), this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }
    }
}

