/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rest.provider;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;

@Provider
public class CFWebApplicationExceptionMapper
implements ExceptionMapper<WebApplicationException> {
    private static final Logger logger = CFLogs.SERVER_LOG;
    @Context
    HttpServletRequest request;

    public Response toResponse(WebApplicationException cause) {
        return CFWebApplicationExceptionMapper.buildResponse(cause, this.request);
    }

    public static Response buildResponse(WebApplicationException cause, HttpServletRequest httpServletRequest) {
        logger.error(cause);
        Response response = cause.getResponse();
        Response.ResponseBuilder builder = Response.fromResponse((Response)response);
        int statusCode = response.getStatus();
        Response.Status status = Response.Status.fromStatusCode((int)statusCode);
        if (null == status) {
            if (405 == statusCode) {
                builder.entity((Object)"Method Not Allowed");
            } else {
                builder.entity((Object)("HTTP Status Code : " + statusCode));
            }
        } else {
            builder.entity((Object)status.getReasonPhrase());
            if (cause instanceof NotFoundException) {
                String acceptHeader = httpServletRequest.getHeader("accept");
                if (httpServletRequest.getPathInfo().toUpperCase().endsWith(".JSON") || acceptHeader != null && (acceptHeader.contains("application/json") || acceptHeader.contains("application/javascript") || acceptHeader.contains("text/json"))) {
                    Object json = "{\"status\":404}";
                    json = "{\"MESSAGE\":\"" + status.getReasonPhrase() + "\",\"STATUS\": " + status.getStatusCode() + "}";
                    builder.entity(json);
                    builder.header("Content-Type", (Object)"application/json");
                } else {
                    String restXmlMessage = "<REST><MESSAGE>" + status.getReasonPhrase() + "</MESSAGE><STATUS>" + status.getStatusCode() + "</STATUS></REST>";
                    builder.entity((Object)restXmlMessage);
                    builder.header("Content-Type", (Object)"application/xml");
                }
            }
        }
        return builder.build();
    }
}

