/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rest.scanning;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.rest.core.AppNameRootPair;
import coldfusion.rest.provider.CFCookieParamValueParamProvider;
import coldfusion.rest.provider.CFMatrixParamValueParamProvider;
import coldfusion.rest.provider.CFObjectProvider;
import coldfusion.rest.provider.CFQueryParamValueParamProvider;
import coldfusion.rest.provider.CFRequestFilter;
import coldfusion.rest.provider.CFRestAllExceptionMapper;
import coldfusion.rest.provider.CFRestPatchDynamicFeature;
import coldfusion.rest.scanning.CFRestResourceScannerListener;
import coldfusion.rest.scanning.CFScanner;
import coldfusion.rest.servlet.CFResponseFilter;
import coldfusion.rest.swagger.CFSwaggerApiCreator;
import coldfusion.rest.swagger.SwaggerProviderService;
import coldfusion.runtime.ApplicationException;
import coldfusion.util.RB;
import com.smartbear.swagger4j.ApiDeclaration;
import com.smartbear.swagger4j.Swagger;
import com.smartbear.swagger4j.SwaggerFactory;
import jakarta.inject.Singleton;
import jakarta.servlet.ServletContext;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.ext.Provider;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.message.GZipEncoder;
import org.glassfish.jersey.message.filtering.SelectableEntityFilteringFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.UriConnegFilter;
import org.glassfish.jersey.server.spi.internal.ValueParamProvider;

public class CFResourceConfig
extends ResourceConfig {
    private static final Logger LOGGER = CFLogs.RESTSERVICE_LOG;
    private final Set<Class<?>> cachedClasses = new HashSet();
    private CFScanner scanner;
    private final ServletContext serv;
    private String[] applicationRoot;
    private boolean skipCFC;
    private final AppNameRootPair appNameRootPair;
    private String selectParam = "select";

    public String getSelectParam() {
        return this.selectParam;
    }

    public void setSelectParam(String selectParam) {
        this.selectParam = selectParam;
    }

    public CFResourceConfig(File[] applicationRoot, ServletContext servletContext, boolean skipCFC, AppNameRootPair appNameRootPair) {
        this.serv = servletContext;
        this.skipCFC = skipCFC;
        this.applicationRoot = new String[applicationRoot.length];
        this.appNameRootPair = appNameRootPair;
        for (int i = 0; i < applicationRoot.length; ++i) {
            try {
                this.applicationRoot[i] = applicationRoot[i].getCanonicalPath();
                continue;
            }
            catch (IOException e) {
                this.applicationRoot[i] = applicationRoot[i].getAbsolutePath();
            }
        }
        this.init(applicationRoot, skipCFC);
        this.register(CFRequestFilter.class);
        this.register(CFRestPatchDynamicFeature.class);
        this.register(new AbstractBinder(){

            protected void configure() {
                ((ClassBinding)((ClassBinding)this.bind(CFQueryParamValueParamProvider.class).to(ValueParamProvider.class)).in(Singleton.class)).ranked(2000);
                ((ClassBinding)((ClassBinding)this.bind(CFCookieParamValueParamProvider.class).to(ValueParamProvider.class)).in(Singleton.class)).ranked(1999);
                ((ClassBinding)((ClassBinding)this.bind(CFMatrixParamValueParamProvider.class).to(ValueParamProvider.class)).in(Singleton.class)).ranked(1998);
            }
        });
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
        if (null == this.getProperties()) {
            properties.putAll(this.getProperties());
        }
        properties.put("jersey.config.server.response.setStatusOverSendError", true);
        this.setProperties(properties);
    }

    private void init(File[] applicationRoot, boolean skipCFC) {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder b = new StringBuilder();
            StringBuilder appRoots = new StringBuilder();
            for (int i = 0; i < this.applicationRoot.length; ++i) {
                appRoots.append(this.applicationRoot[i]);
            }
            b.append(RB.getString((Object)this, "CFResourceConfig.ScanningInApplication", new Object[]{appRoots.toString()}));
            LOGGER.debug(b.toString());
        }
        this.init(new CFScanner(applicationRoot, skipCFC));
    }

    public void init(CFScanner scanner) {
        this.scanner = scanner;
        SwaggerFactory factory = AccessController.doPrivileged(new PrivilegedAction<SwaggerFactory>(){

            @Override
            public SwaggerFactory run() {
                return Swagger.createSwaggerFactory();
            }
        });
        CFRestResourceScannerListener scannerListener = new CFRestResourceScannerListener(this.serv, this.applicationRoot, this.skipCFC, factory, this.appNameRootPair);
        scanner.scan(scannerListener);
        this.registerClasses(scannerListener.getAnnotatedClasses());
        this.register(SelectableEntityFilteringFeature.class);
        this.register(JacksonFeature.class);
        this.property("jersey.config.entityFiltering.selectable.query", this.getSelectParam());
        this.registerClasses(this.getDefaultProviderClasses());
        Set<Class> rootResourceClasses = this.get(Path.class);
        if (rootResourceClasses.isEmpty()) {
            LOGGER.error(RB.getString((Object)this, "CFResourceConfig.NoRoortResourcesFound"));
            throw new CFRestScanException();
        }
        if (LOGGER.isDebugEnabled() && !this.getClasses().isEmpty()) {
            this.logClasses(RB.getString((Object)this, "CFResourceConfig.RootResourcesFound"), rootResourceClasses);
            Set<Class> providerClasses = this.get(Provider.class);
            if (providerClasses.isEmpty()) {
                LOGGER.debug(RB.getString((Object)this, "CFResourceConfig.NoProviderClassesFound"));
            } else {
                this.logClasses(RB.getString((Object)this, "CFResourceConfig.ProviderClassesFound"), providerClasses);
            }
        }
        if (this.appNameRootPair.isGenrateRestDoc()) {
            this.registerClasses(new Class[]{SwaggerProviderService.class});
            List<ApiDeclaration> apiDeclerations = scannerListener.getApiDeclerations();
            if (apiDeclerations != null && !apiDeclerations.isEmpty()) {
                CFSwaggerApiCreator swaggerApiCreator = new CFSwaggerApiCreator();
                swaggerApiCreator.createResourceListing(this.serv, factory, this.appNameRootPair, apiDeclerations);
            }
        }
        this.cachedClasses.clear();
        this.cachedClasses.addAll(this.getClasses());
    }

    private Set<Class<?>> getDefaultProviderClasses() {
        HashSet providerClasses = new HashSet();
        providerClasses.add(CFResponseFilter.class);
        providerClasses.add(UriConnegFilter.class);
        providerClasses.add(CFObjectProvider.class);
        providerClasses.add(CFRestAllExceptionMapper.class);
        providerClasses.add(GZipEncoder.class);
        return providerClasses;
    }

    public void onReload() {
        HashSet<Class> classesToRemove = new HashSet<Class>();
        HashSet<Class> classesToAdd = new HashSet<Class>();
        for (Class clazz : this.getClasses()) {
            if (this.cachedClasses.contains(clazz)) continue;
            classesToAdd.add(clazz);
        }
        for (Class clazz : this.cachedClasses) {
            if (this.getClasses().contains(clazz)) continue;
            classesToRemove.add(clazz);
        }
        this.getClasses().clear();
        this.init(this.scanner);
        this.getClasses().addAll(classesToAdd);
        this.getClasses().removeAll(classesToRemove);
    }

    private Set<Class> get(Class<? extends Annotation> ac) {
        HashSet<Class> s = new HashSet<Class>();
        for (Class c : this.getClasses()) {
            if (c == null || !c.isAnnotationPresent(ac)) continue;
            s.add(c);
        }
        return s;
    }

    private void logClasses(String s, Set<Class> classes) {
        StringBuilder b = new StringBuilder();
        b.append(s);
        for (Class c : classes) {
            b.append('\n').append("  ").append(c);
        }
        LOGGER.debug(b.toString());
    }

    public static class CFRestScanException
    extends ApplicationException {
    }
}

