/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rest.servlet;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.rest.utils.CFResponseBuilder;
import coldfusion.runtime.RuntimeServiceImpl;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.server.ContainerRequest;

public class CFResponseFilter
implements ContainerResponseFilter {
    private static final Logger logger = CFLogs.SERVER_LOG;
    private static MediaType wadlMediaType = new MediaType("application", "vnd.sun.wadl+xml");

    public void filter(ContainerRequestContext request, ContainerResponseContext response) throws IOException {
        Map params;
        this.customInvokerfilterStart(request, response);
        Object contentTypeHeader = response.getHeaders().getFirst((Object)"Content-Type");
        MediaType contentType = null;
        if (null != contentTypeHeader) {
            contentType = contentTypeHeader instanceof MediaType ? (MediaType)contentTypeHeader : MediaType.valueOf((String)contentTypeHeader.toString());
        }
        if (contentType == null && ((ContainerRequest)request).getRequestHeader("Accept") == null) {
            contentType = MediaType.TEXT_PLAIN_TYPE;
            response.getHeaders().add((Object)"Content-Type", (Object)contentType);
        }
        String charset = null;
        if (null != contentType && null == (charset = (String)(params = contentType.getParameters()).get("charset"))) {
            List acceptMediaTypes;
            List acceptTypes = ((ContainerRequest)request).getRequestHeader("Accept");
            if (null != acceptTypes && null != (acceptMediaTypes = MediaTypes.createFrom((String[])acceptTypes.toArray(new String[0])))) {
                MediaType type;
                Iterator iterator = acceptMediaTypes.iterator();
                while (iterator.hasNext() && null == (charset = (String)(params = (type = (MediaType)iterator.next()).getParameters()).get("charset"))) {
                }
            }
            if (null == charset) {
                charset = RuntimeServiceImpl.getDefaultCharset();
            }
            contentType = contentType.withCharset(charset);
            response.getHeaders().putSingle((Object)"Content-Type", (Object)contentType.toString());
        }
        if (wadlMediaType.equals((Object)contentType) && response.getEntity() instanceof byte[]) {
            try {
                response.setEntity((Object)new String((byte[])response.getEntity(), charset));
            }
            catch (UnsupportedEncodingException e) {
                response.setEntity((Object)new String((byte[])response.getEntity()));
            }
        }
        this.customInvokerfilterEnd(request, response);
    }

    private void customInvokerfilterStart(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
        logger.debug("intercepted response here -------------");
        FusionContext fusionCtx = FusionContext.getCurrent();
        if (!fusionCtx.isCustomRestResponse() && fusionCtx.getRestCustomResponse() == null) {
            fusionCtx.setRestCustomResponse(containerResponseContext.getEntity());
        }
    }

    private void customInvokerfilterEnd(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
        Object customResponse = FusionContext.getCurrent().getRestCustomResponse();
        if (FusionContext.getCurrent().isCustomRestResponse() && null != customResponse) {
            Response response = CFResponseBuilder.buildResponse((Map)customResponse);
            containerResponseContext.setEntity(response.getEntity());
            MultivaluedMap responseHeaders = response.getHeaders();
            for (Map.Entry entry : responseHeaders.entrySet()) {
                containerResponseContext.getHeaders().put((Object)((String)entry.getKey()), (Object)((List)entry.getValue()));
            }
            containerResponseContext.setStatus(response.getStatus());
        } else if (null != customResponse) {
            if (customResponse instanceof Response) {
                containerResponseContext.setEntity(((Response)customResponse).getEntity());
                containerResponseContext.setStatus(((Response)customResponse).getStatus());
            } else if (containerResponseContext.getEntity() != null && containerResponseContext.getStatus() >= 400) {
                logger.debug("returning from response filter as it is already set");
            } else {
                containerResponseContext.setEntity(customResponse);
                containerResponseContext.setStatus(Response.Status.OK.getStatusCode());
            }
        } else {
            containerResponseContext.setEntity(null);
            containerResponseContext.setStatus(Response.Status.NO_CONTENT.getStatusCode());
        }
    }
}

