/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rest.servlet;

import coldfusion.compiler.ParseException;
import coldfusion.filter.ClientScopePersistenceFilter;
import coldfusion.filter.DatasourceFilter;
import coldfusion.filter.ExceptionFilter;
import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.filter.GlobalsFilter;
import coldfusion.filter.LicenseFilter;
import coldfusion.license.LicenseManager;
import coldfusion.log.CFLogs;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.rest.RestAppAdapter;
import coldfusion.rest.RestLogHandler;
import coldfusion.rest.core.AppNameRootPair;
import coldfusion.rest.servlet.CFRestServletContainer;
import coldfusion.rest.servlet.RestFilter;
import coldfusion.rest.servlet.RestWrapRequestFilter;
import coldfusion.rest.utils.RESTPathUpdate;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.CFRestHTTPException;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.RequestLifecycleListener;
import coldfusion.runtime.ServletConfigWrapper;
import coldfusion.runtime.TemplateClassLoader;
import coldfusion.security.ESAPIUtils;
import coldfusion.server.DebuggingService;
import coldfusion.server.JaxRsService;
import coldfusion.server.RuntimeService;
import coldfusion.server.SecurityService;
import coldfusion.server.ServiceFactory;
import coldfusion.serverless.ServerlessUtil;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.FastHashtable;
import coldfusion.util.RB;
import coldfusion.util.URLEncoder;
import coldfusion.xml.rpc.BaseSkeletonClassLoader;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.internal.Errors;

public class CFRestServlet
extends HttpServlet {
    private static CFRestServlet cfRestServlet;
    private static CFRestServletContainer defaultContainer;
    private static JaxRsService service;
    private final Map containers = new CaseInsensitiveMap();
    private final Map containersPairs = new CaseInsensitiveMap();
    private static final Set<String> MULTI_READ_HTTP_METHODS;

    public void init(ServletConfig config) throws ServletException {
        super.init((ServletConfig)new ServletConfigWrapper(config));
        cfRestServlet = this;
        service = ServiceFactory.getJaxRsService();
        this.setupLogger();
        ServletContext application = this.getServletConfig().getServletContext();
        String web_inf = application.getRealPath("/WEB-INF");
        if (ServerlessUtil.isLambdaEnv()) {
            web_inf = "/tmp/cfusion/wwwroot/WEB-INF";
        }
        if (web_inf == null) {
            throw new ServletException(RB.getString((Object)this, "CFRestServlet.NoWEBINF"));
        }
        File dir = new File(web_inf + File.separator + "rest-skeletons");
        dir.mkdirs();
        application.setAttribute("coldfusion.rest.servlet.CFRestServlet.outputdir", (Object)dir.getPath());
        this.initContainerPairs();
    }

    private void initContainerPairs() {
        FastHashtable pairs = service.getRestServices();
        boolean allowRestDiscovery = ServiceFactory.getRuntimeService().isAllowRestDiscovery();
        for (Object value : pairs.values().toArray()) {
            AppNameRootPair pair = (AppNameRootPair)value;
            this.containersPairs.put(RestAppAdapter.getAppKey(pair), pair);
            if (allowRestDiscovery && pair.isGenrateRestDoc()) {
                try {
                    this.initRestApplication(pair, pair.isDefaultApplication());
                }
                catch (ServletException e) {
                    e.printStackTrace();
                }
                continue;
            }
            pair.setUnInitialized();
        }
    }

    private void setupLogger() {
        RestLogHandler handler = new RestLogHandler(CFLogs.RESTSERVICE_LOG);
        Logger logger = Logger.getLogger("com.sun.jersey");
        logger.addHandler(handler);
        logger.setUseParentHandlers(false);
        logger.setLevel(Level.WARNING);
        logger = Logger.getLogger("jakarta.ws.rs");
        logger.addHandler(handler);
        logger.setUseParentHandlers(false);
        logger.setLevel(Level.WARNING);
    }

    public void initRestApplication(AppNameRootPair pair, boolean isDefault) throws ServletException {
        String host;
        boolean isDefApp;
        CFRestServletContainer servlet;
        String appName;
        String string = appName = isDefault ? "" : RestAppAdapter.getAppName(pair);
        if (!isDefault && (servlet = (CFRestServletContainer)((Object)this.containers.get(RestAppAdapter.getAppKey(pair)))) != null && (isDefApp = pair.isDefaultApplication()) && (null == (host = pair.getHost()) || host.trim().length() == 0)) {
            throw new MultipleDefaultApplicationException("default");
        }
        try {
            servlet = CFRestServletContainer.getServletContainer(appName, RestAppAdapter.getRestDirectory(pair), this.getServletConfig(), RestAppAdapter.getSkipCFCOnError(pair), pair);
            if (System.getSecurityManager() == null) {
                servlet.init();
            } else {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        servlet.init();
                        return null;
                    }
                });
            }
            if (isDefault) {
                defaultContainer = servlet;
            } else {
                this.containers.put(RestAppAdapter.getAppKey(pair), servlet);
                this.containersPairs.put(RestAppAdapter.getAppKey(pair), pair);
                CFLogs.RESTSERVICE_LOG.info(RB.getString((Object)this, "CFServlet.RestAppStarted", new Object[]{pair.getAppName()}));
            }
        }
        catch (Exception e) {
            CFLogs.RESTSERVICE_LOG.error(RB.getString((Object)this, "CFServlet.ErrorOnInitializing", new Object[]{pair.getAppName(), e.getMessage()}), e);
        }
    }

    public void refreshRestApplication(String servicemappingName) throws Exception {
        JaxRsService service = ServiceFactory.getJaxRsService();
        service.refreshApplicationByName(servicemappingName);
    }

    public void refreshRestApplication(AppNameRootPair newPair) throws Exception {
        this.refreshRestApplication(newPair, null, false);
    }

    public void refreshDefaultRestApplication(AppNameRootPair newPair) throws ServletException {
        CFRestServletContainer servlet = (CFRestServletContainer)((Object)this.containers.get(RestAppAdapter.getAppKey(newPair)));
        if (servlet != null) {
            defaultContainer = servlet;
        }
    }

    public void refreshRestApplication(AppNameRootPair newPair, AppNameRootPair oldPair, boolean register) throws Exception {
        boolean isDefApp;
        String oldAppKey;
        CFRestServletContainer oldServlet;
        if (newPair == null) {
            return;
        }
        if (oldPair == null) {
            oldPair = newPair;
        }
        if ((oldServlet = (CFRestServletContainer)((Object)this.containers.get(oldAppKey = RestAppAdapter.getAppKey(oldPair)))) != null && register && (isDefApp = oldPair.isDefaultApplication())) {
            String host = oldPair.getHost();
            if (null == host || host.trim().length() == 0) {
                throw new MultipleDefaultApplicationException("default");
            }
            throw new MultipleDefaultApplicationException(host);
        }
        String newAppKey = RestAppAdapter.getAppKey(newPair);
        String newAppName = RestAppAdapter.getAppName(newPair);
        if (!oldAppKey.equalsIgnoreCase(newAppKey) && (oldServlet = (CFRestServletContainer)((Object)this.containers.get(newAppKey))) != null) {
            boolean isDefApp2 = newPair.isDefaultApplication();
            if (isDefApp2) {
                String host = newPair.getHost();
                if (null == host || host.trim().length() == 0) {
                    throw new MultipleDefaultApplicationException("default");
                }
                throw new MultipleDefaultApplicationException(host);
            }
            throw new DuplicateApplicationException(newAppName);
        }
        this.containers.remove(oldAppKey);
        this.containersPairs.remove(oldAppKey);
        this.removeRestServiceJSON(oldPair);
        try {
            final CFRestServletContainer servlet = CFRestServletContainer.getServletContainer(newAppName, RestAppAdapter.getRestDirectory(newPair), this.getServletConfig(), RestAppAdapter.getSkipCFCOnError(newPair), newPair);
            try {
                FusionContext.getCurrent().setRestRefreshApplication(newAppKey);
                BaseSkeletonClassLoader.resetLoadedClasses(newPair.getAppName());
                if (System.getSecurityManager() == null) {
                    servlet.init();
                } else {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            servlet.init();
                            return null;
                        }
                    });
                }
                this.containers.put(newAppKey, servlet);
                this.containersPairs.put(newAppKey, newPair);
            }
            catch (Exception e) {
                servlet.destroy();
                throw e;
            }
        }
        catch (Exception e) {
            Throwable causeException = e.getCause();
            DebuggingService debuggingService = ServiceFactory.getDebuggingService();
            if (e instanceof Errors.ErrorMessagesException) {
                StringBuffer sb = new StringBuffer();
                List list = ((Errors.ErrorMessagesException)e).getMessages();
                for (int i = 0; i < list.size(); ++i) {
                    Errors.ErrorMessage msg = (Errors.ErrorMessage)list.get(i);
                    try {
                        Field pkgStringField = msg.getClass().getDeclaredField("message");
                        pkgStringField.setAccessible(true);
                        String fieldValue = (String)pkgStringField.get(msg);
                        Field pkgIsFatalField = msg.getClass().getDeclaredField("isFatal");
                        pkgIsFatalField.setAccessible(true);
                        boolean isFatal = Boolean.valueOf((String)pkgIsFatalField.get(msg));
                        if (fieldValue != null && isFatal) {
                            sb.append(fieldValue);
                        }
                        if (isFatal || fieldValue == null) continue;
                        CFLogs.RESTSERVICE_LOG.warn(fieldValue);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw new RESTApplicationInitException(e, sb.toString(), newAppName);
            }
            if ((causeException instanceof ParseException || causeException instanceof CfJspPage.NoSuchTemplateException) && !(e instanceof RuntimeException) && debuggingService != null && debuggingService.isDeveloperEnabled()) {
                throw new CFRestHTTPException(e);
            }
            throw new RESTApplicationInitException(e, newAppName);
        }
    }

    public void deleteRestApplication(AppNameRootPair pair) {
        if (pair == null) {
            return;
        }
        CFRestServletContainer servlet = (CFRestServletContainer)((Object)this.containers.get(RestAppAdapter.getAppKey(pair)));
        if (servlet != null) {
            this.containers.remove(RestAppAdapter.getAppKey(pair));
            this.containersPairs.remove(RestAppAdapter.getAppKey(pair));
            this.removeRestServiceJSON(pair);
            servlet.destroy();
        }
    }

    public void deleteRestApplication(String appName) {
        JaxRsService service = ServiceFactory.getJaxRsService();
        service.unregisterApplicationAppName(appName);
    }

    public void deleteDefaultRestApplication(boolean destroy) {
        if (defaultContainer == null) {
            return;
        }
        if (destroy) {
            defaultContainer.destroy();
        }
        defaultContainer = null;
    }

    public static CFRestServlet getCFRestServlet() {
        return cfRestServlet;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FusionFilter filter = this.getFilterChain(request);
        this.invoke(filter, this.getFusionContext(request, response));
    }

    private void invoke(FusionFilter filter, FusionContext context) throws IOException, ServletException {
        FusionContext oldCtx = FusionContext.setCurrent(context);
        try {
            filter.invoke(context);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (ServletException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new ServletException(ex);
        }
        finally {
            FusionContext.setCurrent(oldCtx);
            RequestLifecycleListener.onRequestEnd(2, null);
        }
    }

    public void invoke(String host, String applicationName, HttpServletRequest request, HttpServletResponse response) throws MissingResourceException, ServletException, IOException {
        File applicationRootF;
        File[] files;
        Object appNames;
        String url = request.getRequestURL().toString();
        applicationName = URLDecoder.decode(applicationName, "UTF-8");
        String requestURI = request.getHeader("Origin");
        if (requestURI != null) {
            boolean isDeveloperEnabled;
            String referrerhost = "";
            int pathAfterProtocolIndex = requestURI.indexOf("//");
            try {
                if (pathAfterProtocolIndex != -1) {
                    String pathAfterProtocol = requestURI.substring(pathAfterProtocolIndex + 2);
                    referrerhost = pathAfterProtocol.substring(0, pathAfterProtocol.length());
                }
            }
            catch (Exception pathAfterProtocol) {
                // empty catch block
            }
            DebuggingService debuggingService = ServiceFactory.getDebuggingService();
            boolean bl = isDeveloperEnabled = debuggingService != null && debuggingService.isDeveloperEnabled();
            if (!url.contains(referrerhost) && isDeveloperEnabled) {
                response.setHeader("Access-Control-Allow-Origin", "*");
                response.setHeader("Access-Control-Allow-Methods", request.getHeader("Access-Control-Request-Method"));
            }
        }
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        String apps = request.getParameter("apps");
        String isRefresh = request.getParameter("refresh");
        String serviceDirPath = request.getParameter("servicedirpath");
        String servicemapping = request.getParameter("servicemapping");
        servicemapping = ESAPIUtils.encodeForHTML(servicemapping, false);
        if (url.endsWith("/restapps/register") || url.endsWith("/restapps/register/")) {
            if (!this.getRestPlayAccessAllowed()) {
                String message = RB.getString((Object)this, "CFRestServlet.RestPlayAccessNotAllowed");
                response.setStatus(401);
                response.getWriter().write(message);
                return;
            }
            String useHost = request.getParameter("usehost");
            String isDefault = request.getParameter("isdefault");
            String hostReg = request.getParameter("host");
            HashMap<String, String> options = new HashMap<String, String>();
            if (useHost != null) {
                options.put("usehost", useHost);
            }
            if (isDefault != null) {
                options.put("isDefault", isDefault);
            }
            if (hostReg != null) {
                options.put("host", hostReg);
            }
            if (serviceDirPath != null) {
                try {
                    this.RestInitApplication(serviceDirPath, servicemapping, options);
                    if (servicemapping == null || servicemapping != null && servicemapping.equals("")) {
                        servicemapping = ((AppNameRootPair)service.getRestServices().get(serviceDirPath)).getAppName();
                    }
                    CFLogs.AUDIT_LOG.info("Registered REST service : " + servicemapping + " from REST Playground application.");
                }
                catch (Exception e) {
                    String errorMsg;
                    DebuggingService debuggingService = ServiceFactory.getDebuggingService();
                    if (e instanceof RESTApplicationInitException) {
                        errorMsg = ((RESTApplicationInitException)e).getDetailedMessage();
                    } else if (e instanceof ApplicationException) {
                        errorMsg = ((ApplicationException)e).getDetail();
                    } else {
                        if (e instanceof CFRestHTTPException && debuggingService != null && debuggingService.isDeveloperEnabled()) {
                            throw new CFRestHTTPException(e);
                        }
                        errorMsg = e.getMessage();
                    }
                    String error = "{\"statuscode\": \"500\",\"error\": \"" + URLEncoder.encode(errorMsg, "UTF-8") + "\"}";
                    response.setStatus(500);
                    response.getWriter().write(error);
                }
                return;
            }
        } else if (url.endsWith("/restapps/delete") || url.endsWith("/restapps/delete/")) {
            if (!this.getRestPlayAccessAllowed()) {
                String message = RB.getString((Object)this, "CFRestServlet.RestPlayAccessNotAllowed");
                response.setStatus(401);
                response.getWriter().write(message);
                return;
            }
            String serviceMapping = request.getParameter("applicationmapping");
            if (serviceMapping != null) {
                try {
                    this.deleteRestApplication(serviceMapping);
                    CFLogs.AUDIT_LOG.info("Deleted REST service : " + serviceMapping + " from restplay application.");
                }
                catch (Exception e) {
                    String errorMsg = e instanceof RESTApplicationInitException ? ((RESTApplicationInitException)e).getDetailedMessage() : e.getMessage();
                    String error = "{\"statuscode\": \"500\",\"error\": \"" + URLEncoder.encode(errorMsg, "UTF-8") + "\"}";
                    response.setStatus(500);
                    response.getWriter().write(error);
                }
                return;
            }
        } else if (url.endsWith("/restapps/config") || url.endsWith("/restapps/config/")) {
            String webxmlPath = request.getSession().getServletContext().getRealPath("/WEB-INF") + "/web.xml";
            String restPath = RESTPathUpdate.getRESTURLPattern(webxmlPath);
            String config = "{\"resturlpattern\": \"" + restPath + "\"}";
            response.getWriter().write(config);
            return;
        }
        SecurityService securityService = ServiceFactory.getSecurityService();
        String configServPath = request.getServletPath();
        if ((url.endsWith("/restplay") || url.endsWith("/restplay/")) && url.contains(configServPath + "/")) {
            String path = url.substring(url.indexOf(configServPath) + configServPath.length(), url.indexOf("/restplay"));
            response.sendRedirect(String.format("%s%s", request.getContextPath(), "/restplay/#/home?path=" + path));
            return;
        }
        if (apps == null && (url.endsWith(configServPath) || url.endsWith(configServPath + "/")) && !ServerlessUtil.isLambdaEnv()) {
            if (!this.getRestPlayAccessAllowed() || !ServiceFactory.getRuntimeService().isAllowRestDiscovery()) {
                String messageEr = RB.getString((Object)this, "CFRestServlet.RestPlayAccessNotAllowed");
                response.setStatus(401);
                response.getWriter().write(messageEr);
                return;
            }
            appNames = this.getRestServicesListFromConf();
            StringBuffer allmappingdeatails = new StringBuffer();
            boolean isFirstMapping = true;
            allmappingdeatails.append("[");
            for (int i = 0; i < appNames.size(); ++i) {
                Object mappingdeatails = "";
                String error = "";
                String serviceMapping = (String)appNames.get(i);
                try {
                    this.refreshRestApplication(serviceMapping);
                }
                catch (Exception e) {
                    error = e instanceof RESTApplicationInitException ? ((RESTApplicationInitException)e).getDetailedMessage() : e.getMessage();
                }
                mappingdeatails = error.length() > 0 ? "{\"name\": \"" + serviceMapping + "\",\"status\": \"error\",\"message\": \"" + URLEncoder.encode(error, "UTF-8") + "\"}" : "{\"name\": \"" + serviceMapping + "\",\"status\": \"\",\"message\": \"\"}";
                if (isFirstMapping) {
                    allmappingdeatails.append((String)mappingdeatails);
                } else {
                    allmappingdeatails.append("," + (String)mappingdeatails);
                }
                isFirstMapping = false;
            }
            allmappingdeatails.append("]");
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(allmappingdeatails.toString());
            return;
        }
        if (securityService.checkAdminUserIdPassword(username, password, true)) {
            String message = this.getRestServicesJSONFromConf();
            response.getWriter().write(message);
            return;
        }
        if (apps != null) {
            if (isRefresh != null && isRefresh.equals("true")) {
                appNames = new StringTokenizer(apps, ",");
                StringBuffer errorMsg = new StringBuffer();
                while (((StringTokenizer)appNames).hasMoreTokens()) {
                    String serviceMapping = ((StringTokenizer)appNames).nextToken();
                    try {
                        this.refreshRestApplication(serviceMapping);
                    }
                    catch (Exception e) {
                        if (e instanceof RESTApplicationInitException) {
                            errorMsg.append(((RESTApplicationInitException)e).getDetailedMessage());
                            continue;
                        }
                        if (e instanceof CFRestHTTPException) {
                            throw new CFRestHTTPException(e);
                        }
                        errorMsg.append(e.getMessage());
                    }
                }
                if (errorMsg.length() > 0) {
                    String error = "{\"statuscode\": \"500\",\"error\": \"" + URLEncoder.encode(errorMsg.toString(), "UTF-8") + "\"}";
                    response.setStatus(500);
                    response.getWriter().write(error);
                    return;
                }
            }
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(this.getRestServicesJSON(apps));
            return;
        }
        RuntimeService runtime = ServiceFactory.getRuntimeService();
        boolean isTrustedCache = runtime.isTrustedCache();
        if (isTrustedCache && this.serviceUsingAlreadyInitializedContainers(host, applicationName, request, response)) {
            return;
        }
        boolean modFilesExist = false;
        JaxRsService service = ServiceFactory.getJaxRsService();
        AppNameRootPair pair = service.getAppNameRootPair(applicationName);
        if (pair != null && (files = (applicationRootF = pair.getAppRoot()).listFiles()) != null) {
            for (File file : files) {
                long lastModTime;
                long compiledTime;
                String path;
                if (file.isDirectory() || !(path = file.getAbsolutePath()).endsWith(".cfc") || (compiledTime = TemplateClassLoader.getLastCompiledTime(path)) == (lastModTime = TemplateClassLoader.getLastModifiedTime(path)) && lastModTime != 0L) continue;
                modFilesExist = true;
                break;
            }
        }
        boolean serviced = false;
        if (modFilesExist) {
            StringBuffer errorMsg = new StringBuffer();
            try {
                this.refreshRestApplication(applicationName);
            }
            catch (Exception e) {
                if (e instanceof RESTApplicationInitException) {
                    errorMsg.append(((RESTApplicationInitException)e).getDetailedMessage());
                }
                if (e instanceof CFRestHTTPException) {
                    throw new CFRestHTTPException(e);
                }
                errorMsg.append(e.getMessage());
            }
            if (errorMsg.length() > 0) {
                response.setStatus(500);
                response.getWriter().write(errorMsg.toString());
                return;
            }
            serviced = this.serviceUsingUninitializedContainers(host, applicationName, request, response);
        } else {
            serviced = this.serviceUsingAlreadyInitializedContainers(host, applicationName, request, response);
        }
        if (!serviced) {
            serviced = this.serviceUsingUninitializedContainers(host, applicationName, request, response);
        }
        if (serviced) {
            return;
        }
        if (service.getDefaultApp() != null && service.getDefaultApp().trim().length() > 0 && request.getPathInfo() != null && request.getPathInfo().length() > 1) {
            if (defaultContainer == null) {
                FastHashtable pairs = service.getRestServices();
                AppNameRootPair defPair = (AppNameRootPair)pairs.get(service.getDefaultApp());
                if (null != defPair) {
                    if (this.containers.get(RestAppAdapter.getAppKey(defPair)) != null) {
                        this.refreshDefaultRestApplication(defPair);
                    } else {
                        this.initRestApplication(defPair, true);
                    }
                    defaultContainer.service(request, response, true);
                }
            } else {
                defaultContainer.service(request, response, true);
            }
        } else {
            if (applicationName.equalsIgnoreCase("_cf__default_")) {
                applicationName = "";
            }
            throw new ServletException(RB.getString((Object)this, "CFRestServlet.ApplicationNotFound", new Object[]{applicationName}));
        }
    }

    private void RestInitApplication(String dirPath, String serviceMapping, Map options) throws Exception {
        String host;
        RequestMonitorEventProcessor.onFunctionStart("RestInitApplication");
        if (serviceMapping == null) {
            serviceMapping = "";
        }
        boolean useHost = false;
        String useHostStr = (String)options.get("useHost");
        if (null != useHostStr) {
            useHost = Cast._boolean(useHostStr);
        }
        if (null != (host = (String)options.get("host")) && host.trim().length() > 0) {
            host = host.trim();
        } else if (useHost) {
            HttpServletRequest request = FusionContext.getCurrent().getRequest();
            host = this.getHostFromRequestURL(request);
        }
        boolean isDefApp = false;
        String isDefAppStr = (String)options.get("isDefault");
        if (null != isDefAppStr) {
            isDefApp = Cast._boolean(isDefAppStr);
        }
        JaxRsService service = ServiceFactory.getJaxRsService();
        service.updateApplication(dirPath, dirPath, serviceMapping, false, isDefApp, true, host, false, true);
        RequestMonitorEventProcessor.onFunctionEnd("RestInitApplication");
    }

    private String getHostFromRequestURL(HttpServletRequest request) {
        StringBuffer requestURI = request.getRequestURL();
        String pathAfterProtocol = requestURI.substring(requestURI.indexOf("//") + 2);
        String host = pathAfterProtocol.substring(0, pathAfterProtocol.indexOf("/"));
        return host;
    }

    public String getRestServicesJSONFromConf() {
        if (ServiceFactory.getRuntimeService().isAllowRestDiscovery()) {
            ArrayList<String> restServices = new ArrayList<String>();
            FastHashtable pairs = service.getRestServices();
            Set keys = pairs.keySet();
            for (String key : keys) {
                AppNameRootPair servicepair = (AppNameRootPair)pairs.get(key);
                String name = servicepair.getAppName();
                restServices.add(name);
            }
            return JSONUtils.serializeJSON(restServices, "row");
        }
        String messageEr = RB.getString((Object)this, "CFRestServlet.RestPlayAccessNotAllowed");
        return messageEr;
    }

    public List getRestServicesListFromConf() {
        ArrayList<String> restServices = null;
        if (ServiceFactory.getRuntimeService().isAllowRestDiscovery()) {
            restServices = new ArrayList<String>();
            FastHashtable pairs = service.getRestServices();
            Set keys = pairs.keySet();
            for (String key : keys) {
                AppNameRootPair servicepair = (AppNameRootPair)pairs.get(key);
                String name = servicepair.getAppName();
                restServices.add(name);
            }
        }
        return restServices;
    }

    public boolean getRestPlayAccessAllowed() {
        return ServiceFactory.getRuntimeService().isAllowRestPlayAccess();
    }

    public String getRestServicesJSON(String serviceNames) {
        StringTokenizer appNames = new StringTokenizer(serviceNames, ",");
        Map restServicesMap = (Map)this.getServletContext().getAttribute("cfrestservices");
        if (restServicesMap != null) {
            HashMap restInfo = null;
            String serviceName = "";
            Object apis = "";
            while (appNames.hasMoreTokens()) {
                serviceName = appNames.nextToken();
                for (String appName : restServicesMap.keySet()) {
                    if (appName.endsWith("_hostinurl") || !serviceName.equals(appName)) continue;
                    restInfo = (HashMap)restServicesMap.get(appName);
                    break;
                }
                boolean isdefault = false;
                String host = "";
                if (restInfo == null && serviceName != null) {
                    Map<String, String> alldefs = service.getAllDefaultApps();
                    String name = null;
                    Collection<String> values = alldefs.values();
                    for (String internalSrvcName : values) {
                        AppNameRootPair servicepair = (AppNameRootPair)this.containersPairs.get(internalSrvcName);
                        if (servicepair == null || (name = servicepair.getAppName()) == null || !name.equals(serviceName)) continue;
                        isdefault = true;
                        host = internalSrvcName;
                        restInfo = (HashMap)restServicesMap.get("DefaultApplication");
                        break;
                    }
                }
                if (restInfo == null) continue;
                Set appkeys = this.containersPairs.keySet();
                for (String keywithhost : appkeys) {
                    AppNameRootPair servicepair;
                    String hostfromsvc;
                    if (!keywithhost.endsWith(serviceName) || !((hostfromsvc = (servicepair = (AppNameRootPair)this.containersPairs.get(keywithhost)).getHost()) + serviceName).equals(keywithhost)) continue;
                    host = hostfromsvc;
                    isdefault = servicepair.isDefaultApplication();
                    break;
                }
                String apistele = "{\"appname\":\"" + serviceName + "\",\"host\":\"" + host + "\",\"isdefault\":" + isdefault + ",\"resources\":{";
                Object api = "";
                for (Object appName : restInfo.keySet()) {
                    if (appName instanceof String && appName.equals("api-docs")) continue;
                    api = ((String)apis).indexOf(apistele) == -1 ? apistele + "\"" + appName.toString().substring(1) + "\": " + restInfo.get(appName).toString() : "\"" + appName.toString().substring(1) + "\": " + restInfo.get(appName).toString();
                    if (((String)apis).isEmpty()) {
                        apis = (String)apis + (String)api;
                        continue;
                    }
                    apis = (String)apis + "," + (String)api;
                }
                apis = (String)apis + "}}";
            }
            return "[" + (String)apis + "]";
        }
        return "";
    }

    public String getSwaggerJSON(String name) {
        Object apiDocs;
        Map restServicesMap = (Map)this.getServletContext().getAttribute("cfrestservices");
        if (restServicesMap.containsKey(name) && (apiDocs = ((Map)restServicesMap.get(name)).get("api-docs")) != null) {
            return apiDocs.toString();
        }
        return "";
    }

    public String getSwaggerJSON(String name, String param) {
        Map restServicesMap = (Map)this.getServletContext().getAttribute("cfrestservices");
        Map swaggerMap = (Map)restServicesMap.get(name);
        if (param != null && !((String)param).startsWith("/")) {
            param = "/" + (String)param;
        }
        if (swaggerMap.containsKey(param)) {
            Map swaggerMapWithHost = (Map)restServicesMap.get(name + "_hostinurl");
            if (name.equalsIgnoreCase("DefaultApplication")) {
                name = "";
            }
            if (swaggerMapWithHost != null) {
                return swaggerMap.get(param).toString().replace("\"basePath\":\"$\"", "\"basePath\":\"" + swaggerMapWithHost.get("basePath") + "\"");
            }
            return swaggerMap.get(param).toString().replace("\"basePath\":\"$\"", "\"basePath\":\"/" + name + "\"");
        }
        return "";
    }

    private void removeRestServiceJSON(AppNameRootPair pair) {
        Map restServicesMap = (Map)this.getServletContext().getAttribute("cfrestservices");
        String name = RestAppAdapter.getAppKey(pair);
        if (restServicesMap != null) {
            if (pair.isDefaultApplication()) {
                restServicesMap.remove("DefaultApplication");
                restServicesMap.remove("DefaultApplication_hostinurl");
            } else {
                String removeAppKey = RestAppAdapter.getAppKey(pair).replace(pair.getHost(), "");
                restServicesMap.remove(removeAppKey);
                restServicesMap.remove(removeAppKey + "_hostinurl");
            }
        }
    }

    private boolean serviceUsingUninitializedContainers(String host, String applicationName, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        CFRestServletContainer cfRestServletContainer;
        AppNameRootPair pair;
        Object finalAppName = applicationName;
        if (null != host && host.length() != 0) {
            finalAppName = host + (String)finalAppName;
        }
        if ((pair = (AppNameRootPair)this.containersPairs.get(finalAppName)) != null) {
            this.initRestApplication(pair, false);
            cfRestServletContainer = (CFRestServletContainer)((Object)this.containers.get(RestAppAdapter.getAppKey(pair)));
            if (null != cfRestServletContainer) {
                cfRestServletContainer.service(request, response);
                return true;
            }
        }
        if ((pair = (AppNameRootPair)this.containersPairs.get(finalAppName = applicationName)) != null) {
            this.initRestApplication(pair, false);
            cfRestServletContainer = (CFRestServletContainer)((Object)this.containers.get(RestAppAdapter.getAppKey(pair)));
            if (null != cfRestServletContainer) {
                cfRestServletContainer.service(request, response);
                return true;
            }
        }
        if (null != host && host.length() != 0 && (pair = (AppNameRootPair)this.containersPairs.get(finalAppName = host)) != null) {
            this.initRestApplication(pair, false);
            cfRestServletContainer = (CFRestServletContainer)((Object)this.containers.get(RestAppAdapter.getAppKey(pair)));
            if (null != cfRestServletContainer) {
                cfRestServletContainer.service(request, response, true);
                return true;
            }
        }
        return false;
    }

    private boolean serviceUsingAlreadyInitializedContainers(String host, String applicationName, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        CFRestServletContainer cfRestServletContainer;
        Object finalAppName = applicationName;
        if (null != host && host.length() != 0) {
            finalAppName = host + (String)finalAppName;
        }
        if (null != (cfRestServletContainer = (CFRestServletContainer)((Object)this.containers.get(finalAppName)))) {
            cfRestServletContainer.service(request, response);
            return true;
        }
        finalAppName = applicationName;
        cfRestServletContainer = (CFRestServletContainer)((Object)this.containers.get(finalAppName));
        if (null != cfRestServletContainer) {
            cfRestServletContainer.service(request, response);
            return true;
        }
        if (null != host && host.length() != 0 && null != (cfRestServletContainer = (CFRestServletContainer)((Object)this.containers.get(finalAppName = host)))) {
            cfRestServletContainer.service(request, response, true);
            return true;
        }
        return false;
    }

    private FusionContext getFusionContext(HttpServletRequest request, HttpServletResponse response) {
        FusionContext context = new FusionContext();
        context.setServletObjects((Servlet)this, (ServletRequest)request, (ServletResponse)response);
        context.setIsRemoting(true);
        return context;
    }

    private FusionFilter getFilterChain(HttpServletRequest request) {
        FusionFilter filter = new RestFilter(this);
        if (LicenseManager.isSingleIP()) {
            filter = new LicenseFilter(filter);
        }
        filter = new ExceptionFilter(filter);
        filter = new ClientScopePersistenceFilter(filter);
        boolean needsFormScope = true;
        filter = new GlobalsFilter(filter, true);
        filter = new DatasourceFilter(filter);
        if (MULTI_READ_HTTP_METHODS.contains(request.getMethod())) {
            filter = new RestWrapRequestFilter(filter);
        }
        return filter;
    }

    static {
        defaultContainer = null;
        service = null;
        MULTI_READ_HTTP_METHODS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER){
            {
                this.add("PUT");
                this.add("POST");
            }
        };
    }

    public static class MultipleDefaultApplicationException
    extends ApplicationException {
        public String host;

        public MultipleDefaultApplicationException(String host) {
            this.host = host;
        }
    }

    public static class DuplicateApplicationException
    extends ApplicationException {
        public String name;

        public DuplicateApplicationException(String name) {
            this.name = name;
        }
    }

    public static class RESTApplicationInitException
    extends ApplicationException {
        public String name;
        public String message;

        public RESTApplicationInitException(Exception ex, String name) {
            super(ex);
            Throwable cause = ex.getCause();
            StringBuilder sb = new StringBuilder();
            if (cause != null && cause instanceof ApplicationException) {
                sb.append(((ApplicationException)cause).getMessage()).append(" ").append(((ApplicationException)cause).getDetail());
            } else if (cause != null && cause instanceof RuntimeException) {
                sb.append(((RuntimeException)cause).getMessage());
            }
            String message = "";
            if (sb.length() > 0) {
                message = sb.toString().replace("<p>}</p><p>", "").replace("<ul><li>", "").replace("</ul>", "");
            }
            this.message = ex.getLocalizedMessage() + message;
            this.name = name;
        }

        public RESTApplicationInitException(Exception ex, String msg, String name) {
            super(ex);
            this.message = msg;
            this.name = name;
        }

        public String getDetailedMessage() {
            return this.message;
        }
    }

    public static class RecursiveApplicationInitializationException
    extends ApplicationException {
        public String appPath;

        public RecursiveApplicationInitializationException(String appPath) {
            this.appPath = appPath;
        }
    }
}

