/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rest.utils;

import coldfusion.centralconfig.client.CentralConfigClientUtil;
import coldfusion.log.CFLogs;
import coldfusion.util.WebEntityResolver;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RESTPathUpdate {
    public static void updateWebXml(String webxmlPath, String restUrlPattern) {
        RESTPathUpdate.updateWebXml(webxmlPath, restUrlPattern, true);
    }

    public static void updateWebXml(String webxmlPath, String restUrlPattern, boolean broadcast) {
        String restUrlPatternMod = RESTPathUpdate.sanitizeRestURLPattern(restUrlPattern);
        File fXmlFile = new File(webxmlPath);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setValidating(false);
        try (FileInputStream fis = new FileInputStream(fXmlFile);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            dBuilder.setEntityResolver(new WebEntityResolver(RESTPathUpdate.getPropertiesObject(webxmlPath)));
            Document document = dBuilder.parse(bis);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xpath = xPathFactory.newXPath();
            String servletMappingId = "coldfusion_mapping_rest";
            String expression = String.format("//*[@id='%s']", servletMappingId);
            NodeList servletMappingList = (NodeList)xpath.compile(expression).evaluate(document, XPathConstants.NODESET);
            boolean update = false;
            for (int i = 0; i < servletMappingList.getLength(); ++i) {
                Element servletMappingExt = (Element)servletMappingList.item(i);
                if (servletMappingExt == null) continue;
                Node urlNode = null;
                NodeList nodeList = servletMappingExt.getChildNodes();
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    Node chNode = nodeList.item(j);
                    String nodeName = chNode.getNodeName();
                    if (nodeName.equals("url-pattern")) {
                        urlNode = chNode;
                    }
                    if (!nodeName.equals("servlet-name") || !chNode.getTextContent().equalsIgnoreCase("CFRestServlet")) continue;
                    update = true;
                }
                if (!update) continue;
                urlNode.setTextContent(restUrlPatternMod);
            }
            if (update) {
                RESTPathUpdate.writeXmlFile(document, webxmlPath);
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException ex) {
            CFLogs.SERVER_LOG.error(ex);
        }
        if (broadcast) {
            try {
                CentralConfigClientUtil.pushActionToCCS("updaterestpath", restUrlPattern);
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.error(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getRESTURLPattern(String webxmlPath) {
        File fXmlFile = new File(webxmlPath);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setValidating(false);
        try (FileInputStream fis = new FileInputStream(fXmlFile);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            dBuilder.setEntityResolver(new WebEntityResolver(RESTPathUpdate.getPropertiesObject(webxmlPath)));
            Document document = dBuilder.parse(bis);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xpath = xPathFactory.newXPath();
            String servletMappingId = "coldfusion_mapping_rest";
            String expression = String.format("//*[@id='%s']", servletMappingId);
            NodeList servletMappingList = (NodeList)xpath.compile(expression).evaluate(document, XPathConstants.NODESET);
            int i = 0;
            while (i < servletMappingList.getLength()) {
                Element servletMappingExt = (Element)servletMappingList.item(i);
                if (servletMappingExt != null) {
                    Node urlNode = null;
                    NodeList nodeList = servletMappingExt.getChildNodes();
                    for (int j = 0; j < nodeList.getLength(); ++j) {
                        Node chNode = nodeList.item(j);
                        String nodeName = chNode.getNodeName();
                        if (!nodeName.equals("url-pattern")) continue;
                        urlNode = chNode;
                        String path = chNode.getTextContent();
                        String string = path.replace("/", "").replace("*", "");
                        return string;
                    }
                }
                ++i;
            }
            return "rest";
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException ex) {
            CFLogs.SERVER_LOG.error(ex);
        }
        return "rest";
    }

    public static void writeXmlFile(Document doc, String filename) {
        try {
            try {
                Files.copy(new File(filename).toPath(), new File(filename + "/../web.xml.bak").toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            DOMSource source = new DOMSource(doc);
            File file = new File(filename);
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("indent", "yes");
            DocumentType doctype = doc.getDoctype();
            if (doctype != null) {
                xformer.setOutputProperty("doctype-public", doctype.getPublicId());
                xformer.setOutputProperty("doctype-system", doctype.getSystemId());
            }
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    private static String sanitizeRestURLPattern(String restUrlPattern) {
        String restUrlPatternMod = null;
        if (restUrlPattern.charAt(0) != '/') {
            restUrlPatternMod = "/" + restUrlPattern;
        }
        if (!restUrlPattern.endsWith("/*")) {
            restUrlPatternMod = restUrlPatternMod + (restUrlPattern.endsWith("/") ? "*" : "/*");
        }
        return restUrlPatternMod;
    }

    private static Properties getPropertiesObject(String webxmlPath) {
        Properties props = new Properties();
        try {
            String webAppDTDFilePath = new File(webxmlPath + "/../web-app_2_3.dtd").getCanonicalPath();
            props.setProperty("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", webAppDTDFilePath);
            props.setProperty("web-app_2_3.dtd", webAppDTDFilePath);
        }
        catch (IOException ex) {
            CFLogs.SERVER_LOG.error(ex);
        }
        return props;
    }
}

