/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.AbstractScope;
import coldfusion.runtime.SessionScope;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

final class AppSessionCollection
extends AbstractScope {
    private String mAppName;
    private ConcurrentMap<String, Object> mAppSessionPool;

    public AppSessionCollection(String AppName, ConcurrentMap<String, Object> appSessionPool) {
        this.mAppName = AppName;
        this.mAppSessionPool = appSessionPool;
    }

    private Hashtable getSessions() {
        Hashtable<String, SessionScope> collection = new Hashtable<String, SessionScope>();
        Set keySet = this.mAppSessionPool.keySet();
        if (keySet != null) {
            for (String key : keySet) {
                SessionScope s = (SessionScope)this.mAppSessionPool.get(key);
                if (!s.getAppName().equalsIgnoreCase(this.mAppName)) continue;
                collection.put(key, s);
            }
        }
        return collection;
    }

    @Override
    protected void bind(String name, Object value) {
        Hashtable sessions = this.getSessions();
        sessions.put(name, value);
    }

    @Override
    protected void bind_Final(String name, Object value) {
        this.bind(name, value);
    }

    @Override
    protected void unbind(String name) {
        Hashtable sessions = this.getSessions();
        sessions.remove(name);
    }

    @Override
    protected Object resolve(String name) {
        Hashtable sessions = this.getSessions();
        return sessions.get(name);
    }

    @Override
    public Iterator getNames() {
        Hashtable collection = this.getSessions();
        return collection.keySet().iterator();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

